/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore;

import java.io.Serializable;
import java.util.Objects;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.MappedSuperclass;
import org.axonframework.eventsourcing.DomainEventMessage;
import org.axonframework.eventsourcing.eventstore.AbstractEventEntry;
import org.axonframework.eventsourcing.eventstore.DomainEventData;
import org.axonframework.serialization.Serializer;

@MappedSuperclass
@IdClass(value=PK.class)
public abstract class AbstractSnapshotEventEntry<T>
extends AbstractEventEntry<T>
implements DomainEventData<T> {
    @Id
    private String aggregateIdentifier;
    @Id
    private long sequenceNumber;
    @Id
    private String type;

    public AbstractSnapshotEventEntry(DomainEventMessage<?> eventMessage, Serializer serializer, Class<T> contentType) {
        super(eventMessage, serializer, contentType);
        this.type = eventMessage.getType();
        this.aggregateIdentifier = eventMessage.getAggregateIdentifier();
        this.sequenceNumber = eventMessage.getSequenceNumber();
    }

    public AbstractSnapshotEventEntry(String type, String aggregateIdentifier, long sequenceNumber, String eventIdentifier, Object timestamp, String payloadType, String payloadRevision, T payload, T metaData) {
        super(eventIdentifier, timestamp, payloadType, payloadRevision, payload, metaData);
        this.type = type;
        this.aggregateIdentifier = aggregateIdentifier;
        this.sequenceNumber = sequenceNumber;
    }

    protected AbstractSnapshotEventEntry() {
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getAggregateIdentifier() {
        return this.aggregateIdentifier;
    }

    @Override
    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public static class PK
    implements Serializable {
        private static final long serialVersionUID = 9182347799552520594L;
        private String aggregateIdentifier;
        private long sequenceNumber;
        private String type;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PK pk = (PK)o;
            return this.sequenceNumber == pk.sequenceNumber && Objects.equals(this.aggregateIdentifier, pk.aggregateIdentifier) && Objects.equals(this.type, pk.type);
        }

        public int hashCode() {
            return Objects.hash(this.aggregateIdentifier, this.type, this.sequenceNumber);
        }

        public String toString() {
            return "PK{type='" + this.type + '\'' + ", aggregateIdentifier='" + this.aggregateIdentifier + '\'' + ", sequenceNumber=" + this.sequenceNumber + '}';
        }
    }
}

