/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore;

import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.axonframework.eventhandling.AbstractEventBus;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventsourcing.DomainEventMessage;
import org.axonframework.eventsourcing.eventstore.DomainEventStream;
import org.axonframework.eventsourcing.eventstore.EventStorageEngine;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.eventsourcing.eventstore.TrackingToken;
import org.axonframework.monitoring.MessageMonitor;
import org.axonframework.monitoring.NoOpMessageMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEventStore
extends AbstractEventBus
implements EventStore {
    private static final Logger logger = LoggerFactory.getLogger(AbstractEventStore.class);
    private final EventStorageEngine storageEngine;

    protected AbstractEventStore(EventStorageEngine storageEngine) {
        this(storageEngine, NoOpMessageMonitor.INSTANCE);
    }

    protected AbstractEventStore(EventStorageEngine storageEngine, MessageMonitor<? super EventMessage<?>> messageMonitor) {
        super(messageMonitor);
        this.storageEngine = storageEngine;
    }

    @Override
    protected void prepareCommit(List<? extends EventMessage<?>> events) {
        this.storageEngine.appendEvents(events);
        super.prepareCommit(events);
    }

    @Override
    public DomainEventStream readEvents(String aggregateIdentifier) {
        DomainEventStream eventStream;
        Optional<DomainEventMessage<?>> optionalSnapshot;
        try {
            optionalSnapshot = this.storageEngine.readSnapshot(aggregateIdentifier);
        }
        catch (Exception | LinkageError e) {
            optionalSnapshot = this.handleSnapshotReadingError(aggregateIdentifier, e);
        }
        if (optionalSnapshot.isPresent()) {
            DomainEventMessage<?> snapshot = optionalSnapshot.get();
            eventStream = DomainEventStream.concat(DomainEventStream.of(snapshot), this.storageEngine.readEvents(aggregateIdentifier, snapshot.getSequenceNumber() + 1L));
        } else {
            eventStream = this.storageEngine.readEvents(aggregateIdentifier);
        }
        Stream<? extends DomainEventMessage<?>> domainEventMessages = this.stagedDomainEventMessages(aggregateIdentifier);
        return DomainEventStream.concat(eventStream, DomainEventStream.of(domainEventMessages));
    }

    protected Optional<DomainEventMessage<?>> handleSnapshotReadingError(String aggregateIdentifier, Throwable e) {
        logger.warn("Error reading snapshot for aggregate [{}]. Reconstructing from entire event stream.", (Object)aggregateIdentifier, (Object)e);
        return Optional.empty();
    }

    protected Stream<? extends DomainEventMessage<?>> stagedDomainEventMessages(String aggregateIdentifier) {
        return this.queuedMessages().stream().filter(m -> m instanceof DomainEventMessage).map(m -> (DomainEventMessage)m).filter(m -> aggregateIdentifier.equals(m.getAggregateIdentifier()));
    }

    @Override
    public DomainEventStream readEvents(String aggregateIdentifier, long firstSequenceNumber) {
        return DomainEventStream.concat(this.storageEngine.readEvents(aggregateIdentifier, firstSequenceNumber), DomainEventStream.of(this.stagedDomainEventMessages(aggregateIdentifier).filter(m -> m.getSequenceNumber() >= firstSequenceNumber)));
    }

    @Override
    public void storeSnapshot(DomainEventMessage<?> snapshot) {
        this.storageEngine.storeSnapshot(snapshot);
    }

    protected EventStorageEngine storageEngine() {
        return this.storageEngine;
    }

    @Override
    public Optional<Long> lastSequenceNumberFor(String aggregateIdentifier) {
        Optional<Long> highestStaged = this.stagedDomainEventMessages(aggregateIdentifier).map(DomainEventMessage::getSequenceNumber).max(Long::compareTo);
        if (highestStaged.isPresent()) {
            return highestStaged;
        }
        return this.storageEngine.lastSequenceNumberFor(aggregateIdentifier);
    }

    @Override
    public TrackingToken createTailToken() {
        return this.storageEngine.createTailToken();
    }

    @Override
    public TrackingToken createHeadToken() {
        return this.storageEngine.createHeadToken();
    }

    @Override
    public TrackingToken createTokenAt(Instant dateTime) {
        return this.storageEngine.createTokenAt(dateTime);
    }
}

