/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.axonframework.commandhandling.model.ConcurrencyException;
import org.axonframework.common.ObjectUtils;
import org.axonframework.common.jdbc.PersistenceExceptionResolver;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.TrackedEventMessage;
import org.axonframework.eventsourcing.DomainEventMessage;
import org.axonframework.eventsourcing.eventstore.DomainEventData;
import org.axonframework.eventsourcing.eventstore.DomainEventStream;
import org.axonframework.eventsourcing.eventstore.EventStorageEngine;
import org.axonframework.eventsourcing.eventstore.EventStoreException;
import org.axonframework.eventsourcing.eventstore.EventUtils;
import org.axonframework.eventsourcing.eventstore.TrackedEventData;
import org.axonframework.eventsourcing.eventstore.TrackingToken;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.upcasting.event.EventUpcaster;
import org.axonframework.serialization.upcasting.event.NoOpEventUpcaster;
import org.axonframework.serialization.xml.XStreamSerializer;

public abstract class AbstractEventStorageEngine
implements EventStorageEngine {
    private final Serializer serializer;
    private final EventUpcaster upcasterChain;
    private final PersistenceExceptionResolver persistenceExceptionResolver;
    private final Serializer eventSerializer;
    private final Predicate<? super DomainEventData<?>> snapshotFilter;

    @Deprecated
    protected AbstractEventStorageEngine(Serializer serializer, EventUpcaster upcasterChain, PersistenceExceptionResolver persistenceExceptionResolver) {
        this(serializer, upcasterChain, persistenceExceptionResolver, serializer);
    }

    protected AbstractEventStorageEngine(Serializer snapshotSerializer, EventUpcaster upcasterChain, PersistenceExceptionResolver persistenceExceptionResolver, Serializer eventSerializer) {
        this(snapshotSerializer, upcasterChain, persistenceExceptionResolver, eventSerializer, null);
    }

    protected AbstractEventStorageEngine(Serializer snapshotSerializer, EventUpcaster upcasterChain, PersistenceExceptionResolver persistenceExceptionResolver, Serializer eventSerializer, Predicate<? super DomainEventData<?>> snapshotFilter) {
        this.serializer = (Serializer)((Object)ObjectUtils.getOrDefault(snapshotSerializer, XStreamSerializer::new));
        this.upcasterChain = (EventUpcaster)((Object)ObjectUtils.getOrDefault(upcasterChain, () -> NoOpEventUpcaster.INSTANCE));
        this.persistenceExceptionResolver = persistenceExceptionResolver;
        this.eventSerializer = (Serializer)((Object)ObjectUtils.getOrDefault(eventSerializer, XStreamSerializer::new));
        this.snapshotFilter = ObjectUtils.getOrDefault(snapshotFilter, i -> true);
    }

    @Override
    public Stream<? extends TrackedEventMessage<?>> readEvents(TrackingToken trackingToken, boolean mayBlock) {
        Stream<? extends TrackedEventData<?>> input = this.readEventData(trackingToken, mayBlock);
        return EventUtils.upcastAndDeserializeTrackedEvents(input, this.eventSerializer, this.upcasterChain, true);
    }

    @Override
    public DomainEventStream readEvents(String aggregateIdentifier, long firstSequenceNumber) {
        Stream<? extends DomainEventData<?>> input = this.readEventData(aggregateIdentifier, firstSequenceNumber);
        return EventUtils.upcastAndDeserializeDomainEvents(input, this.eventSerializer, this.upcasterChain, false);
    }

    @Override
    public Optional<DomainEventMessage<?>> readSnapshot(String aggregateIdentifier) {
        return this.readSnapshotData(aggregateIdentifier).filter(this.snapshotFilter).map(entry -> {
            DomainEventStream stream = EventUtils.upcastAndDeserializeDomainEvents(Stream.of(entry), this.serializer, this.upcasterChain, false);
            return stream.hasNext() ? stream.next() : null;
        });
    }

    @Override
    public void appendEvents(List<? extends EventMessage<?>> events) {
        this.appendEvents(events, this.eventSerializer);
    }

    @Override
    public void storeSnapshot(DomainEventMessage<?> snapshot) {
        this.storeSnapshot(snapshot, this.serializer);
    }

    protected void handlePersistenceException(Exception exception, EventMessage<?> failedEvent) {
        String eventDescription;
        if (failedEvent instanceof DomainEventMessage) {
            DomainEventMessage failedDomainEvent = (DomainEventMessage)failedEvent;
            eventDescription = String.format("An event for aggregate [%s] at sequence [%d]", failedDomainEvent.getAggregateIdentifier(), failedDomainEvent.getSequenceNumber());
        } else {
            eventDescription = String.format("An event with identifier [%s]", failedEvent.getIdentifier());
        }
        if (this.persistenceExceptionResolver != null && this.persistenceExceptionResolver.isDuplicateKeyViolation(exception)) {
            throw new ConcurrencyException(eventDescription + " was already inserted", exception);
        }
        throw new EventStoreException(eventDescription + " could not be persisted", exception);
    }

    protected abstract void appendEvents(List<? extends EventMessage<?>> var1, Serializer var2);

    protected abstract void storeSnapshot(DomainEventMessage<?> var1, Serializer var2);

    protected abstract Stream<? extends DomainEventData<?>> readEventData(String var1, long var2);

    protected abstract Stream<? extends TrackedEventData<?>> readEventData(TrackingToken var1, boolean var2);

    protected abstract Optional<? extends DomainEventData<?>> readSnapshotData(String var1);

    public Serializer getSerializer() {
        return this.serializer;
    }

    public Serializer getEventSerializer() {
        return this.eventSerializer;
    }
}

