/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing;

import java.util.concurrent.Callable;
import org.axonframework.commandhandling.conflictresolution.ConflictResolution;
import org.axonframework.commandhandling.conflictresolution.DefaultConflictResolver;
import org.axonframework.commandhandling.model.Aggregate;
import org.axonframework.commandhandling.model.AggregateNotFoundException;
import org.axonframework.commandhandling.model.LockAwareAggregate;
import org.axonframework.commandhandling.model.LockingRepository;
import org.axonframework.commandhandling.model.RepositoryProvider;
import org.axonframework.commandhandling.model.inspection.AggregateModel;
import org.axonframework.common.Assert;
import org.axonframework.common.lock.LockFactory;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventsourcing.AggregateDeletedException;
import org.axonframework.eventsourcing.AggregateFactory;
import org.axonframework.eventsourcing.EventSourcedAggregate;
import org.axonframework.eventsourcing.GenericAggregateFactory;
import org.axonframework.eventsourcing.NoSnapshotTriggerDefinition;
import org.axonframework.eventsourcing.SnapshotTrigger;
import org.axonframework.eventsourcing.SnapshotTriggerDefinition;
import org.axonframework.eventsourcing.eventstore.DomainEventStream;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.messaging.annotation.ClasspathHandlerDefinition;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;

public class EventSourcingRepository<T>
extends LockingRepository<T, EventSourcedAggregate<T>> {
    private final EventStore eventStore;
    private final SnapshotTriggerDefinition snapshotTriggerDefinition;
    private final AggregateFactory<T> aggregateFactory;
    private final RepositoryProvider repositoryProvider;

    public EventSourcingRepository(Class<T> aggregateType, EventStore eventStore) {
        this(new GenericAggregateFactory<T>(aggregateType), eventStore, (SnapshotTriggerDefinition)NoSnapshotTriggerDefinition.INSTANCE);
    }

    public EventSourcingRepository(Class<T> aggregateType, EventStore eventStore, RepositoryProvider repositoryProvider) {
        this(new GenericAggregateFactory<T>(aggregateType), eventStore, (SnapshotTriggerDefinition)NoSnapshotTriggerDefinition.INSTANCE, repositoryProvider);
    }

    public EventSourcingRepository(Class<T> aggregateType, EventStore eventStore, SnapshotTriggerDefinition snapshotTriggerDefinition) {
        this(new GenericAggregateFactory<T>(aggregateType), eventStore, snapshotTriggerDefinition);
    }

    public EventSourcingRepository(Class<T> aggregateType, EventStore eventStore, SnapshotTriggerDefinition snapshotTriggerDefinition, RepositoryProvider repositoryProvider) {
        this(new GenericAggregateFactory<T>(aggregateType), eventStore, snapshotTriggerDefinition, repositoryProvider);
    }

    public EventSourcingRepository(AggregateFactory<T> aggregateFactory, EventStore eventStore) {
        this(aggregateFactory, eventStore, (SnapshotTriggerDefinition)NoSnapshotTriggerDefinition.INSTANCE);
    }

    public EventSourcingRepository(AggregateFactory<T> aggregateFactory, EventStore eventStore, RepositoryProvider repositoryProvider) {
        this(aggregateFactory, eventStore, (SnapshotTriggerDefinition)NoSnapshotTriggerDefinition.INSTANCE, repositoryProvider);
    }

    public EventSourcingRepository(AggregateModel<T> aggregateModel, AggregateFactory<T> aggregateFactory, EventStore eventStore) {
        this(aggregateModel, aggregateFactory, eventStore, (SnapshotTriggerDefinition)NoSnapshotTriggerDefinition.INSTANCE);
    }

    public EventSourcingRepository(AggregateModel<T> aggregateModel, AggregateFactory<T> aggregateFactory, EventStore eventStore, RepositoryProvider repositoryProvider) {
        this(aggregateModel, aggregateFactory, eventStore, (SnapshotTriggerDefinition)NoSnapshotTriggerDefinition.INSTANCE, repositoryProvider);
    }

    public EventSourcingRepository(AggregateFactory<T> aggregateFactory, EventStore eventStore, SnapshotTriggerDefinition snapshotTriggerDefinition) {
        this(aggregateFactory, eventStore, snapshotTriggerDefinition, null);
    }

    public EventSourcingRepository(AggregateFactory<T> aggregateFactory, EventStore eventStore, SnapshotTriggerDefinition snapshotTriggerDefinition, RepositoryProvider repositoryProvider) {
        super(aggregateFactory.getAggregateType());
        Assert.notNull(eventStore, () -> "eventStore may not be null");
        this.aggregateFactory = aggregateFactory;
        this.eventStore = eventStore;
        this.snapshotTriggerDefinition = snapshotTriggerDefinition;
        this.repositoryProvider = repositoryProvider;
    }

    public EventSourcingRepository(AggregateModel<T> aggregateModel, AggregateFactory<T> aggregateFactory, EventStore eventStore, SnapshotTriggerDefinition snapshotTriggerDefinition) {
        this(aggregateModel, aggregateFactory, eventStore, snapshotTriggerDefinition, null);
    }

    public EventSourcingRepository(AggregateModel<T> aggregateModel, AggregateFactory<T> aggregateFactory, EventStore eventStore, SnapshotTriggerDefinition snapshotTriggerDefinition, RepositoryProvider repositoryProvider) {
        super(aggregateModel);
        Assert.notNull(eventStore, () -> "eventStore may not be null");
        this.aggregateFactory = aggregateFactory;
        this.eventStore = eventStore;
        this.snapshotTriggerDefinition = snapshotTriggerDefinition;
        this.repositoryProvider = repositoryProvider;
    }

    public EventSourcingRepository(AggregateModel<T> aggregateModel, LockFactory lockFactory, AggregateFactory<T> aggregateFactory, EventStore eventStore, SnapshotTriggerDefinition snapshotTriggerDefinition, RepositoryProvider repositoryProvider) {
        super(aggregateModel, lockFactory);
        Assert.notNull(eventStore, () -> "eventStore may not be null");
        this.aggregateFactory = aggregateFactory;
        this.eventStore = eventStore;
        this.snapshotTriggerDefinition = snapshotTriggerDefinition;
        this.repositoryProvider = repositoryProvider;
    }

    public EventSourcingRepository(AggregateFactory<T> aggregateFactory, EventStore eventStore, ParameterResolverFactory parameterResolverFactory, SnapshotTriggerDefinition snapshotTriggerDefinition) {
        this(aggregateFactory, eventStore, parameterResolverFactory, ClasspathHandlerDefinition.forClass(aggregateFactory.getAggregateType()), snapshotTriggerDefinition, null);
    }

    public EventSourcingRepository(AggregateFactory<T> aggregateFactory, EventStore eventStore, ParameterResolverFactory parameterResolverFactory, HandlerDefinition handlerDefinition, SnapshotTriggerDefinition snapshotTriggerDefinition, RepositoryProvider repositoryProvider) {
        super(aggregateFactory.getAggregateType(), parameterResolverFactory, handlerDefinition);
        Assert.notNull(eventStore, () -> "eventStore may not be null");
        this.snapshotTriggerDefinition = snapshotTriggerDefinition;
        this.eventStore = eventStore;
        this.aggregateFactory = aggregateFactory;
        this.repositoryProvider = repositoryProvider;
    }

    public EventSourcingRepository(AggregateFactory<T> aggregateFactory, EventStore eventStore, LockFactory lockFactory, SnapshotTriggerDefinition snapshotTriggerDefinition) {
        this(aggregateFactory, eventStore, lockFactory, snapshotTriggerDefinition, null);
    }

    public EventSourcingRepository(AggregateFactory<T> aggregateFactory, EventStore eventStore, LockFactory lockFactory, SnapshotTriggerDefinition snapshotTriggerDefinition, RepositoryProvider repositoryProvider) {
        super(aggregateFactory.getAggregateType(), lockFactory);
        Assert.notNull(eventStore, () -> "eventStore may not be null");
        this.eventStore = eventStore;
        this.aggregateFactory = aggregateFactory;
        this.snapshotTriggerDefinition = snapshotTriggerDefinition;
        this.repositoryProvider = repositoryProvider;
    }

    public EventSourcingRepository(AggregateFactory<T> aggregateFactory, EventStore eventStore, LockFactory lockFactory, ParameterResolverFactory parameterResolverFactory, SnapshotTriggerDefinition snapshotTriggerDefinition) {
        this(aggregateFactory, eventStore, lockFactory, parameterResolverFactory, ClasspathHandlerDefinition.forClass(aggregateFactory.getAggregateType()), snapshotTriggerDefinition, null);
    }

    public EventSourcingRepository(AggregateFactory<T> aggregateFactory, EventStore eventStore, LockFactory lockFactory, ParameterResolverFactory parameterResolverFactory, HandlerDefinition handlerDefinition, SnapshotTriggerDefinition snapshotTriggerDefinition, RepositoryProvider repositoryProvider) {
        super(aggregateFactory.getAggregateType(), lockFactory, parameterResolverFactory, handlerDefinition);
        Assert.notNull(eventStore, () -> "eventStore may not be null");
        this.eventStore = eventStore;
        this.aggregateFactory = aggregateFactory;
        this.snapshotTriggerDefinition = snapshotTriggerDefinition;
        this.repositoryProvider = repositoryProvider;
    }

    @Override
    protected EventSourcedAggregate<T> doLoadWithLock(String aggregateIdentifier, Long expectedVersion) {
        DomainEventStream eventStream = this.readEvents(aggregateIdentifier);
        SnapshotTrigger trigger = this.snapshotTriggerDefinition.prepareTrigger(this.aggregateFactory.getAggregateType());
        if (!eventStream.hasNext()) {
            throw new AggregateNotFoundException(aggregateIdentifier, "The aggregate was not found in the event store");
        }
        EventSourcedAggregate<T> aggregate = EventSourcedAggregate.initialize(this.aggregateFactory.createAggregateRoot(aggregateIdentifier, eventStream.peek()), this.aggregateModel(), (EventBus)this.eventStore, this.repositoryProvider, trigger);
        aggregate.initializeState(eventStream);
        if (aggregate.isDeleted()) {
            throw new AggregateDeletedException(aggregateIdentifier);
        }
        return aggregate;
    }

    protected DomainEventStream readEvents(String aggregateIdentifier) {
        return this.eventStore.readEvents(aggregateIdentifier);
    }

    @Override
    protected void validateOnLoad(Aggregate<T> aggregate, Long expectedVersion) {
        if (expectedVersion != null && expectedVersion < aggregate.version()) {
            DefaultConflictResolver conflictResolver = new DefaultConflictResolver(this.eventStore, aggregate.identifierAsString(), expectedVersion, aggregate.version());
            ConflictResolution.initialize(conflictResolver);
            CurrentUnitOfWork.get().onPrepareCommit(uow -> conflictResolver.ensureConflictsResolved());
        } else {
            super.validateOnLoad(aggregate, expectedVersion);
        }
    }

    @Override
    protected void reportIllegalState(LockAwareAggregate<T, EventSourcedAggregate<T>> aggregate) {
    }

    @Override
    protected EventSourcedAggregate<T> doCreateNewForLock(Callable<T> factoryMethod) throws Exception {
        return EventSourcedAggregate.initialize(factoryMethod, this.aggregateModel(), (EventBus)this.eventStore, this.repositoryProvider, this.snapshotTriggerDefinition.prepareTrigger(this.getAggregateType()));
    }

    @Override
    protected void doSaveWithLock(EventSourcedAggregate<T> aggregate) {
    }

    @Override
    protected void doDeleteWithLock(EventSourcedAggregate<T> aggregate) {
    }

    public AggregateFactory<T> getAggregateFactory() {
        return this.aggregateFactory;
    }
}

