/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing;

import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import org.axonframework.commandhandling.model.ApplyMore;
import org.axonframework.commandhandling.model.RepositoryProvider;
import org.axonframework.commandhandling.model.inspection.AggregateModel;
import org.axonframework.commandhandling.model.inspection.AnnotatedAggregate;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventsourcing.IncompatibleAggregateException;
import org.axonframework.eventsourcing.SnapshotTrigger;
import org.axonframework.eventsourcing.eventstore.DomainEventStream;
import org.axonframework.messaging.MetaData;

public class EventSourcedAggregate<T>
extends AnnotatedAggregate<T> {
    private final SnapshotTrigger snapshotTrigger;
    private boolean initializing = false;

    public static <T> EventSourcedAggregate<T> initialize(T aggregateRoot, AggregateModel<T> inspector, EventBus eventBus, SnapshotTrigger snapshotTrigger) {
        return EventSourcedAggregate.initialize(aggregateRoot, inspector, eventBus, null, snapshotTrigger);
    }

    public static <T> EventSourcedAggregate<T> initialize(T aggregateRoot, AggregateModel<T> inspector, EventBus eventBus, RepositoryProvider repositoryProvider, SnapshotTrigger snapshotTrigger) {
        return new EventSourcedAggregate<T>(aggregateRoot, inspector, eventBus, repositoryProvider, snapshotTrigger);
    }

    public static <T> EventSourcedAggregate<T> initialize(Callable<T> aggregateFactory, AggregateModel<T> inspector, EventBus eventBus, SnapshotTrigger snapshotTrigger) throws Exception {
        return EventSourcedAggregate.initialize(aggregateFactory, inspector, eventBus, null, snapshotTrigger);
    }

    public static <T> EventSourcedAggregate<T> initialize(Callable<T> aggregateFactory, AggregateModel<T> inspector, EventBus eventBus, RepositoryProvider repositoryProvider, SnapshotTrigger snapshotTrigger) throws Exception {
        EventSourcedAggregate<T> aggregate = new EventSourcedAggregate<T>(inspector, eventBus, repositoryProvider, snapshotTrigger);
        aggregate.registerRoot(aggregateFactory);
        return aggregate;
    }

    public static <T> EventSourcedAggregate<T> reconstruct(T aggregateRoot, AggregateModel<T> model, long seqNo, boolean isDeleted, EventBus eventBus, SnapshotTrigger snapshotTrigger) {
        return EventSourcedAggregate.reconstruct(aggregateRoot, model, seqNo, isDeleted, eventBus, null, snapshotTrigger);
    }

    public static <T> EventSourcedAggregate<T> reconstruct(T aggregateRoot, AggregateModel<T> model, long seqNo, boolean isDeleted, EventBus eventBus, RepositoryProvider repositoryProvider, SnapshotTrigger snapshotTrigger) {
        EventSourcedAggregate<T> aggregate = EventSourcedAggregate.initialize(aggregateRoot, model, eventBus, repositoryProvider, snapshotTrigger);
        aggregate.initSequence(seqNo);
        if (isDeleted) {
            aggregate.doMarkDeleted();
        }
        return aggregate;
    }

    protected EventSourcedAggregate(T aggregateRoot, AggregateModel<T> model, EventBus eventBus, SnapshotTrigger snapshotTrigger) {
        super(aggregateRoot, model, eventBus);
        this.initSequence();
        this.snapshotTrigger = snapshotTrigger;
    }

    protected EventSourcedAggregate(T aggregateRoot, AggregateModel<T> model, EventBus eventBus, RepositoryProvider repositoryProvider, SnapshotTrigger snapshotTrigger) {
        super(aggregateRoot, model, eventBus, repositoryProvider);
        this.initSequence();
        this.snapshotTrigger = snapshotTrigger;
    }

    protected EventSourcedAggregate(AggregateModel<T> model, EventBus eventBus, SnapshotTrigger snapshotTrigger) {
        super(model, eventBus);
        this.initSequence();
        this.snapshotTrigger = snapshotTrigger;
    }

    protected EventSourcedAggregate(AggregateModel<T> model, EventBus eventBus, RepositoryProvider repositoryProvider, SnapshotTrigger snapshotTrigger) {
        super(model, eventBus, repositoryProvider);
        this.initSequence();
        this.snapshotTrigger = snapshotTrigger;
    }

    @Override
    public <P> ApplyMore doApply(P payload, MetaData metaData) {
        if (this.initializing) {
            return IgnoreApplyMore.INSTANCE;
        }
        return super.doApply(payload, metaData);
    }

    @Override
    protected void publish(EventMessage<?> msg) {
        super.publish(msg);
        this.snapshotTrigger.eventHandled(msg);
        if (this.identifierAsString() == null) {
            throw new IncompatibleAggregateException("Aggregate identifier must be non-null after applying an event. Make sure the aggregate identifier is initialized at the latest when handling the creation event.");
        }
    }

    @Override
    protected void publishOnEventBus(EventMessage<?> msg) {
        if (!this.initializing) {
            super.publishOnEventBus((EventMessage<?>)msg.andMetaData(Collections.emptyMap()));
        }
    }

    @Override
    public Long version() {
        return this.lastSequence();
    }

    public void initializeState(DomainEventStream eventStream) {
        this.execute((T r) -> {
            this.initializing = true;
            try {
                eventStream.forEachRemaining(this::publish);
                this.initSequence(eventStream.getLastSequenceNumber());
            }
            finally {
                this.initializing = false;
                this.snapshotTrigger.initializationFinished();
            }
        });
    }

    @Override
    protected boolean getIsLive() {
        return !this.initializing;
    }

    public SnapshotTrigger getSnapshotTrigger() {
        return this.snapshotTrigger;
    }

    private static class IgnoreApplyMore
    implements ApplyMore {
        public static final ApplyMore INSTANCE = new IgnoreApplyMore();

        private IgnoreApplyMore() {
        }

        @Override
        public ApplyMore andThenApply(Supplier<?> payloadOrMessageSupplier) {
            return this;
        }

        @Override
        public ApplyMore andThen(Runnable runnable) {
            return this;
        }
    }
}

