/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing;

import java.io.Serializable;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventsourcing.DomainEventMessage;
import org.axonframework.eventsourcing.SnapshotTrigger;
import org.axonframework.eventsourcing.SnapshotTriggerDefinition;
import org.axonframework.eventsourcing.Snapshotter;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;

public class EventCountSnapshotTriggerDefinition
implements SnapshotTriggerDefinition {
    private final Snapshotter snapshotter;
    private final int threshold;

    public EventCountSnapshotTriggerDefinition(Snapshotter snapshotter, int threshold) {
        this.snapshotter = snapshotter;
        this.threshold = threshold;
    }

    @Override
    public SnapshotTrigger prepareTrigger(Class<?> aggregateType) {
        return new EventCountSnapshotTrigger(this.snapshotter, aggregateType, this.threshold);
    }

    @Override
    public SnapshotTrigger reconfigure(Class<?> aggregateType, SnapshotTrigger trigger) {
        if (trigger instanceof EventCountSnapshotTrigger) {
            ((EventCountSnapshotTrigger)trigger).setSnapshotter(this.snapshotter);
            return trigger;
        }
        return new EventCountSnapshotTrigger(this.snapshotter, aggregateType, this.threshold);
    }

    private static class EventCountSnapshotTrigger
    implements SnapshotTrigger,
    Serializable {
        private final Class<?> aggregateType;
        private final int threshold;
        private transient Snapshotter snapshotter;
        private int counter = 0;

        public EventCountSnapshotTrigger(Snapshotter snapshotter, Class<?> aggregateType, int threshold) {
            this.snapshotter = snapshotter;
            this.aggregateType = aggregateType;
            this.threshold = threshold;
        }

        @Override
        public void eventHandled(EventMessage<?> msg) {
            if (++this.counter >= this.threshold && msg instanceof DomainEventMessage) {
                if (CurrentUnitOfWork.isStarted()) {
                    CurrentUnitOfWork.get().onPrepareCommit(u -> this.scheduleSnapshot((DomainEventMessage)msg));
                } else {
                    this.scheduleSnapshot((DomainEventMessage)msg);
                }
                this.counter = 0;
            }
        }

        protected void scheduleSnapshot(DomainEventMessage msg) {
            this.snapshotter.scheduleSnapshot(this.aggregateType, msg.getAggregateIdentifier());
            this.counter = 0;
        }

        @Override
        public void initializationFinished() {
        }

        public void setSnapshotter(Snapshotter snapshotter) {
            this.snapshotter = snapshotter;
        }
    }
}

