/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing;

import java.util.concurrent.Callable;
import org.axonframework.commandhandling.model.Aggregate;
import org.axonframework.commandhandling.model.RepositoryProvider;
import org.axonframework.common.caching.Cache;
import org.axonframework.common.lock.LockFactory;
import org.axonframework.common.lock.PessimisticLockFactory;
import org.axonframework.eventsourcing.AggregateCacheEntry;
import org.axonframework.eventsourcing.AggregateDeletedException;
import org.axonframework.eventsourcing.AggregateFactory;
import org.axonframework.eventsourcing.EventSourcedAggregate;
import org.axonframework.eventsourcing.EventSourcingRepository;
import org.axonframework.eventsourcing.NoSnapshotTriggerDefinition;
import org.axonframework.eventsourcing.SnapshotTriggerDefinition;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.messaging.annotation.ClasspathHandlerDefinition;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.messaging.unitofwork.UnitOfWork;

public class CachingEventSourcingRepository<T>
extends EventSourcingRepository<T> {
    private final EventStore eventStore;
    private final RepositoryProvider repositoryProvider;
    private final Cache cache;
    private final SnapshotTriggerDefinition snapshotTriggerDefinition;

    public CachingEventSourcingRepository(AggregateFactory<T> aggregateFactory, EventStore eventStore, Cache cache) {
        this(aggregateFactory, eventStore, (LockFactory)new PessimisticLockFactory(), cache, (SnapshotTriggerDefinition)NoSnapshotTriggerDefinition.INSTANCE);
    }

    public CachingEventSourcingRepository(AggregateFactory<T> aggregateFactory, EventStore eventStore, Cache cache, RepositoryProvider repositoryProvider) {
        this(aggregateFactory, eventStore, (LockFactory)new PessimisticLockFactory(), cache, (SnapshotTriggerDefinition)NoSnapshotTriggerDefinition.INSTANCE, repositoryProvider);
    }

    public CachingEventSourcingRepository(AggregateFactory<T> aggregateFactory, EventStore eventStore, Cache cache, SnapshotTriggerDefinition snapshotTriggerDefinition) {
        this(aggregateFactory, eventStore, (LockFactory)new PessimisticLockFactory(), cache, snapshotTriggerDefinition);
    }

    public CachingEventSourcingRepository(AggregateFactory<T> aggregateFactory, EventStore eventStore, Cache cache, SnapshotTriggerDefinition snapshotTriggerDefinition, RepositoryProvider repositoryProvider) {
        this(aggregateFactory, eventStore, (LockFactory)new PessimisticLockFactory(), cache, snapshotTriggerDefinition, repositoryProvider);
    }

    public CachingEventSourcingRepository(AggregateFactory<T> aggregateFactory, EventStore eventStore, LockFactory lockFactory, Cache cache, SnapshotTriggerDefinition snapshotTriggerDefinition) {
        this(aggregateFactory, eventStore, lockFactory, cache, snapshotTriggerDefinition, null);
    }

    public CachingEventSourcingRepository(AggregateFactory<T> aggregateFactory, EventStore eventStore, LockFactory lockFactory, Cache cache, SnapshotTriggerDefinition snapshotTriggerDefinition, RepositoryProvider repositoryProvider) {
        super(aggregateFactory, eventStore, lockFactory, snapshotTriggerDefinition, repositoryProvider);
        this.cache = cache;
        this.eventStore = eventStore;
        this.snapshotTriggerDefinition = snapshotTriggerDefinition;
        this.repositoryProvider = repositoryProvider;
    }

    public CachingEventSourcingRepository(AggregateFactory<T> aggregateFactory, EventStore eventStore, LockFactory lockFactory, Cache cache, ParameterResolverFactory parameterResolverFactory, SnapshotTriggerDefinition snapshotTriggerDefinition) {
        this(aggregateFactory, eventStore, lockFactory, cache, parameterResolverFactory, ClasspathHandlerDefinition.forClass(aggregateFactory.getAggregateType()), snapshotTriggerDefinition, null);
    }

    public CachingEventSourcingRepository(AggregateFactory<T> aggregateFactory, EventStore eventStore, LockFactory lockFactory, Cache cache, ParameterResolverFactory parameterResolverFactory, HandlerDefinition handlerDefinition, SnapshotTriggerDefinition snapshotTriggerDefinition, RepositoryProvider repositoryProvider) {
        super(aggregateFactory, eventStore, lockFactory, parameterResolverFactory, handlerDefinition, snapshotTriggerDefinition, repositoryProvider);
        this.cache = cache;
        this.eventStore = eventStore;
        this.snapshotTriggerDefinition = snapshotTriggerDefinition;
        this.repositoryProvider = repositoryProvider;
    }

    @Override
    protected void validateOnLoad(Aggregate<T> aggregate, Long expectedVersion) {
        CurrentUnitOfWork.get().onRollback(u -> this.cache.remove(aggregate.identifierAsString()));
        super.validateOnLoad(aggregate, expectedVersion);
    }

    @Override
    protected EventSourcedAggregate<T> doCreateNewForLock(Callable<T> factoryMethod) throws Exception {
        Aggregate aggregate = super.doCreateNewForLock((Callable)factoryMethod);
        CurrentUnitOfWork.get().onRollback(arg_0 -> this.lambda$doCreateNewForLock$1((EventSourcedAggregate)aggregate, arg_0));
        this.cache.put(aggregate.identifierAsString(), new AggregateCacheEntry(aggregate));
        return aggregate;
    }

    @Override
    protected void doSaveWithLock(EventSourcedAggregate<T> aggregate) {
        super.doSaveWithLock(aggregate);
        this.cache.put(aggregate.identifierAsString(), new AggregateCacheEntry<T>(aggregate));
    }

    @Override
    protected void doDeleteWithLock(EventSourcedAggregate<T> aggregate) {
        super.doDeleteWithLock(aggregate);
        this.cache.put(aggregate.identifierAsString(), new AggregateCacheEntry<T>(aggregate));
    }

    @Override
    protected EventSourcedAggregate<T> doLoadWithLock(String aggregateIdentifier, Long expectedVersion) {
        EventSourcedAggregate aggregate = null;
        AggregateCacheEntry cacheEntry = (AggregateCacheEntry)this.cache.get(aggregateIdentifier);
        if (cacheEntry != null) {
            aggregate = cacheEntry.recreateAggregate(this.aggregateModel(), this.eventStore, this.repositoryProvider, this.snapshotTriggerDefinition);
        }
        if (aggregate == null) {
            aggregate = super.doLoadWithLock(aggregateIdentifier, expectedVersion);
        } else if (aggregate.isDeleted()) {
            throw new AggregateDeletedException(aggregateIdentifier);
        }
        return aggregate;
    }

    private /* synthetic */ void lambda$doCreateNewForLock$1(EventSourcedAggregate aggregate, UnitOfWork u) {
        this.cache.remove(aggregate.identifierAsString());
    }
}

