/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.axonframework.commandhandling.model.ApplyMore;
import org.axonframework.commandhandling.model.RepositoryProvider;
import org.axonframework.commandhandling.model.inspection.AggregateModel;
import org.axonframework.commandhandling.model.inspection.AnnotatedAggregateMetaModelFactory;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.eventsourcing.AbstractSnapshotter;
import org.axonframework.eventsourcing.AggregateFactory;
import org.axonframework.eventsourcing.DomainEventMessage;
import org.axonframework.eventsourcing.EventSourcedAggregate;
import org.axonframework.eventsourcing.GenericDomainEventMessage;
import org.axonframework.eventsourcing.NoSnapshotTriggerDefinition;
import org.axonframework.eventsourcing.eventstore.DomainEventStream;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.annotation.ClasspathHandlerDefinition;
import org.axonframework.messaging.annotation.ClasspathParameterResolverFactory;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.ParameterResolverFactory;

public class AggregateSnapshotter
extends AbstractSnapshotter {
    private final Map<Class<?>, AggregateFactory<?>> aggregateFactories = new ConcurrentHashMap();
    private final Map<Class, AggregateModel> aggregateModels = new ConcurrentHashMap<Class, AggregateModel>();
    private final RepositoryProvider repositoryProvider;
    private final ParameterResolverFactory parameterResolverFactory;
    private final HandlerDefinition handlerDefinition;

    public AggregateSnapshotter(EventStore eventStore, AggregateFactory<?> ... aggregateFactories) {
        this(eventStore, Arrays.asList(aggregateFactories));
    }

    public AggregateSnapshotter(EventStore eventStore, RepositoryProvider repositoryProvider, AggregateFactory<?> ... aggregateFactories) {
        this(eventStore, Arrays.asList(aggregateFactories), repositoryProvider);
    }

    public AggregateSnapshotter(EventStore eventStore, List<AggregateFactory<?>> aggregateFactories) {
        this(eventStore, aggregateFactories, ClasspathParameterResolverFactory.forClass(AggregateSnapshotter.class));
    }

    public AggregateSnapshotter(EventStore eventStore, List<AggregateFactory<?>> aggregateFactories, RepositoryProvider repositoryProvider) {
        this(eventStore, aggregateFactories, ClasspathParameterResolverFactory.forClass(AggregateSnapshotter.class), ClasspathHandlerDefinition.forClass(AggregateSnapshotter.class), repositoryProvider);
    }

    public AggregateSnapshotter(EventStore eventStore, List<AggregateFactory<?>> aggregateFactories, ParameterResolverFactory parameterResolverFactory) {
        this(eventStore, aggregateFactories, parameterResolverFactory, ClasspathHandlerDefinition.forClassLoader(aggregateFactories.isEmpty() ? Thread.currentThread().getContextClassLoader() : aggregateFactories.get(0).getClass().getClassLoader()), null);
    }

    public AggregateSnapshotter(EventStore eventStore, List<AggregateFactory<?>> aggregateFactories, ParameterResolverFactory parameterResolverFactory, HandlerDefinition handlerDefinition, RepositoryProvider repositoryProvider) {
        super(eventStore);
        aggregateFactories.forEach(f -> this.aggregateFactories.put(f.getAggregateType(), (AggregateFactory<?>)f));
        this.parameterResolverFactory = parameterResolverFactory;
        this.repositoryProvider = repositoryProvider;
        this.handlerDefinition = handlerDefinition;
    }

    public AggregateSnapshotter(EventStore eventStore, List<AggregateFactory<?>> aggregateFactories, ParameterResolverFactory parameterResolverFactory, Executor executor, TransactionManager transactionManager) {
        this(eventStore, aggregateFactories, parameterResolverFactory, ClasspathHandlerDefinition.forClassLoader(aggregateFactories.isEmpty() ? Thread.currentThread().getContextClassLoader() : aggregateFactories.get(0).getClass().getClassLoader()), executor, transactionManager, null);
    }

    public AggregateSnapshotter(EventStore eventStore, List<AggregateFactory<?>> aggregateFactories, ParameterResolverFactory parameterResolverFactory, HandlerDefinition handlerDefinition, Executor executor, TransactionManager transactionManager, RepositoryProvider repositoryProvider) {
        super(eventStore, executor, transactionManager);
        aggregateFactories.forEach(f -> this.aggregateFactories.put(f.getAggregateType(), (AggregateFactory<?>)f));
        this.parameterResolverFactory = parameterResolverFactory;
        this.repositoryProvider = repositoryProvider;
        this.handlerDefinition = handlerDefinition;
    }

    @Override
    protected DomainEventMessage createSnapshot(Class<?> aggregateType, String aggregateIdentifier, DomainEventStream eventStream) {
        DomainEventMessage<?> firstEvent = eventStream.peek();
        AggregateFactory<?> aggregateFactory = this.getAggregateFactory(aggregateType);
        if (aggregateFactory == null) {
            throw new IllegalArgumentException("Aggregate Type is unknown in this snapshotter: " + aggregateType.getName());
        }
        this.aggregateModels.computeIfAbsent(aggregateType, k -> AnnotatedAggregateMetaModelFactory.inspectAggregate(k, this.parameterResolverFactory, this.handlerDefinition));
        Object aggregateRoot = aggregateFactory.createAggregateRoot(aggregateIdentifier, firstEvent);
        SnapshotAggregate aggregate = new SnapshotAggregate(aggregateRoot, this.aggregateModels.get(aggregateType), this.repositoryProvider);
        aggregate.initializeState(eventStream);
        if (aggregate.isDeleted()) {
            return null;
        }
        return new GenericDomainEventMessage(aggregate.type(), aggregate.identifierAsString(), aggregate.version(), aggregate.getAggregateRoot());
    }

    protected AggregateFactory<?> getAggregateFactory(Class<?> aggregateType) {
        return this.aggregateFactories.get(aggregateType);
    }

    protected void registerAggregateFactory(AggregateFactory<?> aggregateFactory) {
        this.aggregateFactories.put(aggregateFactory.getAggregateType(), aggregateFactory);
    }

    private static class SnapshotAggregate<T>
    extends EventSourcedAggregate<T> {
        private SnapshotAggregate(T aggregateRoot, AggregateModel<T> aggregateModel, RepositoryProvider repositoryProvider) {
            super(aggregateRoot, aggregateModel, null, repositoryProvider, NoSnapshotTriggerDefinition.TRIGGER);
        }

        @Override
        public Object handle(Message<?> message) {
            throw new UnsupportedOperationException("Aggregate instance is read-only");
        }

        @Override
        public <P> ApplyMore doApply(P payload, MetaData metaData) {
            return this;
        }

        @Override
        public ApplyMore andThen(Runnable runnable) {
            return this;
        }

        @Override
        public ApplyMore andThenApply(Supplier<?> payloadOrMessageSupplier) {
            return this;
        }
    }
}

