/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing;

import java.io.Serializable;
import org.axonframework.commandhandling.model.RepositoryProvider;
import org.axonframework.commandhandling.model.inspection.AggregateModel;
import org.axonframework.eventsourcing.EventSourcedAggregate;
import org.axonframework.eventsourcing.NoSnapshotTriggerDefinition;
import org.axonframework.eventsourcing.SnapshotTrigger;
import org.axonframework.eventsourcing.SnapshotTriggerDefinition;
import org.axonframework.eventsourcing.eventstore.EventStore;

public class AggregateCacheEntry<T>
implements Serializable {
    private final T aggregateRoot;
    private final Long version;
    private final boolean deleted;
    private final SnapshotTrigger snapshotTrigger;
    private final transient EventSourcedAggregate<T> aggregate;

    public AggregateCacheEntry(EventSourcedAggregate<T> aggregate) {
        this.aggregate = aggregate;
        this.aggregateRoot = aggregate.getAggregateRoot();
        this.version = aggregate.version();
        this.deleted = aggregate.isDeleted();
        this.snapshotTrigger = aggregate.getSnapshotTrigger() instanceof Serializable ? aggregate.getSnapshotTrigger() : NoSnapshotTriggerDefinition.TRIGGER;
    }

    public EventSourcedAggregate<T> recreateAggregate(AggregateModel<T> model, EventStore eventStore, SnapshotTriggerDefinition snapshotTriggerDefinition) {
        return this.recreateAggregate(model, eventStore, null, snapshotTriggerDefinition);
    }

    public EventSourcedAggregate<T> recreateAggregate(AggregateModel<T> model, EventStore eventStore, RepositoryProvider repositoryProvider, SnapshotTriggerDefinition snapshotTriggerDefinition) {
        if (this.aggregate != null) {
            return this.aggregate;
        }
        return EventSourcedAggregate.reconstruct(this.aggregateRoot, model, this.version, this.deleted, eventStore, repositoryProvider, snapshotTriggerDefinition.reconfigure(this.aggregateRoot.getClass(), this.snapshotTrigger));
    }
}

