/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing;

import java.util.concurrent.Executor;
import org.axonframework.commandhandling.model.ConcurrencyException;
import org.axonframework.common.DirectExecutor;
import org.axonframework.common.transaction.NoTransactionManager;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.eventsourcing.DomainEventMessage;
import org.axonframework.eventsourcing.Snapshotter;
import org.axonframework.eventsourcing.eventstore.DomainEventStream;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSnapshotter
implements Snapshotter {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSnapshotter.class);
    private final EventStore eventStore;
    private final Executor executor;
    private final TransactionManager transactionManager;

    protected AbstractSnapshotter(EventStore eventStore) {
        this(eventStore, NoTransactionManager.INSTANCE);
    }

    protected AbstractSnapshotter(EventStore eventStore, TransactionManager transactionManager) {
        this(eventStore, DirectExecutor.INSTANCE, transactionManager);
    }

    protected AbstractSnapshotter(EventStore eventStore, Executor executor, TransactionManager transactionManager) {
        this.eventStore = eventStore;
        this.executor = executor;
        this.transactionManager = transactionManager;
    }

    @Override
    public void scheduleSnapshot(Class<?> aggregateType, String aggregateIdentifier) {
        this.executor.execute(new SilentTask(() -> this.transactionManager.executeInTransaction(this.createSnapshotterTask(aggregateType, aggregateIdentifier))));
    }

    protected Runnable createSnapshotterTask(Class<?> aggregateType, String aggregateIdentifier) {
        return new CreateSnapshotTask(aggregateType, aggregateIdentifier);
    }

    protected abstract DomainEventMessage createSnapshot(Class<?> var1, String var2, DomainEventStream var3);

    protected EventStore getEventStore() {
        return this.eventStore;
    }

    protected Executor getExecutor() {
        return this.executor;
    }

    private final class CreateSnapshotTask
    implements Runnable {
        private final Class<?> aggregateType;
        private final String identifier;

        private CreateSnapshotTask(Class<?> aggregateType, String identifier) {
            this.aggregateType = aggregateType;
            this.identifier = identifier;
        }

        @Override
        public void run() {
            DomainEventStream eventStream = AbstractSnapshotter.this.eventStore.readEvents(this.identifier);
            long firstEventSequenceNumber = eventStream.peek().getSequenceNumber();
            DomainEventMessage snapshotEvent = AbstractSnapshotter.this.createSnapshot(this.aggregateType, this.identifier, eventStream);
            if (snapshotEvent != null && snapshotEvent.getSequenceNumber() > firstEventSequenceNumber) {
                AbstractSnapshotter.this.eventStore.storeSnapshot(snapshotEvent);
            }
        }
    }

    private static class SilentTask
    implements Runnable {
        private final Runnable snapshotterTask;

        private SilentTask(Runnable snapshotterTask) {
            this.snapshotterTask = snapshotterTask;
        }

        @Override
        public void run() {
            try {
                this.snapshotterTask.run();
            }
            catch (ConcurrencyException e) {
                logger.info("An up-to-date snapshot entry already exists, ignoring this attempt.");
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.warn("An attempt to create and store a snapshot resulted in an exception:", (Throwable)e);
                }
                logger.warn("An attempt to create and store a snapshot resulted in an exception. Exception summary: {}", (Object)e.getMessage());
            }
        }
    }
}

