/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.tokenstore.jpa;

import java.lang.management.ManagementFactory;
import java.time.Duration;
import java.time.temporal.TemporalAmount;
import java.util.Collections;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import org.axonframework.common.DateTimeUtils;
import org.axonframework.common.jpa.EntityManagerProvider;
import org.axonframework.eventhandling.tokenstore.TokenStore;
import org.axonframework.eventhandling.tokenstore.UnableToClaimTokenException;
import org.axonframework.eventhandling.tokenstore.jpa.TokenEntry;
import org.axonframework.eventsourcing.eventstore.TrackingToken;
import org.axonframework.serialization.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaTokenStore
implements TokenStore {
    private static final Logger logger = LoggerFactory.getLogger(JpaTokenStore.class);
    private final EntityManagerProvider entityManagerProvider;
    private final Serializer serializer;
    private final TemporalAmount claimTimeout;
    private final String nodeId;

    public JpaTokenStore(EntityManagerProvider entityManagerProvider, Serializer serializer) {
        this(entityManagerProvider, serializer, Duration.ofSeconds(10L), ManagementFactory.getRuntimeMXBean().getName());
    }

    public JpaTokenStore(EntityManagerProvider entityManagerProvider, Serializer serializer, TemporalAmount claimTimeout, String nodeId) {
        this.entityManagerProvider = entityManagerProvider;
        this.serializer = serializer;
        this.claimTimeout = claimTimeout;
        this.nodeId = nodeId;
    }

    @Override
    public void initializeTokenSegments(String processorName, int segmentCount) throws UnableToClaimTokenException {
        this.initializeTokenSegments(processorName, segmentCount, null);
    }

    @Override
    public void initializeTokenSegments(String processorName, int segmentCount, TrackingToken initialToken) throws UnableToClaimTokenException {
        EntityManager entityManager = this.entityManagerProvider.getEntityManager();
        if (this.fetchSegments(processorName).length > 0) {
            throw new UnableToClaimTokenException("Could not initialize segments. Some segments were already present.");
        }
        for (int segment = 0; segment < segmentCount; ++segment) {
            TokenEntry token = new TokenEntry(processorName, segment, initialToken, this.serializer);
            entityManager.persist((Object)token);
        }
        entityManager.flush();
    }

    @Override
    public void storeToken(TrackingToken token, String processorName, int segment) {
        EntityManager entityManager = this.entityManagerProvider.getEntityManager();
        TokenEntry tokenEntry = this.loadOrCreateToken(processorName, segment, entityManager);
        tokenEntry.updateToken(token, this.serializer);
    }

    @Override
    public void releaseClaim(String processorName, int segment) {
        EntityManager entityManager = this.entityManagerProvider.getEntityManager();
        int updates = entityManager.createQuery("UPDATE TokenEntry te SET te.owner = null WHERE te.owner = :owner AND te.processorName = :processorName AND te.segment = :segment").setParameter("processorName", (Object)processorName).setParameter("segment", (Object)segment).setParameter("owner", (Object)this.nodeId).executeUpdate();
        if (updates == 0) {
            logger.warn("Releasing claim of token {}/{} failed. It was not owned by {}", new Object[]{processorName, segment, this.nodeId});
        }
    }

    @Override
    public TrackingToken fetchToken(String processorName, int segment) {
        EntityManager entityManager = this.entityManagerProvider.getEntityManager();
        return this.loadOrCreateToken(processorName, segment, entityManager).getToken(this.serializer);
    }

    @Override
    public void extendClaim(String processorName, int segment) throws UnableToClaimTokenException {
        EntityManager entityManager = this.entityManagerProvider.getEntityManager();
        int updates = entityManager.createQuery("UPDATE TokenEntry te SET te.timestamp = :timestamp WHERE te.processorName = :processorName AND te.segment = :segment AND te.owner = :owner").setParameter("processorName", (Object)processorName).setParameter("segment", (Object)segment).setParameter("owner", (Object)this.nodeId).setParameter("timestamp", (Object)DateTimeUtils.formatInstant(TokenEntry.clock.instant())).executeUpdate();
        if (updates == 0) {
            throw new UnableToClaimTokenException("Unable to extend the claim on token for processor '" + processorName + "[" + segment + "]'. It is either claimed by another process, or there is no such token.");
        }
    }

    @Override
    public int[] fetchSegments(String processorName) {
        EntityManager entityManager = this.entityManagerProvider.getEntityManager();
        List resultList = entityManager.createQuery("SELECT te.segment FROM TokenEntry te WHERE te.processorName = :processorName ORDER BY te.segment ASC", Integer.class).setParameter("processorName", (Object)processorName).getResultList();
        return resultList.stream().mapToInt(i -> i).toArray();
    }

    protected TokenEntry loadOrCreateToken(String processorName, int segment, EntityManager entityManager) {
        TokenEntry token = (TokenEntry)entityManager.find(TokenEntry.class, (Object)new TokenEntry.PK(processorName, segment), LockModeType.PESSIMISTIC_WRITE, Collections.singletonMap("javax.persistence.query.timeout", 1));
        if (token == null) {
            token = new TokenEntry(processorName, segment, null, this.serializer);
            token.claim(this.nodeId, this.claimTimeout);
            entityManager.persist((Object)token);
            entityManager.flush();
        } else if (!token.claim(this.nodeId, this.claimTimeout)) {
            throw new UnableToClaimTokenException(String.format("Unable to claim token '%s[%s]'. It is owned by '%s'", token.getProcessorName(), token.getSegment(), token.getOwner()));
        }
        return token;
    }
}

