/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.tokenstore.jdbc;

import java.lang.management.ManagementFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.time.temporal.TemporalAmount;
import java.util.List;
import org.axonframework.common.DateTimeUtils;
import org.axonframework.common.jdbc.ConnectionProvider;
import org.axonframework.common.jdbc.JdbcException;
import org.axonframework.common.jdbc.JdbcUtils;
import org.axonframework.eventhandling.tokenstore.AbstractTokenEntry;
import org.axonframework.eventhandling.tokenstore.GenericTokenEntry;
import org.axonframework.eventhandling.tokenstore.TokenStore;
import org.axonframework.eventhandling.tokenstore.UnableToClaimTokenException;
import org.axonframework.eventhandling.tokenstore.jdbc.TokenSchema;
import org.axonframework.eventhandling.tokenstore.jdbc.TokenTableFactory;
import org.axonframework.eventsourcing.eventstore.TrackingToken;
import org.axonframework.serialization.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcTokenStore
implements TokenStore {
    private static final Logger logger = LoggerFactory.getLogger(JdbcTokenStore.class);
    private final ConnectionProvider connectionProvider;
    private final Serializer serializer;
    private final TokenSchema schema;
    private final TemporalAmount claimTimeout;
    private final String nodeId;
    private final Class<?> contentType;

    public JdbcTokenStore(ConnectionProvider connectionProvider, Serializer serializer) {
        this(connectionProvider, serializer, new TokenSchema(), Duration.ofSeconds(10L), ManagementFactory.getRuntimeMXBean().getName(), byte[].class);
    }

    public JdbcTokenStore(ConnectionProvider connectionProvider, Serializer serializer, TokenSchema schema, TemporalAmount claimTimeout, String nodeId, Class<?> contentType) {
        this.connectionProvider = connectionProvider;
        this.serializer = serializer;
        this.schema = schema;
        this.claimTimeout = claimTimeout;
        this.nodeId = nodeId;
        this.contentType = contentType;
    }

    public void createSchema(TokenTableFactory schemaFactory) {
        Connection c = this.getConnection();
        try {
            JdbcUtils.executeUpdates(c, e -> {
                throw new JdbcException("Failed to create token tables", (Throwable)e);
            }, connection -> schemaFactory.createTable(connection, this.schema));
        }
        finally {
            JdbcUtils.closeQuietly(c);
        }
    }

    @Override
    public void initializeTokenSegments(String processorName, int segmentCount) throws UnableToClaimTokenException {
        this.initializeTokenSegments(processorName, segmentCount, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeTokenSegments(String processorName, int segmentCount, TrackingToken initialToken) throws UnableToClaimTokenException {
        Connection connection = this.getConnection();
        try {
            JdbcUtils.executeQuery(connection, c -> this.selectForUpdate(c, processorName, 0), resultSet -> {
                for (int segment = 0; segment < segmentCount; ++segment) {
                    this.insertTokenEntry(resultSet, initialToken, processorName, segment);
                }
                if (!connection.getAutoCommit()) {
                    connection.commit();
                }
                return null;
            }, e -> new UnableToClaimTokenException("Could not initialize segments. Some segments were already present.", (Throwable)e));
        }
        finally {
            JdbcUtils.closeQuietly(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeToken(TrackingToken token, String processorName, int segment) throws UnableToClaimTokenException {
        Connection connection = this.getConnection();
        try {
            JdbcUtils.executeQuery(connection, c -> this.selectForUpdate(c, processorName, segment), resultSet -> {
                this.insertOrUpdateToken(resultSet, token, processorName, segment);
                if (!connection.getAutoCommit()) {
                    connection.commit();
                }
                return null;
            }, e -> new JdbcException(String.format("Could not store token [%s] for processor [%s] and segment [%d]", token, processorName, segment), (Throwable)e));
        }
        finally {
            JdbcUtils.closeQuietly(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TrackingToken fetchToken(String processorName, int segment) throws UnableToClaimTokenException {
        Connection connection = this.getConnection();
        try {
            TrackingToken trackingToken = JdbcUtils.executeQuery(connection, c -> this.selectForUpdate(c, processorName, segment), resultSet -> {
                TrackingToken result = this.loadOrInsertToken(resultSet, processorName, segment);
                if (!connection.getAutoCommit()) {
                    connection.commit();
                }
                return result;
            }, e -> new JdbcException(String.format("Could not load token for processor [%s] and segment [%d]", processorName, segment), (Throwable)e));
            return trackingToken;
        }
        finally {
            JdbcUtils.closeQuietly(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseClaim(String processorName, int segment) {
        Connection connection = this.getConnection();
        try {
            int[] result = JdbcUtils.executeUpdates(connection, e -> {
                throw new JdbcException(String.format("Could not load token for processor [%s] and segment [%d]", processorName, segment), (Throwable)e);
            }, c -> this.releaseClaim(c, processorName, segment));
            try {
                if (!connection.isClosed() && !connection.getAutoCommit()) {
                    connection.commit();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (result[0] < 1) {
                logger.warn("Releasing claim of token {}/{} failed. It was owned by another node.", (Object)processorName, (Object)segment);
            }
        }
        finally {
            JdbcUtils.closeQuietly(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] fetchSegments(String processorName) {
        Connection connection = this.getConnection();
        try {
            List<Integer> integers = JdbcUtils.executeQuery(connection, c -> this.selectForSegments(c, processorName), JdbcUtils.listResults(rs -> rs.getInt(this.schema.segmentColumn())), e -> new JdbcException(String.format("Could not load segments for processor [%s]", processorName), (Throwable)e));
            int[] nArray = integers.stream().mapToInt(i -> i).toArray();
            return nArray;
        }
        finally {
            JdbcUtils.closeQuietly(connection);
        }
    }

    protected PreparedStatement selectForSegments(Connection connection, String processorName) throws SQLException {
        String sql = "SELECT " + this.schema.segmentColumn() + " FROM " + this.schema.tokenTable() + " WHERE " + this.schema.processorNameColumn() + " = ? ORDER BY " + this.schema.segmentColumn() + " ASC";
        PreparedStatement preparedStatement = connection.prepareStatement(sql, 1003, 1007);
        preparedStatement.setString(1, processorName);
        return preparedStatement;
    }

    protected PreparedStatement selectForUpdate(Connection connection, String processorName, int segment) throws SQLException {
        String sql = "SELECT " + String.join((CharSequence)", ", this.schema.processorNameColumn(), this.schema.segmentColumn(), this.schema.tokenColumn(), this.schema.tokenTypeColumn(), this.schema.timestampColumn(), this.schema.ownerColum()) + " FROM " + this.schema.tokenTable() + " WHERE " + this.schema.processorNameColumn() + " = ? AND " + this.schema.segmentColumn() + " = ? FOR UPDATE";
        PreparedStatement preparedStatement = connection.prepareStatement(sql, 1003, 1008);
        preparedStatement.setString(1, processorName);
        preparedStatement.setInt(2, segment);
        return preparedStatement;
    }

    protected void insertOrUpdateToken(ResultSet resultSet, TrackingToken token, String processorName, int segment) throws SQLException {
        if (resultSet.next()) {
            AbstractTokenEntry<?> entry = this.readTokenEntry(resultSet);
            entry.updateToken(token, this.serializer);
            resultSet.updateObject(this.schema.tokenColumn(), entry.getSerializedToken().getData());
            resultSet.updateString(this.schema.tokenTypeColumn(), entry.getSerializedToken().getType().getName());
            resultSet.updateString(this.schema.timestampColumn(), entry.timestampAsString());
            this.claimToken(resultSet, entry);
        } else {
            this.insertTokenEntry(resultSet, token, processorName, segment);
        }
    }

    protected TrackingToken claimToken(ResultSet resultSet, AbstractTokenEntry<?> entry) throws SQLException {
        if (!entry.claim(this.nodeId, this.claimTimeout)) {
            throw new UnableToClaimTokenException(String.format("Unable to claim token '%s[%s]'. It is owned by '%s'", entry.getProcessorName(), entry.getSegment(), entry.getOwner()));
        }
        resultSet.updateString(this.schema.ownerColum(), entry.getOwner());
        resultSet.updateString(this.schema.timestampColumn(), entry.timestampAsString());
        resultSet.updateRow();
        return entry.getToken(this.serializer);
    }

    protected TrackingToken loadOrInsertToken(ResultSet resultSet, String processorName, int segment) throws SQLException {
        if (!resultSet.next()) {
            return this.insertTokenEntry(resultSet, null, processorName, segment);
        }
        return this.claimToken(resultSet, this.readTokenEntry(resultSet));
    }

    protected TrackingToken insertTokenEntry(ResultSet resultSet, TrackingToken token, String processorName, int segment) throws SQLException {
        GenericTokenEntry entry = new GenericTokenEntry(token, this.serializer, this.contentType, processorName, segment);
        entry.claim(this.nodeId, this.claimTimeout);
        resultSet.moveToInsertRow();
        resultSet.updateObject(this.schema.tokenColumn(), token == null ? null : entry.getSerializedToken().getData());
        resultSet.updateString(this.schema.tokenTypeColumn(), token == null ? null : entry.getSerializedToken().getType().getName());
        resultSet.updateString(this.schema.timestampColumn(), entry.timestampAsString());
        resultSet.updateString(this.schema.ownerColum(), entry.getOwner());
        resultSet.updateString(this.schema.processorNameColumn(), processorName);
        resultSet.updateInt(this.schema.segmentColumn(), segment);
        resultSet.insertRow();
        return token;
    }

    protected AbstractTokenEntry<?> readTokenEntry(ResultSet resultSet) throws SQLException {
        return new GenericTokenEntry(this.readSerializedData(resultSet, this.schema.tokenColumn()), resultSet.getString(this.schema.tokenTypeColumn()), resultSet.getString(this.schema.timestampColumn()), resultSet.getString(this.schema.ownerColum()), resultSet.getString(this.schema.processorNameColumn()), resultSet.getInt(this.schema.segmentColumn()), this.contentType);
    }

    protected PreparedStatement releaseClaim(Connection connection, String processorName, int segment) throws SQLException {
        String sql = "UPDATE " + this.schema.tokenTable() + " SET " + this.schema.ownerColum() + " = ?, " + this.schema.timestampColumn() + " = ? WHERE " + this.schema.processorNameColumn() + " = ? AND " + this.schema.segmentColumn() + " = ? AND " + this.schema.ownerColum() + " = ?";
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        preparedStatement.setString(1, null);
        preparedStatement.setString(2, DateTimeUtils.formatInstant(AbstractTokenEntry.clock.instant()));
        preparedStatement.setString(3, processorName);
        preparedStatement.setInt(4, segment);
        preparedStatement.setString(5, this.nodeId);
        return preparedStatement;
    }

    protected <T> T readSerializedData(ResultSet resultSet, String columnName) throws SQLException {
        if (byte[].class.equals(this.contentType)) {
            return (T)resultSet.getBytes(columnName);
        }
        return (T)resultSet.getObject(columnName);
    }

    protected Connection getConnection() {
        try {
            return this.connectionProvider.getConnection();
        }
        catch (SQLException e) {
            throw new JdbcException("Failed to obtain a database connection", e);
        }
    }
}

