/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.tokenstore.inmemory;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.axonframework.common.ObjectUtils;
import org.axonframework.eventhandling.tokenstore.TokenStore;
import org.axonframework.eventhandling.tokenstore.UnableToClaimTokenException;
import org.axonframework.eventsourcing.eventstore.GlobalSequenceTrackingToken;
import org.axonframework.eventsourcing.eventstore.TrackingToken;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;

public class InMemoryTokenStore
implements TokenStore {
    private static final GlobalSequenceTrackingToken NULL_TOKEN = new GlobalSequenceTrackingToken(-1L);
    private final Map<ProcessAndSegment, TrackingToken> tokens = new ConcurrentHashMap<ProcessAndSegment, TrackingToken>();

    @Override
    public void initializeTokenSegments(String processorName, int segmentCount) throws UnableToClaimTokenException {
        this.initializeTokenSegments(processorName, segmentCount, null);
    }

    @Override
    public void initializeTokenSegments(String processorName, int segmentCount, TrackingToken initialToken) throws UnableToClaimTokenException {
        if (this.fetchSegments(processorName).length > 0) {
            throw new UnableToClaimTokenException("Could not initialize segments. Some segments were already present.");
        }
        for (int segment = 0; segment < segmentCount; ++segment) {
            this.tokens.put(new ProcessAndSegment(processorName, segment), ObjectUtils.getOrDefault(initialToken, NULL_TOKEN));
        }
    }

    @Override
    public void storeToken(TrackingToken token, String processorName, int segment) {
        if (CurrentUnitOfWork.isStarted()) {
            CurrentUnitOfWork.get().afterCommit(uow -> this.tokens.put(new ProcessAndSegment(processorName, segment), ObjectUtils.getOrDefault(token, NULL_TOKEN)));
        } else {
            this.tokens.put(new ProcessAndSegment(processorName, segment), ObjectUtils.getOrDefault(token, NULL_TOKEN));
        }
    }

    @Override
    public TrackingToken fetchToken(String processorName, int segment) {
        TrackingToken trackingToken = this.tokens.computeIfAbsent(new ProcessAndSegment(processorName, segment), k -> NULL_TOKEN);
        if (NULL_TOKEN == trackingToken) {
            return null;
        }
        return trackingToken;
    }

    @Override
    public void releaseClaim(String processorName, int segment) {
    }

    @Override
    public int[] fetchSegments(String processorName) {
        return this.tokens.keySet().stream().filter(ps -> ((ProcessAndSegment)ps).processorName.equals(processorName)).map(ProcessAndSegment::getSegment).distinct().mapToInt(Number::intValue).toArray();
    }

    private static class ProcessAndSegment {
        private final String processorName;
        private final int segment;

        public ProcessAndSegment(String processorName, int segment) {
            this.processorName = processorName;
            this.segment = segment;
        }

        public int getSegment() {
            return this.segment;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProcessAndSegment that = (ProcessAndSegment)o;
            return this.segment == that.segment && Objects.equals(this.processorName, that.processorName);
        }

        public int hashCode() {
            return Objects.hash(this.processorName, this.segment);
        }
    }
}

