/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.tokenstore;

import java.time.Clock;
import java.time.Instant;
import java.time.temporal.TemporalAmount;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Lob;
import javax.persistence.MappedSuperclass;
import org.axonframework.common.DateTimeUtils;
import org.axonframework.eventsourcing.eventstore.TrackingToken;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.SerializedType;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.SimpleSerializedObject;
import org.axonframework.serialization.SimpleSerializedType;

@MappedSuperclass
public abstract class AbstractTokenEntry<T> {
    public static Clock clock = Clock.systemUTC();
    @Lob
    @Column(length=10000)
    private T token;
    @Basic
    private String tokenType;
    @Basic(optional=false)
    private String timestamp;
    @Basic
    private String owner;

    protected AbstractTokenEntry(TrackingToken token, Serializer serializer, Class<T> contentType) {
        this.timestamp = DateTimeUtils.formatInstant(clock.instant());
        if (token != null) {
            SerializedObject<T> serializedToken = serializer.serialize(token, contentType);
            this.token = serializedToken.getData();
            this.tokenType = serializedToken.getType().getName();
        }
    }

    protected AbstractTokenEntry(T token, String tokenType, String timestamp, String owner) {
        this.token = token;
        this.tokenType = tokenType;
        this.timestamp = timestamp;
        this.owner = owner;
    }

    protected AbstractTokenEntry() {
    }

    public SerializedObject<T> getSerializedToken() {
        if (this.token == null) {
            return null;
        }
        return new SimpleSerializedObject<T>(this.token, this.token.getClass(), this.getTokenType());
    }

    public TrackingToken getToken(Serializer serializer) {
        return this.token == null ? null : (TrackingToken)serializer.deserialize(this.getSerializedToken());
    }

    protected SerializedType getTokenType() {
        return new SimpleSerializedType(this.tokenType, null);
    }

    public Instant timestamp() {
        return DateTimeUtils.parseInstant(this.timestamp);
    }

    public String timestampAsString() {
        return this.timestamp;
    }

    public abstract void updateToken(TrackingToken var1, Serializer var2);

    public abstract String getProcessorName();

    public abstract int getSegment();

    public boolean claim(String owner, TemporalAmount claimTimeout) {
        if (!this.mayClaim(owner, claimTimeout)) {
            return false;
        }
        this.timestamp = DateTimeUtils.formatInstant(clock.instant());
        this.owner = owner;
        return true;
    }

    public boolean mayClaim(String owner, TemporalAmount claimTimeout) {
        return this.owner == null || owner.equals(this.owner) || this.expired(claimTimeout);
    }

    private boolean expired(TemporalAmount claimTimeout) {
        return this.timestamp().plus(claimTimeout).isBefore(clock.instant());
    }

    public boolean releaseClaim(String owner) {
        if (Objects.equals(this.owner, owner)) {
            this.owner = null;
            this.timestamp = DateTimeUtils.formatInstant(clock.instant());
        }
        return this.owner == null;
    }

    public String getOwner() {
        return this.owner;
    }

    protected final void updateToken(TrackingToken token, Serializer serializer, Class<T> contentType) {
        SerializedObject<T> serializedToken = serializer.serialize(token, contentType);
        this.token = serializedToken.getData();
        this.tokenType = serializedToken.getType().getName();
        this.timestamp = DateTimeUtils.formatInstant(clock.instant());
    }
}

