/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.scheduling.java;

import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.axonframework.common.Assert;
import org.axonframework.common.IdentifierFactory;
import org.axonframework.common.transaction.NoTransactionManager;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventhandling.scheduling.EventScheduler;
import org.axonframework.eventhandling.scheduling.ScheduleToken;
import org.axonframework.eventhandling.scheduling.java.SimpleScheduleToken;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.unitofwork.DefaultUnitOfWork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleEventScheduler
implements EventScheduler {
    private static final Logger logger = LoggerFactory.getLogger(SimpleEventScheduler.class);
    private final ScheduledExecutorService executorService;
    private final EventBus eventBus;
    private final TransactionManager transactionManager;
    private final Map<String, Future<?>> tokens = new ConcurrentHashMap();

    public SimpleEventScheduler(ScheduledExecutorService executorService, EventBus eventBus) {
        this(executorService, eventBus, NoTransactionManager.INSTANCE);
    }

    public SimpleEventScheduler(ScheduledExecutorService executorService, EventBus eventBus, TransactionManager transactionManager) {
        Assert.notNull(executorService, () -> "executorService may not be null");
        Assert.notNull(eventBus, () -> "eventBus may not be null");
        Assert.notNull(transactionManager, () -> "transactionManager may not be null");
        this.executorService = executorService;
        this.eventBus = eventBus;
        this.transactionManager = transactionManager;
    }

    @Override
    public ScheduleToken schedule(Instant triggerDateTime, Object event) {
        return this.schedule(Duration.between(Instant.now(), triggerDateTime), event);
    }

    @Override
    public ScheduleToken schedule(Duration triggerDuration, Object event) {
        String tokenId = IdentifierFactory.getInstance().generateIdentifier();
        ScheduledFuture<?> future = this.executorService.schedule(new PublishEventTask(event, tokenId), triggerDuration.toMillis(), TimeUnit.MILLISECONDS);
        this.tokens.put(tokenId, future);
        return new SimpleScheduleToken(tokenId);
    }

    @Override
    public void cancelSchedule(ScheduleToken scheduleToken) {
        if (!SimpleScheduleToken.class.isInstance(scheduleToken)) {
            throw new IllegalArgumentException("The given ScheduleToken was not provided by this scheduler.");
        }
        Future<?> future = this.tokens.remove(((SimpleScheduleToken)scheduleToken).getTokenId());
        if (future != null) {
            future.cancel(false);
        }
    }

    private class PublishEventTask
    implements Runnable {
        private final Object event;
        private final String tokenId;

        public PublishEventTask(Object event, String tokenId) {
            this.event = event;
            this.tokenId = tokenId;
        }

        @Override
        public void run() {
            EventMessage<?> eventMessage = this.createMessage();
            if (logger.isDebugEnabled()) {
                logger.debug("Triggered the publication of event [{}]", (Object)eventMessage.getPayloadType().getSimpleName());
            }
            try {
                DefaultUnitOfWork<Object> unitOfWork = new DefaultUnitOfWork<Object>(null);
                unitOfWork.attachTransaction(SimpleEventScheduler.this.transactionManager);
                unitOfWork.execute(() -> SimpleEventScheduler.this.eventBus.publish(eventMessage));
            }
            finally {
                SimpleEventScheduler.this.tokens.remove(this.tokenId);
            }
        }

        private EventMessage<?> createMessage() {
            GenericEventMessage<Object> eventMessage = this.event instanceof EventMessage ? new GenericEventMessage(((EventMessage)this.event).getPayload(), ((EventMessage)this.event).getMetaData()) : new GenericEventMessage<Object>(this.event, MetaData.emptyInstance());
            return eventMessage;
        }
    }
}

