/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.saga.repository.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.axonframework.common.jdbc.Oracle11Utils;
import org.axonframework.eventhandling.saga.repository.jdbc.GenericSagaSqlSchema;
import org.axonframework.eventhandling.saga.repository.jdbc.SagaSchema;

public class Oracle11SagaSqlSchema
extends GenericSagaSqlSchema {
    public Oracle11SagaSqlSchema(SagaSchema sagaSchema) {
        super(sagaSchema);
    }

    @Override
    public PreparedStatement sql_createTableAssocValueEntry(Connection conn) throws SQLException {
        conn.prepareStatement("create table " + this.sagaSchema().associationValueEntryTable() + " (\n        id number(38) not null,\n        associationKey varchar(255),\n        associationValue varchar(255),\n        sagaId varchar(255),\n        sagaType varchar(255),\n        primary key (id)\n    )").executeUpdate();
        Oracle11Utils.simulateAutoIncrement(conn, this.sagaSchema().associationValueEntryTable(), "id");
        return Oracle11Utils.createNullStatement(conn);
    }

    @Override
    public PreparedStatement sql_createTableSagaEntry(Connection conn) throws SQLException {
        return conn.prepareStatement("create table " + this.sagaSchema().sagaEntryTable() + " (\n        sagaId varchar(255) not null,\n        revision varchar(255),\n        sagaType varchar(255),\n        serializedSaga blob,\n        primary key (sagaId)\n    )");
    }
}

