/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.saga.repository.jdbc;

import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Set;
import java.util.TreeSet;
import javax.sql.DataSource;
import org.axonframework.common.jdbc.ConnectionProvider;
import org.axonframework.common.jdbc.DataSourceConnectionProvider;
import org.axonframework.common.jdbc.JdbcUtils;
import org.axonframework.common.jdbc.UnitOfWorkAwareConnectionProviderWrapper;
import org.axonframework.eventhandling.saga.AssociationValue;
import org.axonframework.eventhandling.saga.AssociationValues;
import org.axonframework.eventhandling.saga.SagaStorageException;
import org.axonframework.eventhandling.saga.repository.SagaStore;
import org.axonframework.eventhandling.saga.repository.jdbc.GenericSagaSqlSchema;
import org.axonframework.eventhandling.saga.repository.jdbc.SagaSqlSchema;
import org.axonframework.eventhandling.saga.repository.jpa.SagaEntry;
import org.axonframework.eventsourcing.eventstore.TrackingToken;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.xml.XStreamSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcSagaStore
implements SagaStore<Object> {
    private static final Logger logger = LoggerFactory.getLogger(JdbcSagaStore.class);
    private Serializer serializer;
    private final ConnectionProvider connectionProvider;
    private final SagaSqlSchema sqldef;

    public JdbcSagaStore(ConnectionProvider connectionProvider) {
        this(connectionProvider, (SagaSqlSchema)new GenericSagaSqlSchema());
    }

    public JdbcSagaStore(DataSource dataSource, SagaSqlSchema sqldef) {
        this(new UnitOfWorkAwareConnectionProviderWrapper(new DataSourceConnectionProvider(dataSource)), sqldef);
    }

    public JdbcSagaStore(ConnectionProvider connectionProvider, SagaSqlSchema sqldef) {
        this(connectionProvider, sqldef, new XStreamSerializer());
    }

    public JdbcSagaStore(ConnectionProvider connectionProvider, SagaSqlSchema sqldef, Serializer serializer) {
        this.connectionProvider = connectionProvider;
        this.sqldef = sqldef;
        this.serializer = serializer;
    }

    @Override
    public <S> SagaStore.Entry<S> loadSaga(Class<S> sagaType, String sagaIdentifier) {
        EntryImpl entryImpl;
        SerializedObject<?> serializedSaga;
        Connection conn;
        ResultSet resultSet;
        PreparedStatement statement;
        block7: {
            statement = null;
            resultSet = null;
            conn = null;
            conn = this.connectionProvider.getConnection();
            statement = this.sqldef.sql_loadSaga(conn, sagaIdentifier);
            resultSet = statement.executeQuery();
            serializedSaga = null;
            if (resultSet.next()) {
                serializedSaga = this.sqldef.readSerializedSaga(resultSet);
            }
            if (serializedSaga != null) break block7;
            SagaStore.Entry<S> entry = null;
            JdbcUtils.closeQuietly(statement);
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(conn);
            return entry;
        }
        try {
            Object loadedSaga = this.serializer.deserialize(serializedSaga);
            if (logger.isDebugEnabled()) {
                logger.debug("Loaded saga id [{}] of type [{}]", (Object)sagaIdentifier, (Object)loadedSaga.getClass().getName());
            }
            Set<AssociationValue> associations = this.sqldef.readAssociationValues(this.sqldef.sql_findAssociations(conn, sagaIdentifier, this.sagaTypeName(sagaType)).executeQuery());
            entryImpl = new EntryImpl(associations, loadedSaga);
        }
        catch (SQLException e) {
            try {
                throw new SagaStorageException("Exception while loading a Saga", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(statement);
                JdbcUtils.closeQuietly(resultSet);
                JdbcUtils.closeQuietly(conn);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly(statement);
        JdbcUtils.closeQuietly(resultSet);
        JdbcUtils.closeQuietly(conn);
        return entryImpl;
    }

    @Override
    public Set<String> findSagas(Class<?> sagaType, AssociationValue associationValue) {
        TreeSet<String> treeSet;
        ResultSet resultSet = null;
        PreparedStatement statement = null;
        Connection conn = null;
        try {
            conn = this.connectionProvider.getConnection();
            statement = this.sqldef.sql_findAssocSagaIdentifiers(conn, associationValue.getKey(), associationValue.getValue(), this.sagaTypeName(sagaType));
            resultSet = statement.executeQuery();
            TreeSet<String> result = new TreeSet<String>();
            while (resultSet.next()) {
                result.add(resultSet.getString(1));
            }
            treeSet = result;
        }
        catch (SQLException e) {
            try {
                throw new SagaStorageException("Exception while reading saga associations", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(statement);
                JdbcUtils.closeQuietly(resultSet);
                JdbcUtils.closeQuietly(conn);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly(statement);
        JdbcUtils.closeQuietly(resultSet);
        JdbcUtils.closeQuietly(conn);
        return treeSet;
    }

    @Override
    public void deleteSaga(Class<?> sagaType, String sagaIdentifier, Set<AssociationValue> associationValues) {
        PreparedStatement statement1 = null;
        PreparedStatement statement2 = null;
        Connection conn = null;
        try {
            conn = this.connectionProvider.getConnection();
            statement1 = this.sqldef.sql_deleteAssociationEntries(conn, sagaIdentifier);
            statement2 = this.sqldef.sql_deleteSagaEntry(conn, sagaIdentifier);
            statement1.executeUpdate();
            statement2.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new SagaStorageException("Exception occurred while attempting to delete a saga entry", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(statement1);
                JdbcUtils.closeQuietly(statement2);
                JdbcUtils.closeQuietly(conn);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly(statement1);
        JdbcUtils.closeQuietly(statement2);
        JdbcUtils.closeQuietly(conn);
    }

    @Override
    public void updateSaga(Class<?> sagaType, String sagaIdentifier, Object saga, TrackingToken token, AssociationValues associationValues) {
        int updateCount;
        SagaEntry<Object> entry = new SagaEntry<Object>(saga, sagaIdentifier, this.serializer);
        if (logger.isDebugEnabled()) {
            logger.debug("Updating saga id {} as {}", (Object)sagaIdentifier, (Object)new String((byte[])entry.getSerializedSaga(), Charset.forName("UTF-8")));
        }
        PreparedStatement statement = null;
        Connection conn = null;
        try {
            conn = this.connectionProvider.getConnection();
            statement = this.sqldef.sql_updateSaga(conn, entry.getSagaId(), (byte[])entry.getSerializedSaga(), entry.getSagaType(), entry.getRevision());
            updateCount = statement.executeUpdate();
            if (updateCount != 0) {
                for (AssociationValue associationValue : associationValues.addedAssociations()) {
                    JdbcUtils.closeQuietly(statement);
                    statement = this.sqldef.sql_storeAssocValue(conn, associationValue.getKey(), associationValue.getValue(), this.sagaTypeName(sagaType), sagaIdentifier);
                    statement.executeUpdate();
                }
                for (AssociationValue associationValue : associationValues.removedAssociations()) {
                    JdbcUtils.closeQuietly(statement);
                    statement = this.sqldef.sql_removeAssocValue(conn, associationValue.getKey(), associationValue.getValue(), this.sagaTypeName(sagaType), sagaIdentifier);
                    statement.executeUpdate();
                }
            }
        }
        catch (SQLException e) {
            try {
                throw new SagaStorageException("Exception occurred while attempting to update a saga", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(statement);
                JdbcUtils.closeQuietly(conn);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly(statement);
        JdbcUtils.closeQuietly(conn);
        if (updateCount == 0) {
            logger.warn("Expected to be able to update a Saga instance, but no rows were found. Inserting instead.");
            this.insertSaga(sagaType, sagaIdentifier, saga, token, associationValues.asSet());
        }
    }

    @Override
    public void insertSaga(Class<?> sagaType, String sagaIdentifier, Object saga, TrackingToken token, Set<AssociationValue> associationValues) {
        SagaEntry<Object> entry = new SagaEntry<Object>(saga, sagaIdentifier, this.serializer);
        if (logger.isDebugEnabled()) {
            logger.debug("Storing saga id {} as {}", (Object)sagaIdentifier, (Object)new String((byte[])entry.getSerializedSaga(), Charset.forName("UTF-8")));
        }
        Connection conn = null;
        PreparedStatement statement = null;
        try {
            conn = this.connectionProvider.getConnection();
            statement = this.sqldef.sql_storeSaga(conn, entry.getSagaId(), entry.getRevision(), entry.getSagaType(), (byte[])entry.getSerializedSaga());
            statement.executeUpdate();
            for (AssociationValue associationValue : associationValues) {
                JdbcUtils.closeQuietly(statement);
                statement = this.sqldef.sql_storeAssocValue(conn, associationValue.getKey(), associationValue.getValue(), this.sagaTypeName(sagaType), sagaIdentifier);
                statement.executeUpdate();
            }
        }
        catch (SQLException e) {
            try {
                throw new SagaStorageException("Exception occurred while attempting to store a Saga Entry", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(statement);
                JdbcUtils.closeQuietly(conn);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly(statement);
        JdbcUtils.closeQuietly(conn);
    }

    private String sagaTypeName(Class<?> sagaType) {
        return this.serializer.typeForClass(sagaType).getName();
    }

    public void setSerializer(Serializer serializer) {
        this.serializer = serializer;
    }

    public void createSchema() throws SQLException {
        Connection connection = this.connectionProvider.getConnection();
        try {
            this.sqldef.sql_createTableSagaEntry(connection).executeUpdate();
            this.sqldef.sql_createTableAssocValueEntry(connection).executeUpdate();
        }
        finally {
            JdbcUtils.closeQuietly(connection);
        }
    }

    private static class EntryImpl<S>
    implements SagaStore.Entry<S> {
        private final Set<AssociationValue> associations;
        private final S loadedSaga;

        public EntryImpl(Set<AssociationValue> associations, S loadedSaga) {
            this.associations = associations;
            this.loadedSaga = loadedSaga;
        }

        @Override
        public TrackingToken trackingToken() {
            return null;
        }

        @Override
        public Set<AssociationValue> associationValues() {
            return this.associations;
        }

        @Override
        public S saga() {
            return this.loadedSaga;
        }
    }
}

