/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.saga.repository;

import java.util.function.Supplier;
import org.axonframework.common.lock.Lock;
import org.axonframework.common.lock.LockFactory;
import org.axonframework.eventhandling.saga.Saga;
import org.axonframework.eventhandling.saga.SagaRepository;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.messaging.unitofwork.UnitOfWork;

public abstract class LockingSagaRepository<T>
implements SagaRepository<T> {
    private final LockFactory lockFactory;

    protected LockingSagaRepository(LockFactory lockFactory) {
        this.lockFactory = lockFactory;
    }

    @Override
    public Saga<T> load(String sagaIdentifier) {
        this.lockSagaAccess(sagaIdentifier);
        return this.doLoad(sagaIdentifier);
    }

    @Override
    public Saga<T> createInstance(String sagaIdentifier, Supplier<T> factoryMethod) {
        this.lockSagaAccess(sagaIdentifier);
        return this.doCreateInstance(sagaIdentifier, factoryMethod);
    }

    private void lockSagaAccess(String sagaIdentifier) {
        UnitOfWork<?> unitOfWork = CurrentUnitOfWork.get();
        Lock lock = this.lockFactory.obtainLock(sagaIdentifier);
        unitOfWork.root().onCleanup(u -> lock.release());
    }

    protected abstract Saga<T> doLoad(String var1);

    protected abstract Saga<T> doCreateInstance(String var1, Supplier<T> var2);
}

