/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.saga.repository;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.axonframework.common.Assert;
import org.axonframework.common.caching.Cache;
import org.axonframework.eventhandling.saga.AssociationValue;
import org.axonframework.eventhandling.saga.AssociationValues;
import org.axonframework.eventhandling.saga.repository.SagaStore;
import org.axonframework.eventsourcing.eventstore.TrackingToken;

public class CachingSagaStore<T>
implements SagaStore<T> {
    private final SagaStore<T> delegate;
    private final Cache associationsCache;
    private final Cache sagaCache;

    public CachingSagaStore(SagaStore<T> delegate, Cache associationsCache, Cache sagaCache) {
        Assert.notNull(delegate, () -> "You must provide a SagaRepository instance to delegate to");
        Assert.notNull(associationsCache, () -> "You must provide a Cache instance to store the association values");
        Assert.notNull(sagaCache, () -> "You must provide a Cache instance to store the sagas");
        this.delegate = delegate;
        this.associationsCache = associationsCache;
        this.sagaCache = sagaCache;
    }

    @Override
    public Set<String> findSagas(Class<? extends T> sagaType, AssociationValue associationValue) {
        String key = this.cacheKey(associationValue, sagaType);
        Set<String> associations = (Set<String>)this.associationsCache.get(key);
        if (associations == null) {
            associations = this.delegate.findSagas(sagaType, associationValue);
            this.associationsCache.put(key, associations);
        }
        return new HashSet<String>(associations);
    }

    @Override
    public <S extends T> SagaStore.Entry<S> loadSaga(Class<S> sagaType, String sagaIdentifier) {
        SagaStore.Entry<S> saga = (SagaStore.Entry<S>)this.sagaCache.get(sagaIdentifier);
        if (saga == null && (saga = this.delegate.loadSaga(sagaType, sagaIdentifier)) != null) {
            this.sagaCache.put(sagaIdentifier, new CacheEntry(saga));
        }
        return saga;
    }

    @Override
    public void insertSaga(Class<? extends T> sagaType, String sagaIdentifier, T saga, TrackingToken token, Set<AssociationValue> associationValues) {
        this.delegate.insertSaga(sagaType, sagaIdentifier, (T)saga, token, associationValues);
        this.sagaCache.put(sagaIdentifier, new CacheEntry<T>(saga, token, associationValues));
        this.addCachedAssociations(associationValues, sagaIdentifier, sagaType);
    }

    @Override
    public void deleteSaga(Class<? extends T> sagaType, String sagaIdentifier, Set<AssociationValue> associationValues) {
        this.sagaCache.remove(sagaIdentifier);
        associationValues.forEach(av -> this.removeAssociationValueFromCache(sagaType, sagaIdentifier, (AssociationValue)av));
        this.delegate.deleteSaga(sagaType, sagaIdentifier, associationValues);
    }

    private void removeAssociationValueFromCache(Class<?> sagaType, String sagaIdentifier, AssociationValue associationValue) {
        String key = this.cacheKey(associationValue, sagaType);
        Set associations = (Set)this.associationsCache.get(key);
        if (associations != null && associations.remove(sagaIdentifier)) {
            this.associationsCache.put(key, associations);
        }
    }

    protected void addCachedAssociations(Iterable<AssociationValue> associationValues, String sagaIdentifier, Class<?> sagaType) {
        for (AssociationValue associationValue : associationValues) {
            String key = this.cacheKey(associationValue, sagaType);
            Set identifiers = (Set)this.associationsCache.get(key);
            if (identifiers == null || !identifiers.add(sagaIdentifier)) continue;
            this.associationsCache.put(key, identifiers);
        }
    }

    @Override
    public void updateSaga(Class<? extends T> sagaType, String sagaIdentifier, T saga, TrackingToken token, AssociationValues associationValues) {
        this.sagaCache.put(sagaIdentifier, new CacheEntry<T>(saga, token, associationValues.asSet()));
        this.delegate.updateSaga(sagaType, sagaIdentifier, (T)saga, token, associationValues);
        associationValues.removedAssociations().forEach(av -> this.removeAssociationValueFromCache(sagaType, sagaIdentifier, (AssociationValue)av));
        this.addCachedAssociations(associationValues.addedAssociations(), sagaIdentifier, sagaType);
    }

    private String cacheKey(AssociationValue associationValue, Class<?> sagaType) {
        return sagaType.getName() + "/" + associationValue.getKey() + "=" + associationValue.getValue();
    }

    private static class CacheEntry<T>
    implements SagaStore.Entry<T>,
    Serializable {
        private final T saga;
        private final TrackingToken trackingToken;
        private final Set<AssociationValue> associationValues;

        public CacheEntry(T saga, TrackingToken TrackingToken2, Set<AssociationValue> associationValues) {
            this.saga = saga;
            this.trackingToken = TrackingToken2;
            this.associationValues = associationValues;
        }

        public <S extends T> CacheEntry(SagaStore.Entry<S> other) {
            this.saga = other.saga();
            this.trackingToken = other.trackingToken();
            this.associationValues = other.associationValues();
        }

        @Override
        public TrackingToken trackingToken() {
            return this.trackingToken;
        }

        @Override
        public Set<AssociationValue> associationValues() {
            return this.associationValues;
        }

        @Override
        public T saga() {
            return this.saga;
        }
    }
}

