/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.saga.repository;

import java.io.Serializable;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import org.axonframework.eventhandling.saga.AssociationValue;

public class AssociationValueMap {
    private final NavigableSet<SagaAssociationValue> mappings = new ConcurrentSkipListSet<SagaAssociationValue>(new AssociationValueComparator());

    public Set<String> findSagas(String sagaType, AssociationValue associationValue) {
        SagaAssociationValue item;
        HashSet<String> identifiers = new HashSet<String>();
        Iterator iterator = this.mappings.tailSet(new SagaAssociationValue(associationValue, sagaType, null)).iterator();
        while (iterator.hasNext() && (item = (SagaAssociationValue)iterator.next()).getKey().equals(associationValue.getKey())) {
            if (!associationValue.equals(item.getAssociationValue()) || !sagaType.equals(item.getSagaType())) continue;
            identifiers.add(item.getSagaIdentifier());
        }
        return identifiers;
    }

    public void add(AssociationValue associationValue, String sagaType, String sagaIdentifier) {
        this.mappings.add(new SagaAssociationValue(associationValue, sagaType, sagaIdentifier));
    }

    public void remove(AssociationValue associationValue, String sagaType, String sagaIdentifier) {
        this.mappings.remove(new SagaAssociationValue(associationValue, sagaType, sagaIdentifier));
    }

    public void clear() {
        this.mappings.clear();
    }

    public boolean isEmpty() {
        return this.mappings.isEmpty();
    }

    public int size() {
        return this.mappings.size();
    }

    private static class AssociationValueComparator
    implements Comparator<SagaAssociationValue>,
    Serializable {
        private static final long serialVersionUID = -8733800489211327001L;

        private AssociationValueComparator() {
        }

        @Override
        public int compare(SagaAssociationValue o1, SagaAssociationValue o2) {
            int value = o1.getKey().compareTo(o2.getKey());
            if (value == 0 && !Objects.equals(o1.getValue(), o2.getValue())) {
                value = o1.getValue().getClass().getName().compareTo(o2.getValue().getClass().getName());
            }
            if (value == 0 && !Objects.equals(o1.getValue(), o2.getValue())) {
                if (o1.getValue() instanceof Comparable) {
                    value = ((Comparable)o1.getValue()).compareTo(o2.getValue());
                } else {
                    value = o1.getValue().hashCode() - o2.getValue().hashCode();
                    if (value == 0 && o1.getValue() != o2.getValue()) {
                        value = o1.getValue().toString().compareTo(o2.getValue().toString());
                    }
                }
            }
            if (value == 0 && !Objects.equals(o1.getSagaType(), o2.getSagaType())) {
                if (o1.getSagaType() == null) {
                    return -1;
                }
                if (o2.getSagaType() == null) {
                    return 1;
                }
                return o1.getSagaType().compareTo(o2.getSagaType());
            }
            if (value == 0 && !Objects.equals(o1.getSagaIdentifier(), o2.getSagaIdentifier())) {
                if (o1.getSagaIdentifier() == null) {
                    return -1;
                }
                if (o2.getSagaIdentifier() == null) {
                    return 1;
                }
                return o1.getSagaIdentifier().compareTo(o2.getSagaIdentifier());
            }
            return value;
        }
    }

    private static final class SagaAssociationValue {
        private final AssociationValue associationValue;
        private final String sagaType;
        private final String sagaIdentifier;

        private SagaAssociationValue(AssociationValue associationValue, String sagaType, String sagaIdentifier) {
            this.associationValue = associationValue;
            this.sagaType = sagaType;
            this.sagaIdentifier = sagaIdentifier;
        }

        public AssociationValue getAssociationValue() {
            return this.associationValue;
        }

        public String getSagaIdentifier() {
            return this.sagaIdentifier;
        }

        public String getKey() {
            return this.associationValue.getKey();
        }

        public Object getValue() {
            return this.associationValue.getValue();
        }

        public String getSagaType() {
            return this.sagaType;
        }
    }
}

