/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.saga.repository;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.axonframework.common.CollectionUtils;
import org.axonframework.common.lock.LockFactory;
import org.axonframework.common.lock.PessimisticLockFactory;
import org.axonframework.eventhandling.saga.AnnotatedSaga;
import org.axonframework.eventhandling.saga.AssociationValue;
import org.axonframework.eventhandling.saga.ResourceInjector;
import org.axonframework.eventhandling.saga.Saga;
import org.axonframework.eventhandling.saga.metamodel.AnnotationSagaMetaModelFactory;
import org.axonframework.eventhandling.saga.metamodel.SagaModel;
import org.axonframework.eventhandling.saga.repository.LockingSagaRepository;
import org.axonframework.eventhandling.saga.repository.NoResourceInjector;
import org.axonframework.eventhandling.saga.repository.SagaCreationException;
import org.axonframework.eventhandling.saga.repository.SagaStore;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.messaging.unitofwork.UnitOfWork;

public class AnnotatedSagaRepository<T>
extends LockingSagaRepository<T> {
    private final String unsavedSagasResourceKey;
    private final Map<String, AnnotatedSaga<T>> managedSagas;
    private final Class<T> sagaType;
    private final SagaStore<? super T> sagaStore;
    private final SagaModel<T> sagaModel;
    private final ResourceInjector injector;

    public AnnotatedSagaRepository(Class<T> sagaType, SagaStore<? super T> sagaStore) {
        this(sagaType, sagaStore, NoResourceInjector.INSTANCE);
    }

    public AnnotatedSagaRepository(Class<T> sagaType, SagaStore<? super T> sagaStore, ResourceInjector resourceInjector) {
        this(sagaType, sagaStore, new AnnotationSagaMetaModelFactory().modelOf(sagaType), resourceInjector, new PessimisticLockFactory());
    }

    public AnnotatedSagaRepository(Class<T> sagaType, SagaStore<? super T> sagaStore, ResourceInjector resourceInjector, ParameterResolverFactory parameterResolverFactory) {
        this(sagaType, sagaStore, new AnnotationSagaMetaModelFactory(parameterResolverFactory).modelOf(sagaType), resourceInjector, new PessimisticLockFactory());
    }

    public AnnotatedSagaRepository(Class<T> sagaType, SagaStore<? super T> sagaStore, ResourceInjector resourceInjector, ParameterResolverFactory parameterResolverFactory, HandlerDefinition handlerDefinition) {
        this(sagaType, sagaStore, new AnnotationSagaMetaModelFactory(parameterResolverFactory, handlerDefinition).modelOf(sagaType), resourceInjector, new PessimisticLockFactory());
    }

    public AnnotatedSagaRepository(Class<T> sagaType, SagaStore<? super T> sagaStore, SagaModel<T> sagaModel, ResourceInjector resourceInjector, LockFactory lockFactory) {
        super(lockFactory);
        this.injector = resourceInjector;
        this.sagaType = sagaType;
        this.sagaStore = sagaStore;
        this.sagaModel = sagaModel;
        this.managedSagas = new ConcurrentHashMap<String, AnnotatedSaga<T>>();
        this.unsavedSagasResourceKey = "Repository[" + sagaType.getSimpleName() + "]/UnsavedSagas";
    }

    @Override
    public AnnotatedSaga<T> doLoad(String sagaIdentifier) {
        UnitOfWork<?> unitOfWork = CurrentUnitOfWork.get();
        UnitOfWork<?> processRoot = unitOfWork.root();
        AnnotatedSaga loadedSaga = this.managedSagas.computeIfAbsent(sagaIdentifier, id -> {
            AnnotatedSaga<T> result = this.doLoadSaga(sagaIdentifier);
            if (result != null) {
                processRoot.onCleanup(u -> this.managedSagas.remove(id));
            }
            return result;
        });
        if (loadedSaga != null && this.unsavedSagaResource(processRoot).add(sagaIdentifier)) {
            unitOfWork.onPrepareCommit(u -> {
                this.unsavedSagaResource(processRoot).remove(sagaIdentifier);
                this.commit(loadedSaga);
            });
        }
        return loadedSaga;
    }

    @Override
    public AnnotatedSaga<T> doCreateInstance(String sagaIdentifier, Supplier<T> sagaFactory) {
        try {
            UnitOfWork<?> unitOfWork = CurrentUnitOfWork.get();
            UnitOfWork<?> processRoot = unitOfWork.root();
            T sagaRoot = sagaFactory.get();
            this.injector.injectResources(sagaRoot);
            AnnotatedSaga<T> saga = new AnnotatedSaga<T>(sagaIdentifier, Collections.emptySet(), sagaRoot, null, this.sagaModel);
            this.unsavedSagaResource(processRoot).add(sagaIdentifier);
            unitOfWork.onPrepareCommit(u -> {
                if (saga.isActive()) {
                    this.storeSaga(saga);
                    saga.getAssociationValues().commit();
                    this.unsavedSagaResource(processRoot).remove(sagaIdentifier);
                }
            });
            this.managedSagas.put(sagaIdentifier, saga);
            processRoot.onCleanup(u -> this.managedSagas.remove(sagaIdentifier));
            return saga;
        }
        catch (Exception e) {
            throw new SagaCreationException("An error occurred while attempting to create a new managed instance", e);
        }
    }

    protected Set<String> unsavedSagaResource(UnitOfWork<?> unitOfWork) {
        return unitOfWork.getOrComputeResource(this.unsavedSagasResourceKey, i -> new HashSet());
    }

    protected void commit(AnnotatedSaga<T> saga) {
        if (!saga.isActive()) {
            this.deleteSaga(saga);
        } else {
            this.updateSaga(saga);
            saga.getAssociationValues().commit();
        }
    }

    @Override
    public Set<String> find(AssociationValue associationValue) {
        TreeSet<String> sagasFound = new TreeSet<String>();
        sagasFound.addAll(this.managedSagas.values().stream().filter(saga -> saga.getAssociationValues().contains(associationValue)).map(Saga::getSagaIdentifier).collect(Collectors.toList()));
        sagasFound.addAll(this.sagaStore.findSagas(this.sagaType, associationValue));
        return sagasFound;
    }

    protected void deleteSaga(AnnotatedSaga<T> saga) {
        Set associationValues = CollectionUtils.merge(saga.getAssociationValues().asSet(), saga.getAssociationValues().removedAssociations(), HashSet::new);
        this.sagaStore.deleteSaga(this.sagaType, saga.getSagaIdentifier(), associationValues);
    }

    protected void updateSaga(AnnotatedSaga<T> saga) {
        this.sagaStore.updateSaga(this.sagaType, saga.getSagaIdentifier(), saga.root(), saga.trackingToken(), saga.getAssociationValues());
    }

    protected void storeSaga(AnnotatedSaga<T> saga) {
        this.sagaStore.insertSaga(this.sagaType, saga.getSagaIdentifier(), saga.root(), saga.trackingToken(), saga.getAssociationValues().asSet());
    }

    protected AnnotatedSaga<T> doLoadSaga(String sagaIdentifier) {
        SagaStore.Entry<T> entry = this.sagaStore.loadSaga(this.sagaType, sagaIdentifier);
        if (entry != null) {
            T saga = entry.saga();
            this.injector.injectResources(saga);
            return new AnnotatedSaga<T>(sagaIdentifier, entry.associationValues(), saga, entry.trackingToken(), this.sagaModel);
        }
        return null;
    }
}

