/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.saga.metamodel;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.saga.AssociationValue;
import org.axonframework.eventhandling.saga.SagaMethodMessageHandlingMember;
import org.axonframework.eventhandling.saga.metamodel.SagaMetaModelFactory;
import org.axonframework.eventhandling.saga.metamodel.SagaModel;
import org.axonframework.messaging.annotation.AnnotatedHandlerInspector;
import org.axonframework.messaging.annotation.ClasspathHandlerDefinition;
import org.axonframework.messaging.annotation.ClasspathParameterResolverFactory;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.MessageHandlingMember;
import org.axonframework.messaging.annotation.ParameterResolverFactory;

public class AnnotationSagaMetaModelFactory
implements SagaMetaModelFactory {
    private final Map<Class<?>, SagaModel<?>> registry = new ConcurrentHashMap();
    private final ParameterResolverFactory parameterResolverFactory;
    private final HandlerDefinition handlerDefinition;

    public AnnotationSagaMetaModelFactory() {
        this(ClasspathParameterResolverFactory.forClassLoader(Thread.currentThread().getContextClassLoader()));
    }

    public AnnotationSagaMetaModelFactory(ParameterResolverFactory parameterResolverFactory) {
        this(parameterResolverFactory, ClasspathHandlerDefinition.forClassLoader(Thread.currentThread().getContextClassLoader()));
    }

    public AnnotationSagaMetaModelFactory(ParameterResolverFactory parameterResolverFactory, HandlerDefinition handlerDefinition) {
        this.parameterResolverFactory = parameterResolverFactory;
        this.handlerDefinition = handlerDefinition;
    }

    @Override
    public <T> SagaModel<T> modelOf(Class<T> sagaType) {
        return this.registry.computeIfAbsent(sagaType, this::doCreateModel);
    }

    private <T> SagaModel<T> doCreateModel(Class<T> sagaType) {
        AnnotatedHandlerInspector<T> handlerInspector = AnnotatedHandlerInspector.inspectType(sagaType, this.parameterResolverFactory, this.handlerDefinition);
        return new InspectedSagaModel(handlerInspector.getHandlers());
    }

    private class InspectedSagaModel<T>
    implements SagaModel<T> {
        private final List<MessageHandlingMember<? super T>> handlers;

        public InspectedSagaModel(List<MessageHandlingMember<? super T>> handlers) {
            this.handlers = handlers;
        }

        @Override
        public Optional<AssociationValue> resolveAssociation(EventMessage<?> eventMessage) {
            for (MessageHandlingMember<T> handler : this.handlers) {
                if (!handler.canHandle(eventMessage)) continue;
                return handler.unwrap(SagaMethodMessageHandlingMember.class).map(mh -> mh.getAssociationValue(eventMessage));
            }
            return Optional.empty();
        }

        @Override
        public List<MessageHandlingMember<? super T>> findHandlerMethods(EventMessage<?> eventMessage) {
            return this.handlers.stream().filter(h -> h.canHandle(eventMessage)).collect(Collectors.toList());
        }

        @Override
        public boolean hasHandlerMethod(EventMessage<?> eventMessage) {
            for (MessageHandlingMember<T> handler : this.handlers) {
                if (!handler.canHandle(eventMessage)) continue;
                return true;
            }
            return false;
        }

        @Override
        public SagaMetaModelFactory modelFactory() {
            return AnnotationSagaMetaModelFactory.this;
        }
    }
}

