/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.saga;

import java.lang.reflect.Executable;
import java.util.HashMap;
import java.util.Map;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.property.Property;
import org.axonframework.common.property.PropertyAccessStrategy;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.saga.AssociationResolver;
import org.axonframework.messaging.annotation.MessageHandlingMember;

public class PayloadAssociationResolver
implements AssociationResolver {
    private Map<String, Property<?>> propertyMap = new HashMap();

    @Override
    public <T> void validate(String associationPropertyName, MessageHandlingMember<T> handler) {
        this.getProperty(associationPropertyName, handler);
    }

    @Override
    public <T> Object resolve(String associationPropertyName, EventMessage<?> message, MessageHandlingMember<T> handler) {
        return this.getProperty(associationPropertyName, handler).getValue(message.getPayload());
    }

    private <T> Property getProperty(String associationPropertyName, MessageHandlingMember<T> handler) {
        return this.propertyMap.computeIfAbsent(handler.payloadType().getCanonicalName() + associationPropertyName, k -> this.createProperty(associationPropertyName, handler));
    }

    private <T> Property createProperty(String associationPropertyName, MessageHandlingMember<T> handler) {
        Property<?> associationProperty = PropertyAccessStrategy.getProperty(handler.payloadType(), associationPropertyName);
        if (associationProperty == null) {
            String handlerName = handler.unwrap(Executable.class).map(Executable::toGenericString).orElse("unknown");
            throw new AxonConfigurationException(String.format("SagaEventHandler %s defines a property %s that is not defined on the Event it declares to handle (%s)", handlerName, associationPropertyName, handler.payloadType().getName()));
        }
        return associationProperty;
    }
}

