/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.saga;

import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.ListenerInvocationErrorHandler;
import org.axonframework.eventhandling.LoggingErrorHandler;
import org.axonframework.eventhandling.Segment;
import org.axonframework.eventhandling.saga.AbstractSagaManager;
import org.axonframework.eventhandling.saga.AssociationValue;
import org.axonframework.eventhandling.saga.SagaCreationPolicy;
import org.axonframework.eventhandling.saga.SagaInitializationPolicy;
import org.axonframework.eventhandling.saga.SagaInstantiationException;
import org.axonframework.eventhandling.saga.SagaMethodMessageHandlingMember;
import org.axonframework.eventhandling.saga.SagaRepository;
import org.axonframework.eventhandling.saga.metamodel.AnnotationSagaMetaModelFactory;
import org.axonframework.eventhandling.saga.metamodel.SagaModel;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.ParameterResolverFactory;

public class AnnotatedSagaManager<T>
extends AbstractSagaManager<T> {
    private final SagaModel<T> sagaMetaModel;

    private static <T> T newInstance(Class<T> type) {
        try {
            return type.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new SagaInstantiationException("Exception while trying to instantiate a new Saga", e);
        }
    }

    public AnnotatedSagaManager(Class<T> sagaType, SagaRepository<T> sagaRepository) {
        this(sagaType, sagaRepository, () -> AnnotatedSagaManager.newInstance(sagaType));
    }

    public AnnotatedSagaManager(Class<T> sagaType, SagaRepository<T> sagaRepository, ParameterResolverFactory parameterResolverFactory, ListenerInvocationErrorHandler listenerInvocationErrorHandler) {
        this(sagaType, sagaRepository, () -> AnnotatedSagaManager.newInstance(sagaType), new AnnotationSagaMetaModelFactory(parameterResolverFactory).modelOf(sagaType), listenerInvocationErrorHandler);
    }

    public AnnotatedSagaManager(Class<T> sagaType, SagaRepository<T> sagaRepository, ParameterResolverFactory parameterResolverFactory, HandlerDefinition handlerDefinition, ListenerInvocationErrorHandler listenerInvocationErrorHandler) {
        this(sagaType, sagaRepository, () -> AnnotatedSagaManager.newInstance(sagaType), new AnnotationSagaMetaModelFactory(parameterResolverFactory, handlerDefinition).modelOf(sagaType), listenerInvocationErrorHandler);
    }

    public AnnotatedSagaManager(Class<T> sagaType, SagaRepository<T> sagaRepository, Supplier<T> sagaFactory) {
        this(sagaType, sagaRepository, sagaFactory, new AnnotationSagaMetaModelFactory().modelOf(sagaType), (ListenerInvocationErrorHandler)new LoggingErrorHandler());
    }

    public AnnotatedSagaManager(Class<T> sagaType, SagaRepository<T> sagaRepository, Supplier<T> sagaFactory, SagaModel<T> sagaMetaModel, ListenerInvocationErrorHandler listenerInvocationErrorHandler) {
        super(sagaType, sagaRepository, sagaFactory, listenerInvocationErrorHandler);
        this.sagaMetaModel = sagaMetaModel;
    }

    @Override
    public boolean canHandle(EventMessage<?> eventMessage, Segment segment) {
        return this.sagaMetaModel.hasHandlerMethod(eventMessage);
    }

    @Override
    protected SagaInitializationPolicy getSagaCreationPolicy(EventMessage<?> event) {
        return this.sagaMetaModel.findHandlerMethods(event).stream().map(h -> h.unwrap(SagaMethodMessageHandlingMember.class).orElse(null)).filter(Objects::nonNull).filter(sh -> sh.getCreationPolicy() != SagaCreationPolicy.NONE).map(sh -> new SagaInitializationPolicy(sh.getCreationPolicy(), sh.getAssociationValue(event))).findFirst().orElse(SagaInitializationPolicy.NONE);
    }

    @Override
    protected Set<AssociationValue> extractAssociationValues(EventMessage<?> event) {
        return this.sagaMetaModel.findHandlerMethods(event).stream().map(h -> h.unwrap(SagaMethodMessageHandlingMember.class).orElse(null)).filter(Objects::nonNull).map(h -> h.getAssociationValue(event)).filter(Objects::nonNull).collect(Collectors.toSet());
    }
}

