/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.saga;

import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import org.axonframework.common.Assert;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.TrackedEventMessage;
import org.axonframework.eventhandling.saga.AssociationValue;
import org.axonframework.eventhandling.saga.AssociationValues;
import org.axonframework.eventhandling.saga.AssociationValuesImpl;
import org.axonframework.eventhandling.saga.Saga;
import org.axonframework.eventhandling.saga.SagaExecutionException;
import org.axonframework.eventhandling.saga.SagaLifecycle;
import org.axonframework.eventhandling.saga.SagaMethodMessageHandlingMember;
import org.axonframework.eventhandling.saga.metamodel.SagaModel;
import org.axonframework.eventsourcing.eventstore.TrackingToken;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.MessageHandlingMember;

public class AnnotatedSaga<T>
extends SagaLifecycle
implements Saga<T> {
    private final SagaModel<T> metaModel;
    private final AssociationValues associationValues;
    private volatile boolean isActive = true;
    private final String sagaId;
    private final T sagaInstance;
    private final AtomicReference<TrackingToken> trackingToken;

    public AnnotatedSaga(String sagaId, Set<AssociationValue> associationValues, T annotatedSaga, TrackingToken trackingToken, SagaModel<T> metaModel) {
        Assert.notNull(annotatedSaga, () -> "SagaInstance may not be null");
        this.sagaId = sagaId;
        this.associationValues = new AssociationValuesImpl(associationValues);
        this.sagaInstance = annotatedSaga;
        this.metaModel = metaModel;
        this.trackingToken = new AtomicReference<TrackingToken>(trackingToken);
    }

    @Override
    public String getSagaIdentifier() {
        return this.sagaId;
    }

    @Override
    public AssociationValues getAssociationValues() {
        return this.associationValues;
    }

    @Override
    public <R> R invoke(Function<T, R> invocation) {
        try {
            return (R)this.executeWithResult(() -> invocation.apply(this.sagaInstance));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SagaExecutionException("Exception while invoking a Saga", e);
        }
    }

    @Override
    public void execute(Consumer<T> invocation) {
        super.execute(() -> invocation.accept(this.sagaInstance));
    }

    @Override
    public final boolean canHandle(EventMessage<?> event) {
        return this.isActive && this.metaModel.findHandlerMethods(event).stream().anyMatch(h -> h.unwrap(SagaMethodMessageHandlingMember.class).map(sh -> this.getAssociationValues().contains(sh.getAssociationValue(event))).orElse(true));
    }

    @Override
    public final void handle(EventMessage<?> event) {
        if (this.isActive) {
            this.metaModel.findHandlerMethods(event).stream().filter(handler -> handler.unwrap(SagaMethodMessageHandlingMember.class).map(sh -> this.getAssociationValues().contains(sh.getAssociationValue(event))).orElse(true)).findFirst().ifPresent(handler -> this.handle((MessageHandlingMember<? super T>)handler, event));
        }
    }

    private void handle(MessageHandlingMember<? super T> handler, EventMessage<?> event) {
        try {
            this.executeWithResult(() -> handler.handle((Message<?>)event, (T)this.sagaInstance));
            if (event instanceof TrackedEventMessage) {
                this.trackingToken.set(((TrackedEventMessage)event).trackingToken());
            }
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SagaExecutionException("Exception while handling an Event in a Saga", e);
        }
        finally {
            if (this.isEndingHandler(handler).booleanValue()) {
                this.doEnd();
            }
        }
    }

    private Boolean isEndingHandler(MessageHandlingMember<? super T> handler) {
        return handler.unwrap(SagaMethodMessageHandlingMember.class).map(SagaMethodMessageHandlingMember::isEndingHandler).orElse(false);
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public TrackingToken trackingToken() {
        return this.trackingToken.get();
    }

    public T root() {
        return this.sagaInstance;
    }

    @Override
    protected void doEnd() {
        this.isActive = false;
    }

    @Override
    protected void doAssociateWith(AssociationValue property) {
        this.associationValues.add(property);
    }

    @Override
    protected String type() {
        return this.sagaInstance.getClass().getSimpleName();
    }

    @Override
    protected void doRemoveAssociation(AssociationValue property) {
        this.associationValues.remove(property);
    }
}

