/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.saga;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.axonframework.common.Assert;
import org.axonframework.common.IdentifierFactory;
import org.axonframework.eventhandling.EventHandlerInvoker;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.ListenerInvocationErrorHandler;
import org.axonframework.eventhandling.LoggingErrorHandler;
import org.axonframework.eventhandling.PropagatingErrorHandler;
import org.axonframework.eventhandling.ResetNotSupportedException;
import org.axonframework.eventhandling.Segment;
import org.axonframework.eventhandling.saga.AssociationValue;
import org.axonframework.eventhandling.saga.Saga;
import org.axonframework.eventhandling.saga.SagaCreationPolicy;
import org.axonframework.eventhandling.saga.SagaInitializationPolicy;
import org.axonframework.eventhandling.saga.SagaRepository;
import org.axonframework.eventhandling.saga.SagaScopeDescriptor;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.ScopeAware;
import org.axonframework.messaging.ScopeDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSagaManager<T>
implements EventHandlerInvoker,
ScopeAware {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSagaManager.class);
    private final SagaRepository<T> sagaRepository;
    private final Class<T> sagaType;
    private final Supplier<T> sagaFactory;
    private volatile ListenerInvocationErrorHandler listenerInvocationErrorHandler;

    protected AbstractSagaManager(Class<T> sagaType, SagaRepository<T> sagaRepository, Supplier<T> sagaFactory, ListenerInvocationErrorHandler listenerInvocationErrorHandler) {
        this.sagaType = sagaType;
        this.sagaFactory = sagaFactory;
        Assert.notNull(sagaRepository, () -> "sagaRepository may not be null");
        this.sagaRepository = sagaRepository;
        this.listenerInvocationErrorHandler = listenerInvocationErrorHandler;
    }

    @Override
    public void handle(EventMessage<?> event, Segment segment) throws Exception {
        Set<AssociationValue> associationValues = this.extractAssociationValues(event);
        Set sagas = associationValues.stream().flatMap(associationValue -> this.sagaRepository.find((AssociationValue)associationValue).stream()).filter(sagaId -> this.matchesSegment(segment, (String)sagaId)).map(this.sagaRepository::load).filter(Objects::nonNull).filter(Saga::isActive).collect(Collectors.toCollection(HashSet::new));
        boolean sagaOfTypeInvoked = false;
        for (Saga saga : sagas) {
            if (!this.doInvokeSaga(event, saga)) continue;
            sagaOfTypeInvoked = true;
        }
        SagaInitializationPolicy initializationPolicy = this.getSagaCreationPolicy(event);
        if (this.shouldCreateSaga(segment, sagaOfTypeInvoked, initializationPolicy)) {
            this.startNewSaga(event, initializationPolicy.getInitialAssociationValue(), segment);
        }
    }

    private boolean shouldCreateSaga(Segment segment, boolean sagaInvoked, SagaInitializationPolicy initializationPolicy) {
        return (initializationPolicy.getCreationPolicy() == SagaCreationPolicy.ALWAYS || !sagaInvoked && initializationPolicy.getCreationPolicy() == SagaCreationPolicy.IF_NONE_FOUND) && segment.matches(initializationPolicy.getInitialAssociationValue());
    }

    private void startNewSaga(EventMessage event, AssociationValue associationValue, Segment segment) throws Exception {
        Saga<T> newSaga = this.sagaRepository.createInstance(this.createSagaIdentifier(segment), this.sagaFactory);
        newSaga.getAssociationValues().add(associationValue);
        this.doInvokeSaga(event, newSaga);
    }

    protected String createSagaIdentifier(Segment segment) {
        String identifier;
        while (!this.matchesSegment(segment, identifier = IdentifierFactory.getInstance().generateIdentifier())) {
        }
        return identifier;
    }

    protected boolean matchesSegment(Segment segment, String sagaId) {
        return segment.matches(sagaId);
    }

    protected abstract SagaInitializationPolicy getSagaCreationPolicy(EventMessage<?> var1);

    protected abstract Set<AssociationValue> extractAssociationValues(EventMessage<?> var1);

    private boolean doInvokeSaga(EventMessage event, Saga<T> saga) throws Exception {
        if (saga.canHandle(event)) {
            try {
                saga.handle(event);
            }
            catch (Exception e) {
                this.listenerInvocationErrorHandler.onError(e, event, saga);
            }
            return true;
        }
        return false;
    }

    @Deprecated
    public void setSuppressExceptions(boolean suppressExceptions) {
        this.listenerInvocationErrorHandler = suppressExceptions ? new LoggingErrorHandler() : PropagatingErrorHandler.INSTANCE;
    }

    public Class<T> getSagaType() {
        return this.sagaType;
    }

    @Override
    public boolean supportsReset() {
        return false;
    }

    @Override
    public void performReset() {
        throw new ResetNotSupportedException("Sagas do no support resetting tokens");
    }

    @Override
    public void send(Message<?> message, ScopeDescriptor scopeDescription) throws Exception {
        if (!(message instanceof EventMessage)) {
            String exceptionMessage = String.format("Something else than an EventMessage was scheduled for Saga of type [%s], whilst Sagas can only handle EventMessages.", this.getSagaType());
            throw new IllegalArgumentException(exceptionMessage);
        }
        if (this.canResolve(scopeDescription)) {
            String sagaIdentifier = ((SagaScopeDescriptor)scopeDescription).getIdentifier().toString();
            Saga<T> saga = this.sagaRepository.load(sagaIdentifier);
            if (saga != null) {
                saga.handle((EventMessage)message);
            } else {
                logger.debug("Saga (with id: [{}]) cannot be loaded, as it most likely already ended. Hence, message [{}] cannot be handled.", (Object)sagaIdentifier, message);
            }
        }
    }

    @Override
    public boolean canResolve(ScopeDescriptor scopeDescription) {
        return scopeDescription instanceof SagaScopeDescriptor && Objects.equals(this.sagaType.getSimpleName(), ((SagaScopeDescriptor)scopeDescription).getType());
    }
}

