/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.axonframework.common.Assert;
import org.axonframework.common.AxonNonTransientException;
import org.axonframework.common.io.IOUtils;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.eventhandling.AbstractEventProcessor;
import org.axonframework.eventhandling.ErrorHandler;
import org.axonframework.eventhandling.EventHandlerInvoker;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.EventTrackerStatus;
import org.axonframework.eventhandling.GenericTrackedEventMessage;
import org.axonframework.eventhandling.PropagatingErrorHandler;
import org.axonframework.eventhandling.ReplayToken;
import org.axonframework.eventhandling.Segment;
import org.axonframework.eventhandling.TrackedEventMessage;
import org.axonframework.eventhandling.TrackingEventProcessorConfiguration;
import org.axonframework.eventhandling.tokenstore.TokenStore;
import org.axonframework.eventhandling.tokenstore.UnableToClaimTokenException;
import org.axonframework.eventsourcing.DomainEventMessage;
import org.axonframework.eventsourcing.GenericTrackedDomainEventMessage;
import org.axonframework.eventsourcing.eventstore.TrackingToken;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.StreamableMessageSource;
import org.axonframework.messaging.unitofwork.BatchingUnitOfWork;
import org.axonframework.messaging.unitofwork.RollbackConfiguration;
import org.axonframework.messaging.unitofwork.RollbackConfigurationType;
import org.axonframework.monitoring.MessageMonitor;
import org.axonframework.monitoring.NoOpMessageMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackingEventProcessor
extends AbstractEventProcessor {
    private static final Logger logger = LoggerFactory.getLogger(TrackingEventProcessor.class);
    private final StreamableMessageSource<TrackedEventMessage<?>> messageSource;
    private final TokenStore tokenStore;
    private final Function<StreamableMessageSource, TrackingToken> initialTrackingTokenBuilder;
    private final TransactionManager transactionManager;
    private final int batchSize;
    private final int segmentsSize;
    private final ActivityCountingThreadFactory threadFactory;
    private final AtomicReference<State> state = new AtomicReference<State>(State.NOT_STARTED);
    private final ConcurrentMap<Integer, TrackerStatus> activeSegments = new ConcurrentSkipListMap<Integer, TrackerStatus>();
    private final ConcurrentMap<Integer, Long> segmentReleaseDeadlines = new ConcurrentSkipListMap<Integer, Long>();
    private final String segmentIdResourceKey;
    private final String lastTokenResourceKey;
    private final AtomicInteger availableThreads;
    private final long tokenClaimInterval;

    public TrackingEventProcessor(String name, EventHandlerInvoker eventHandlerInvoker, StreamableMessageSource<TrackedEventMessage<?>> messageSource, TokenStore tokenStore, TransactionManager transactionManager) {
        this(name, eventHandlerInvoker, messageSource, tokenStore, transactionManager, NoOpMessageMonitor.INSTANCE);
    }

    public TrackingEventProcessor(String name, EventHandlerInvoker eventHandlerInvoker, StreamableMessageSource<TrackedEventMessage<?>> messageSource, TokenStore tokenStore, TransactionManager transactionManager, MessageMonitor<? super EventMessage<?>> messageMonitor) {
        this(name, eventHandlerInvoker, messageSource, tokenStore, transactionManager, messageMonitor, RollbackConfigurationType.ANY_THROWABLE, PropagatingErrorHandler.INSTANCE, TrackingEventProcessorConfiguration.forSingleThreadedProcessing());
    }

    public TrackingEventProcessor(String name, EventHandlerInvoker eventHandlerInvoker, StreamableMessageSource<TrackedEventMessage<?>> messageSource, TokenStore tokenStore, TransactionManager transactionManager, MessageMonitor<? super EventMessage<?>> messageMonitor, RollbackConfiguration rollbackConfiguration, ErrorHandler errorHandler, TrackingEventProcessorConfiguration config) {
        super(name, eventHandlerInvoker, rollbackConfiguration, errorHandler, messageMonitor);
        this.tokenClaimInterval = config.getTokenClaimInterval();
        this.batchSize = config.getBatchSize();
        this.messageSource = Objects.requireNonNull(messageSource);
        this.tokenStore = Objects.requireNonNull(tokenStore);
        this.segmentsSize = config.getInitialSegmentsCount();
        this.transactionManager = transactionManager;
        this.availableThreads = new AtomicInteger(config.getMaxThreadCount());
        this.threadFactory = new ActivityCountingThreadFactory(config.getThreadFactory(name));
        this.segmentIdResourceKey = "Processor[" + name + "]/SegmentId";
        this.lastTokenResourceKey = "Processor[" + name + "]/Token";
        this.initialTrackingTokenBuilder = config.getInitialTrackingToken();
        this.registerInterceptor((unitOfWork, interceptorChain) -> {
            if (!(unitOfWork instanceof BatchingUnitOfWork) || ((BatchingUnitOfWork)unitOfWork).isFirstMessage()) {
                tokenStore.extendClaim(this.getName(), (Integer)unitOfWork.getResource(this.segmentIdResourceKey));
            }
            if (!(unitOfWork instanceof BatchingUnitOfWork) || ((BatchingUnitOfWork)unitOfWork).isLastMessage()) {
                unitOfWork.onPrepareCommit(uow -> tokenStore.storeToken((TrackingToken)unitOfWork.getResource(this.lastTokenResourceKey), name, (Integer)unitOfWork.getResource(this.segmentIdResourceKey)));
            }
            return interceptorChain.proceed();
        });
    }

    @Override
    public void start() {
        State previousState = this.state.getAndSet(State.STARTED);
        if (!previousState.isRunning()) {
            this.startSegmentWorkers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processingLoop(Segment segment) {
        MessageStream<TrackedEventMessage<?>> eventStream = null;
        long errorWaitTime = 1L;
        try {
            while (this.state.get().isRunning() && this.canClaimSegment(segment.getSegmentId())) {
                try {
                    eventStream = this.ensureEventStreamOpened(eventStream, segment);
                    this.processBatch(segment, eventStream);
                    errorWaitTime = 1L;
                }
                catch (UnableToClaimTokenException e) {
                    logger.info("Segment is owned by another node. Releasing thread to process another segment...");
                    this.releaseSegment(segment.getSegmentId());
                }
                catch (Exception e) {
                    if (errorWaitTime == 1L) {
                        logger.warn("Error occurred. Starting retry mode.", (Throwable)e);
                    }
                    logger.warn("Releasing claim on token and preparing for retry in {}s", (Object)errorWaitTime);
                    this.releaseToken(segment);
                    IOUtils.closeQuietly(eventStream);
                    eventStream = null;
                    this.doSleepFor(TimeUnit.SECONDS.toMillis(errorWaitTime));
                    errorWaitTime = Math.min(errorWaitTime * 2L, 60L);
                }
            }
        }
        finally {
            IOUtils.closeQuietly(eventStream);
            this.releaseToken(segment);
        }
    }

    private void releaseToken(Segment segment) {
        try {
            this.transactionManager.executeInTransaction(() -> this.tokenStore.releaseClaim(this.getName(), segment.getSegmentId()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void processBatch(Segment segment, MessageStream<TrackedEventMessage<?>> eventStream) throws Exception {
        ArrayList batch = new ArrayList();
        try {
            TrackedEventMessage<?> trackedEventMessage;
            this.checkSegmentCaughtUp(segment, eventStream);
            TrackingToken lastToken = null;
            if (eventStream.hasNextAvailable(1, TimeUnit.SECONDS)) {
                for (int i = 0; i < this.batchSize * 10 && batch.size() < this.batchSize && eventStream.hasNextAvailable(); ++i) {
                    trackedEventMessage = eventStream.nextAvailable();
                    lastToken = trackedEventMessage.trackingToken();
                    if (this.canHandle(trackedEventMessage, segment)) {
                        batch.add(trackedEventMessage);
                        continue;
                    }
                    this.reportIgnored(trackedEventMessage);
                }
                if (batch.isEmpty()) {
                    TrackingToken finalLastToken = lastToken;
                    this.transactionManager.executeInTransaction(() -> this.tokenStore.storeToken(finalLastToken, this.getName(), segment.getSegmentId()));
                    return;
                }
            } else {
                this.transactionManager.executeInTransaction(() -> this.tokenStore.extendClaim(this.getName(), segment.getSegmentId()));
                return;
            }
            TrackingToken finalLastToken = lastToken;
            while (lastToken != null && eventStream.peek().filter(event -> finalLastToken.equals(event.trackingToken())).isPresent()) {
                trackedEventMessage = eventStream.nextAvailable();
                if (!this.canHandle(trackedEventMessage, segment)) continue;
                batch.add(trackedEventMessage);
            }
            BatchingUnitOfWork unitOfWork = new BatchingUnitOfWork(batch);
            unitOfWork.attachTransaction(this.transactionManager);
            unitOfWork.resources().put(this.segmentIdResourceKey, segment.getSegmentId());
            unitOfWork.resources().put(this.lastTokenResourceKey, finalLastToken);
            this.processInUnitOfWork(batch, unitOfWork, segment);
            this.activeSegments.computeIfPresent(segment.getSegmentId(), (k, v) -> ((TrackerStatus)v).advancedTo(finalLastToken));
        }
        catch (InterruptedException e) {
            logger.error(String.format("Event processor [%s] was interrupted. Shutting down.", this.getName()), (Throwable)e);
            this.shutDown();
            Thread.currentThread().interrupt();
        }
    }

    private void checkSegmentCaughtUp(Segment segment, MessageStream<TrackedEventMessage<?>> eventStream) {
        if (!eventStream.hasNextAvailable()) {
            this.activeSegments.computeIfPresent(segment.getSegmentId(), (k, v) -> ((TrackerStatus)v).caughtUp());
        }
    }

    private MessageStream<TrackedEventMessage<?>> ensureEventStreamOpened(MessageStream<TrackedEventMessage<?>> eventStreamIn, Segment segment) {
        MessageStream eventStream = eventStreamIn;
        if (eventStream == null && this.state.get().isRunning()) {
            TrackingToken trackingToken = this.transactionManager.fetchInTransaction(() -> this.tokenStore.fetchToken(this.getName(), segment.getSegmentId()));
            logger.info("Fetched token: {} for segment: {}", (Object)trackingToken, (Object)segment);
            eventStream = this.transactionManager.fetchInTransaction(() -> this.doOpenStream(trackingToken));
        }
        return eventStream;
    }

    private MessageStream<TrackedEventMessage<?>> doOpenStream(TrackingToken trackingToken) {
        if (trackingToken instanceof ReplayToken) {
            return new ReplayingMessageStream((ReplayToken)trackingToken, this.messageSource.openStream(((ReplayToken)trackingToken).unwrap()));
        }
        return this.messageSource.openStream(trackingToken);
    }

    @Deprecated
    public void pause() {
        this.state.updateAndGet(s -> s.isRunning() ? State.PAUSED : s);
    }

    public void releaseSegment(int segmentId) {
        this.releaseSegment(segmentId, this.tokenClaimInterval * 2L, TimeUnit.MILLISECONDS);
    }

    public void releaseSegment(int segmentId, long blacklistDuration, TimeUnit unit) {
        this.segmentReleaseDeadlines.put(segmentId, System.currentTimeMillis() + unit.toMillis(blacklistDuration));
    }

    private boolean canClaimSegment(int segmentId) {
        return !this.segmentReleaseDeadlines.containsKey(segmentId) || (Long)this.segmentReleaseDeadlines.get(segmentId) < System.currentTimeMillis();
    }

    public void resetTokens() {
        this.resetTokens(this.initialTrackingTokenBuilder);
    }

    public void resetTokens(Function<StreamableMessageSource, TrackingToken> initialTrackingTokenSupplier) {
        this.resetTokens(initialTrackingTokenSupplier.apply(this.messageSource));
    }

    public void resetTokens(TrackingToken startPosition) {
        Assert.state(this.supportsReset(), () -> "The handlers assigned to this Processor do not support a reset");
        Assert.state(!this.isRunning() && this.activeProcessorThreads() == 0, () -> "TrackingProcessor must be shut down before triggering a reset");
        this.transactionManager.executeInTransaction(() -> {
            int i;
            int[] segments = this.tokenStore.fetchSegments(this.getName());
            TrackingToken[] tokens = new TrackingToken[segments.length];
            for (i = 0; i < segments.length; ++i) {
                tokens[i] = this.tokenStore.fetchToken(this.getName(), segments[i]);
            }
            this.eventHandlerInvoker().performReset();
            for (i = 0; i < tokens.length; ++i) {
                this.tokenStore.storeToken(ReplayToken.createReplayToken(tokens[i], startPosition), this.getName(), segments[i]);
            }
        });
    }

    public boolean supportsReset() {
        return this.eventHandlerInvoker().supportsReset();
    }

    public boolean isRunning() {
        return this.state.get().isRunning();
    }

    public boolean isError() {
        return this.state.get() == State.PAUSED_ERROR;
    }

    @Override
    public void shutDown() {
        if (this.state.getAndSet(State.SHUT_DOWN).isRunning()) {
            logger.info("Shutdown state set for Processor '{}'. Awaiting termination...", (Object)this.getName());
            try {
                while (this.threadFactory.activeThreads() > 0) {
                    Thread.sleep(1L);
                }
            }
            catch (InterruptedException e) {
                logger.info("Thread was interrupted while waiting for TrackingProcessor '{}' shutdown.", (Object)this.getName());
                Thread.currentThread().interrupt();
            }
        }
    }

    public int availableProcessorThreads() {
        return this.availableThreads.get();
    }

    public int activeProcessorThreads() {
        return this.activeSegments.size();
    }

    public Map<Integer, EventTrackerStatus> processingStatus() {
        return Collections.unmodifiableMap(this.activeSegments);
    }

    protected State getState() {
        return this.state.get();
    }

    protected void startSegmentWorkers() {
        this.threadFactory.newThread(new WorkerLauncher()).start();
    }

    protected void doSleepFor(long millisToSleep) {
        long deadline = System.currentTimeMillis() + millisToSleep;
        try {
            long timeLeft;
            while (this.getState().isRunning() && (timeLeft = deadline - System.currentTimeMillis()) > 0L) {
                Thread.sleep(Math.min(timeLeft, 100L));
            }
        }
        catch (InterruptedException e) {
            logger.warn("Thread interrupted. Preparing to shut down event processor");
            this.shutDown();
            Thread.currentThread().interrupt();
        }
    }

    private class ReplayingMessageStream
    implements MessageStream<TrackedEventMessage<?>> {
        private final MessageStream<TrackedEventMessage<?>> delegate;
        private ReplayToken lastToken;

        public ReplayingMessageStream(ReplayToken token, MessageStream<TrackedEventMessage<?>> delegate) {
            this.delegate = delegate;
            this.lastToken = token;
        }

        @Override
        public Optional<TrackedEventMessage<?>> peek() {
            return this.delegate.peek();
        }

        @Override
        public boolean hasNextAvailable(int timeout, TimeUnit unit) throws InterruptedException {
            return this.delegate.hasNextAvailable(timeout, unit);
        }

        @Override
        public TrackedEventMessage<?> nextAvailable() throws InterruptedException {
            TrackedEventMessage<?> trackedEventMessage = this.alterToken(this.delegate.nextAvailable());
            this.lastToken = trackedEventMessage.trackingToken() instanceof ReplayToken ? (ReplayToken)trackedEventMessage.trackingToken() : null;
            return trackedEventMessage;
        }

        @Override
        public void close() {
            this.delegate.close();
        }

        @Override
        public boolean hasNextAvailable() {
            return this.delegate.hasNextAvailable();
        }

        public <T> TrackedEventMessage<T> alterToken(TrackedEventMessage<T> message) {
            if (this.lastToken == null) {
                return message;
            }
            if (message instanceof DomainEventMessage) {
                return new GenericTrackedDomainEventMessage(this.lastToken.advancedTo(message.trackingToken()), (DomainEventMessage)((Object)message));
            }
            return new GenericTrackedEventMessage<T>(this.lastToken.advancedTo(message.trackingToken()), message);
        }
    }

    private class WorkerLauncher
    implements Runnable {
        private WorkerLauncher() {
        }

        @Override
        public void run() {
            int waitTime = 1;
            String processorName = TrackingEventProcessor.this.getName();
            while (TrackingEventProcessor.this.getState().isRunning()) {
                int[] tokenStoreCurrentSegments;
                block10: {
                    try {
                        tokenStoreCurrentSegments = TrackingEventProcessor.this.tokenStore.fetchSegments(processorName);
                        waitTime = 1;
                        if (tokenStoreCurrentSegments.length != 0 || TrackingEventProcessor.this.segmentsSize <= 0) break block10;
                        tokenStoreCurrentSegments = TrackingEventProcessor.this.transactionManager.fetchInTransaction(() -> {
                            TrackingToken initialToken = (TrackingToken)TrackingEventProcessor.this.initialTrackingTokenBuilder.apply(TrackingEventProcessor.this.messageSource);
                            TrackingEventProcessor.this.tokenStore.initializeTokenSegments(processorName, TrackingEventProcessor.this.segmentsSize, initialToken);
                            return TrackingEventProcessor.this.tokenStore.fetchSegments(processorName);
                        });
                    }
                    catch (Exception e) {
                        logger.warn("Fetch Segments for Processor '{}' failed: {}. Preparing for retry in {}s", new Object[]{processorName, e.getMessage(), waitTime});
                        TrackingEventProcessor.this.doSleepFor(TimeUnit.SECONDS.toMillis(waitTime));
                        waitTime = Math.min(waitTime * 2, 60);
                        continue;
                    }
                }
                Segment[] segments = Segment.computeSegments(tokenStoreCurrentSegments);
                TrackingSegmentWorker workingInCurrentThread = null;
                for (int i = 0; i < segments.length && TrackingEventProcessor.this.availableThreads.get() > 0; ++i) {
                    Segment segment = segments[i];
                    if (TrackingEventProcessor.this.activeSegments.containsKey(segment.getSegmentId()) || !TrackingEventProcessor.this.canClaimSegment(segment.getSegmentId())) continue;
                    try {
                        TrackingEventProcessor.this.transactionManager.executeInTransaction(() -> {
                            TrackingToken token = TrackingEventProcessor.this.tokenStore.fetchToken(processorName, segment.getSegmentId());
                            TrackingEventProcessor.this.activeSegments.putIfAbsent(segment.getSegmentId(), new TrackerStatus(segment, token));
                        });
                    }
                    catch (UnableToClaimTokenException ucte) {
                        logger.debug("Unable to claim the token for segment: {}. It is owned by another process", (Object)segment.getSegmentId());
                        TrackingEventProcessor.this.activeSegments.remove(segment.getSegmentId());
                        continue;
                    }
                    catch (Exception e) {
                        TrackingEventProcessor.this.activeSegments.remove(segment.getSegmentId());
                        if (AxonNonTransientException.isCauseOf(e)) {
                            logger.error("An unrecoverable error has occurred wile attempting to claim a token for segment: {}. Shutting down processor [{}].", new Object[]{segment.getSegmentId(), TrackingEventProcessor.this.getName(), e});
                            TrackingEventProcessor.this.state.set(State.PAUSED_ERROR);
                            break;
                        }
                        logger.info("An error occurred while attempting to claim a token for segment: {}. Will retry later...", (Object)segment.getSegmentId(), (Object)e);
                        continue;
                    }
                    TrackingSegmentWorker trackingSegmentWorker = new TrackingSegmentWorker(segment);
                    if (TrackingEventProcessor.this.availableThreads.decrementAndGet() > 0) {
                        logger.info("Dispatching new tracking segment worker: {}", (Object)trackingSegmentWorker);
                        TrackingEventProcessor.this.threadFactory.newThread(trackingSegmentWorker).start();
                        continue;
                    }
                    workingInCurrentThread = trackingSegmentWorker;
                    break;
                }
                if (Objects.nonNull(workingInCurrentThread)) {
                    logger.info("Using current Thread for last segment worker: {}", workingInCurrentThread);
                    workingInCurrentThread.run();
                    return;
                }
                TrackingEventProcessor.this.doSleepFor(TrackingEventProcessor.this.tokenClaimInterval);
            }
        }
    }

    private class TrackingSegmentWorker
    implements Runnable {
        private final Segment segment;

        public TrackingSegmentWorker(Segment segment) {
            this.segment = segment;
        }

        @Override
        public void run() {
            try {
                TrackingEventProcessor.this.processingLoop(this.segment);
            }
            catch (Throwable e) {
                logger.error("Processing loop ended due to uncaught exception. Pausing processor in Error State.", e);
                TrackingEventProcessor.this.state.set(State.PAUSED_ERROR);
            }
            finally {
                TrackingEventProcessor.this.activeSegments.remove(this.segment.getSegmentId());
                if (TrackingEventProcessor.this.availableThreads.getAndIncrement() == 0 && TrackingEventProcessor.this.getState().isRunning()) {
                    logger.info("No Worker Launcher active. Using current thread to assign segments.");
                    new WorkerLauncher().run();
                }
            }
        }

        public String toString() {
            return "TrackingSegmentWorker{processor=" + TrackingEventProcessor.this.getName() + ", segment=" + this.segment + '}';
        }
    }

    private static final class TrackerStatus
    implements EventTrackerStatus {
        private final Segment segment;
        private final boolean caughtUp;
        private final TrackingToken trackingToken;

        private TrackerStatus(Segment segment, TrackingToken trackingToken) {
            this(segment, false, trackingToken);
        }

        private TrackerStatus(Segment segment, boolean caughtUp, TrackingToken trackingToken) {
            this.segment = segment;
            this.caughtUp = caughtUp;
            this.trackingToken = trackingToken;
        }

        private TrackerStatus caughtUp() {
            if (this.caughtUp) {
                return this;
            }
            return new TrackerStatus(this.segment, true, this.trackingToken);
        }

        private TrackerStatus advancedTo(TrackingToken trackingToken) {
            if (Objects.equals(this.trackingToken, trackingToken)) {
                return this;
            }
            return new TrackerStatus(this.segment, this.caughtUp, trackingToken);
        }

        @Override
        public Segment getSegment() {
            return this.segment;
        }

        @Override
        public boolean isCaughtUp() {
            return this.caughtUp;
        }

        @Override
        public boolean isReplaying() {
            return this.trackingToken instanceof ReplayToken;
        }

        @Override
        public TrackingToken getTrackingToken() {
            if (this.trackingToken instanceof ReplayToken) {
                return ((ReplayToken)this.trackingToken).unwrap();
            }
            return this.trackingToken;
        }
    }

    private static class CountingRunnable
    implements Runnable {
        private final Runnable delegate;
        private final AtomicInteger counter;

        public CountingRunnable(Runnable delegate, AtomicInteger counter) {
            this.delegate = delegate;
            this.counter = counter;
        }

        @Override
        public void run() {
            this.counter.incrementAndGet();
            try {
                this.delegate.run();
            }
            finally {
                this.counter.decrementAndGet();
            }
        }
    }

    private static class ActivityCountingThreadFactory
    implements ThreadFactory {
        private final AtomicInteger threadCount = new AtomicInteger(0);
        private final ThreadFactory delegate;

        public ActivityCountingThreadFactory(ThreadFactory delegate) {
            this.delegate = delegate;
        }

        @Override
        public Thread newThread(Runnable r) {
            return this.delegate.newThread(new CountingRunnable(r, this.threadCount));
        }

        public int activeThreads() {
            return this.threadCount.get();
        }
    }

    protected static enum State {
        NOT_STARTED(false),
        STARTED(true),
        PAUSED(false),
        SHUT_DOWN(false),
        PAUSED_ERROR(false);

        private final boolean allowProcessing;

        private State(boolean allowProcessing) {
            this.allowProcessing = allowProcessing;
        }

        boolean isRunning() {
            return this.allowProcessing;
        }
    }
}

