/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import java.util.List;
import org.axonframework.common.Registration;
import org.axonframework.common.io.IOUtils;
import org.axonframework.eventhandling.AbstractEventProcessor;
import org.axonframework.eventhandling.DirectEventProcessingStrategy;
import org.axonframework.eventhandling.ErrorHandler;
import org.axonframework.eventhandling.EventHandlerInvoker;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.EventProcessingException;
import org.axonframework.eventhandling.EventProcessingStrategy;
import org.axonframework.eventhandling.PropagatingErrorHandler;
import org.axonframework.eventhandling.Segment;
import org.axonframework.messaging.SubscribableMessageSource;
import org.axonframework.messaging.unitofwork.BatchingUnitOfWork;
import org.axonframework.messaging.unitofwork.RollbackConfiguration;
import org.axonframework.messaging.unitofwork.RollbackConfigurationType;
import org.axonframework.monitoring.MessageMonitor;
import org.axonframework.monitoring.NoOpMessageMonitor;

public class SubscribingEventProcessor
extends AbstractEventProcessor {
    private final SubscribableMessageSource<? extends EventMessage<?>> messageSource;
    private final EventProcessingStrategy processingStrategy;
    private volatile Registration eventBusRegistration;

    public SubscribingEventProcessor(String name, EventHandlerInvoker eventHandlerInvoker, SubscribableMessageSource<EventMessage<?>> messageSource) {
        this(name, eventHandlerInvoker, messageSource, DirectEventProcessingStrategy.INSTANCE, PropagatingErrorHandler.INSTANCE);
    }

    public SubscribingEventProcessor(String name, EventHandlerInvoker eventHandlerInvoker, SubscribableMessageSource<EventMessage<?>> messageSource, EventProcessingStrategy processingStrategy, ErrorHandler errorHandler) {
        this(name, eventHandlerInvoker, messageSource, processingStrategy, errorHandler, NoOpMessageMonitor.INSTANCE);
    }

    public SubscribingEventProcessor(String name, EventHandlerInvoker eventHandlerInvoker, SubscribableMessageSource<? extends EventMessage<?>> messageSource, EventProcessingStrategy processingStrategy, ErrorHandler errorHandler, MessageMonitor<? super EventMessage<?>> messageMonitor) {
        this(name, eventHandlerInvoker, RollbackConfigurationType.ANY_THROWABLE, messageSource, processingStrategy, errorHandler, messageMonitor);
    }

    public SubscribingEventProcessor(String name, EventHandlerInvoker eventHandlerInvoker, RollbackConfiguration rollbackConfiguration, SubscribableMessageSource<? extends EventMessage<?>> messageSource, EventProcessingStrategy processingStrategy, ErrorHandler errorHandler, MessageMonitor<? super EventMessage<?>> messageMonitor) {
        super(name, eventHandlerInvoker, rollbackConfiguration, errorHandler, messageMonitor);
        this.messageSource = messageSource;
        this.processingStrategy = processingStrategy;
    }

    @Override
    public void start() {
        if (this.eventBusRegistration == null) {
            this.eventBusRegistration = this.messageSource.subscribe(eventMessages -> this.processingStrategy.handle((List<? extends EventMessage<?>>)eventMessages, this::process));
        }
    }

    protected void process(List<? extends EventMessage<?>> eventMessages) {
        try {
            this.processInUnitOfWork(eventMessages, new BatchingUnitOfWork(eventMessages), Segment.ROOT_SEGMENT);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EventProcessingException("Exception occurred while processing events", e);
        }
    }

    @Override
    public void shutDown() {
        IOUtils.closeQuietly(this.eventBusRegistration);
        this.eventBusRegistration = null;
    }
}

