/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.axonframework.common.ObjectUtils;
import org.axonframework.eventhandling.AnnotationEventListenerAdapter;
import org.axonframework.eventhandling.EventHandlerInvoker;
import org.axonframework.eventhandling.EventListener;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.ListenerInvocationErrorHandler;
import org.axonframework.eventhandling.LoggingErrorHandler;
import org.axonframework.eventhandling.Segment;
import org.axonframework.eventhandling.async.SequencingPolicy;
import org.axonframework.eventhandling.async.SequentialPerAggregatePolicy;
import org.axonframework.messaging.annotation.ParameterResolverFactory;

public class SimpleEventHandlerInvoker
implements EventHandlerInvoker {
    private final List<?> eventListeners;
    private final List<EventListener> wrappedEventListeners;
    private final ListenerInvocationErrorHandler listenerInvocationErrorHandler;
    private final SequencingPolicy<? super EventMessage<?>> sequencingPolicy;

    private static List<?> detectList(Object[] eventListeners) {
        return eventListeners.length == 1 && eventListeners[0] instanceof List ? (List)eventListeners[0] : Arrays.asList(eventListeners);
    }

    public SimpleEventHandlerInvoker(Object ... eventListeners) {
        this(SimpleEventHandlerInvoker.detectList(eventListeners), new LoggingErrorHandler());
    }

    public SimpleEventHandlerInvoker(List<?> eventListeners, ListenerInvocationErrorHandler listenerInvocationErrorHandler) {
        this(eventListeners, listenerInvocationErrorHandler, SequentialPerAggregatePolicy.instance());
    }

    public SimpleEventHandlerInvoker(List<?> eventListeners, ListenerInvocationErrorHandler listenerInvocationErrorHandler, SequencingPolicy<? super EventMessage<?>> sequencingPolicy) {
        this.eventListeners = eventListeners;
        this.wrappedEventListeners = eventListeners.stream().map(listener -> listener instanceof EventListener ? (EventListener)listener : new AnnotationEventListenerAdapter(listener)).collect(Collectors.toCollection(ArrayList::new));
        this.sequencingPolicy = sequencingPolicy;
        this.listenerInvocationErrorHandler = listenerInvocationErrorHandler;
    }

    public SimpleEventHandlerInvoker(List<?> eventListeners, ParameterResolverFactory parameterResolverFactory, ListenerInvocationErrorHandler listenerInvocationErrorHandler) {
        this(eventListeners, parameterResolverFactory, listenerInvocationErrorHandler, new SequentialPerAggregatePolicy());
    }

    public SimpleEventHandlerInvoker(List<?> eventListeners, ParameterResolverFactory parameterResolverFactory, ListenerInvocationErrorHandler listenerInvocationErrorHandler, SequencingPolicy<? super EventMessage<?>> sequencingPolicy) {
        this.eventListeners = eventListeners;
        this.wrappedEventListeners = eventListeners.stream().map(listener -> listener instanceof EventListener ? (EventListener)listener : new AnnotationEventListenerAdapter(listener, parameterResolverFactory)).collect(Collectors.toCollection(ArrayList::new));
        this.sequencingPolicy = sequencingPolicy;
        this.listenerInvocationErrorHandler = listenerInvocationErrorHandler;
    }

    public List<?> eventListeners() {
        return Collections.unmodifiableList(this.eventListeners);
    }

    @Override
    public void handle(EventMessage<?> message, Segment segment) throws Exception {
        for (EventListener listener : this.wrappedEventListeners) {
            try {
                listener.handle(message);
            }
            catch (Exception e) {
                this.listenerInvocationErrorHandler.onError(e, message, listener);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canHandle(EventMessage<?> eventMessage, Segment segment) {
        if (!this.hasHandler(eventMessage)) return false;
        if (!segment.matches(Objects.hashCode(ObjectUtils.getOrDefault(this.sequencingPolicy.getSequenceIdentifierFor(eventMessage), eventMessage::getIdentifier)))) return false;
        return true;
    }

    private boolean hasHandler(EventMessage<?> eventMessage) {
        for (EventListener eventListener : this.wrappedEventListeners) {
            if (!eventListener.canHandle(eventMessage)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean supportsReset() {
        for (EventListener eventListener : this.wrappedEventListeners) {
            if (eventListener.supportsReset()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void performReset() {
        for (EventListener eventListener : this.wrappedEventListeners) {
            eventListener.prepareReset();
        }
    }

    public ListenerInvocationErrorHandler getListenerInvocationErrorHandler() {
        return this.listenerInvocationErrorHandler;
    }

    public SequencingPolicy<? super EventMessage<?>> getSequencingPolicy() {
        return this.sequencingPolicy;
    }
}

