/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.axonframework.eventhandling.AbstractEventBus;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.TrackedEventMessage;
import org.axonframework.eventsourcing.eventstore.EventUtils;
import org.axonframework.eventsourcing.eventstore.TrackingEventStream;
import org.axonframework.eventsourcing.eventstore.TrackingToken;
import org.axonframework.monitoring.MessageMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleEventBus
extends AbstractEventBus {
    private static final Logger logger = LoggerFactory.getLogger(SimpleEventBus.class);
    private static final int DEFAULT_QUEUE_CAPACITY = Integer.MAX_VALUE;
    private final Collection<EventConsumer> eventStreams = new CopyOnWriteArraySet<EventConsumer>();
    private final int queueCapacity;

    public SimpleEventBus() {
        this.queueCapacity = Integer.MAX_VALUE;
    }

    public SimpleEventBus(int queueCapacity, MessageMonitor<? super EventMessage<?>> messageMonitor) {
        super(messageMonitor);
        this.queueCapacity = queueCapacity;
    }

    @Override
    protected void afterCommit(List<? extends EventMessage<?>> events) {
        this.eventStreams.forEach(reader -> ((EventConsumer)reader).addEvents(events));
    }

    @Override
    public TrackingEventStream openStream(TrackingToken trackingToken) {
        if (trackingToken != null) {
            throw new UnsupportedOperationException("The simple event bus does not support non-null tracking tokens");
        }
        EventConsumer eventStream = new EventConsumer(this.queueCapacity);
        this.eventStreams.add(eventStream);
        return eventStream;
    }

    private class EventConsumer
    implements TrackingEventStream {
        private final BlockingQueue<TrackedEventMessage<?>> eventQueue;
        private TrackedEventMessage<?> peekEvent;

        private EventConsumer(int queueCapacity) {
            this.eventQueue = new LinkedBlockingQueue(queueCapacity);
        }

        private void addEvents(List<? extends EventMessage<?>> events) {
            events.forEach(eventMessage -> {
                try {
                    this.eventQueue.put(EventUtils.asTrackedEventMessage(eventMessage, null));
                }
                catch (InterruptedException e) {
                    logger.warn("Event producer thread was interrupted. Shutting down.", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            });
        }

        @Override
        public Optional<TrackedEventMessage<?>> peek() {
            return Optional.ofNullable(this.peekEvent == null && !this.hasNextAvailable() ? null : this.peekEvent);
        }

        @Override
        public boolean hasNextAvailable(int timeout, TimeUnit unit) {
            try {
                return this.peekEvent != null || (this.peekEvent = this.eventQueue.poll(timeout, unit)) != null;
            }
            catch (InterruptedException e) {
                logger.warn("Consumer thread was interrupted. Returning thread to event processor.", (Throwable)e);
                Thread.currentThread().interrupt();
                return false;
            }
        }

        @Override
        public TrackedEventMessage<?> nextAvailable() {
            try {
                TrackedEventMessage<?> trackedEventMessage = this.peekEvent == null ? this.eventQueue.take() : this.peekEvent;
                return trackedEventMessage;
            }
            catch (InterruptedException e) {
                logger.warn("Consumer thread was interrupted. Returning thread to event processor.", (Throwable)e);
                Thread.currentThread().interrupt();
                TrackedEventMessage<?> trackedEventMessage = null;
                return trackedEventMessage;
            }
            finally {
                this.peekEvent = null;
            }
        }

        @Override
        public void close() {
            SimpleEventBus.this.eventStreams.remove(this);
        }
    }
}

