/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import org.axonframework.eventhandling.EventListener;
import org.axonframework.eventhandling.EventListenerProxy;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.ListenerInvocationErrorHandler;
import org.axonframework.eventhandling.saga.AnnotatedSaga;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingErrorHandler
implements ListenerInvocationErrorHandler {
    private final Logger logger;

    public LoggingErrorHandler() {
        this(LoggerFactory.getLogger(LoggingErrorHandler.class));
    }

    public LoggingErrorHandler(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void onError(Exception exception, EventMessage<?> event, EventListener eventListener) {
        Class<?> eventListenerType = this.getEventListenerType(eventListener);
        this.logger.error("EventListener [{}] failed to handle event [{}] ({}). Continuing processing with next listener", new Object[]{eventListenerType.getSimpleName(), event.getIdentifier(), event.getPayloadType().getName(), exception});
    }

    private Class<?> getEventListenerType(EventListener eventListener) {
        if (eventListener instanceof EventListenerProxy) {
            return ((EventListenerProxy)eventListener).getTargetType();
        }
        if (eventListener instanceof AnnotatedSaga) {
            return ((AnnotatedSaga)eventListener).root().getClass();
        }
        return eventListener.getClass();
    }
}

