/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import org.axonframework.eventhandling.EventListenerProxy;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventhandling.ResetNotSupportedException;
import org.axonframework.eventhandling.ResetTriggeredEvent;
import org.axonframework.messaging.annotation.AnnotatedHandlerInspector;
import org.axonframework.messaging.annotation.ClasspathHandlerDefinition;
import org.axonframework.messaging.annotation.ClasspathParameterResolverFactory;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.MessageHandlingMember;
import org.axonframework.messaging.annotation.ParameterResolverFactory;

public class AnnotationEventListenerAdapter
implements EventListenerProxy {
    private final AnnotatedHandlerInspector<Object> inspector;
    private final Class<?> listenerType;
    private final Object annotatedEventListener;

    public AnnotationEventListenerAdapter(Object annotatedEventListener) {
        this(annotatedEventListener, ClasspathParameterResolverFactory.forClass(annotatedEventListener.getClass()));
    }

    public AnnotationEventListenerAdapter(Object annotatedEventListener, ParameterResolverFactory parameterResolverFactory) {
        this(annotatedEventListener, parameterResolverFactory, ClasspathHandlerDefinition.forClass(annotatedEventListener.getClass()));
    }

    public AnnotationEventListenerAdapter(Object annotatedEventListener, ParameterResolverFactory parameterResolverFactory, HandlerDefinition handlerDefinition) {
        this.annotatedEventListener = annotatedEventListener;
        this.listenerType = annotatedEventListener.getClass();
        this.inspector = AnnotatedHandlerInspector.inspectType(annotatedEventListener.getClass(), parameterResolverFactory, handlerDefinition);
    }

    @Override
    public void handle(EventMessage<?> event) throws Exception {
        for (MessageHandlingMember<Object> handler : this.inspector.getHandlers()) {
            if (!handler.canHandle(event)) continue;
            handler.handle(event, this.annotatedEventListener);
            break;
        }
    }

    @Override
    public boolean canHandle(EventMessage<?> event) {
        for (MessageHandlingMember<Object> handler : this.inspector.getHandlers()) {
            if (!handler.canHandle(event)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Class<?> getTargetType() {
        return this.listenerType;
    }

    @Override
    public void prepareReset() {
        try {
            this.handle(GenericEventMessage.asEventMessage(new ResetTriggeredEvent()));
        }
        catch (Exception e) {
            throw new ResetNotSupportedException("An Error occurred while notifying handlers of the reset", e);
        }
    }

    @Override
    public boolean supportsReset() {
        return true;
    }
}

