/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.axonframework.common.ObjectUtils;
import org.axonframework.common.Registration;
import org.axonframework.eventhandling.ErrorContext;
import org.axonframework.eventhandling.ErrorHandler;
import org.axonframework.eventhandling.EventHandlerInvoker;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.EventProcessor;
import org.axonframework.eventhandling.PropagatingErrorHandler;
import org.axonframework.eventhandling.Segment;
import org.axonframework.messaging.DefaultInterceptorChain;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.unitofwork.RollbackConfiguration;
import org.axonframework.messaging.unitofwork.UnitOfWork;
import org.axonframework.monitoring.MessageMonitor;
import org.axonframework.monitoring.NoOpMessageMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEventProcessor
implements EventProcessor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<MessageHandlerInterceptor<? super EventMessage<?>>> interceptors = new CopyOnWriteArrayList();
    private final String name;
    private final EventHandlerInvoker eventHandlerInvoker;
    private final RollbackConfiguration rollbackConfiguration;
    private final ErrorHandler errorHandler;
    private final MessageMonitor<? super EventMessage<?>> messageMonitor;

    public AbstractEventProcessor(String name, EventHandlerInvoker eventHandlerInvoker, RollbackConfiguration rollbackConfiguration, ErrorHandler errorHandler, MessageMonitor<? super EventMessage<?>> messageMonitor) {
        this.name = Objects.requireNonNull(name);
        this.eventHandlerInvoker = Objects.requireNonNull(eventHandlerInvoker);
        this.rollbackConfiguration = Objects.requireNonNull(rollbackConfiguration);
        this.errorHandler = (ErrorHandler)((Object)ObjectUtils.getOrDefault(errorHandler, () -> PropagatingErrorHandler.INSTANCE));
        this.messageMonitor = (MessageMonitor)((Object)ObjectUtils.getOrDefault(messageMonitor, NoOpMessageMonitor::instance));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Registration registerInterceptor(MessageHandlerInterceptor<? super EventMessage<?>> interceptor) {
        this.interceptors.add(interceptor);
        return () -> this.interceptors.remove(interceptor);
    }

    @Override
    public List<MessageHandlerInterceptor<? super EventMessage<?>>> getHandlerInterceptors() {
        return Collections.unmodifiableList(this.interceptors);
    }

    public String toString() {
        return this.getName();
    }

    protected boolean canHandle(EventMessage<?> eventMessage, Segment segment) throws Exception {
        try {
            return this.eventHandlerInvoker.canHandle(eventMessage, segment);
        }
        catch (Exception e) {
            this.errorHandler.handleError(new ErrorContext(this.getName(), e, Collections.singletonList(eventMessage)));
            return false;
        }
    }

    protected void processInUnitOfWork(List<? extends EventMessage<?>> eventMessages, UnitOfWork<? extends EventMessage<?>> unitOfWork, Segment segment) throws Exception {
        try {
            unitOfWork.executeWithResult(() -> {
                MessageMonitor.MonitorCallback monitorCallback = this.messageMonitor.onMessageIngested((EventMessage<?>)unitOfWork.getMessage());
                return new DefaultInterceptorChain<EventMessage>(unitOfWork, this.interceptors, m -> {
                    try {
                        this.eventHandlerInvoker.handle((EventMessage<?>)m, segment);
                        monitorCallback.reportSuccess();
                        return null;
                    }
                    catch (Throwable throwable) {
                        monitorCallback.reportFailure(throwable);
                        throw throwable;
                    }
                }).proceed();
            }, this.rollbackConfiguration);
        }
        catch (Exception e) {
            if (unitOfWork.isRolledBack()) {
                this.errorHandler.handleError(new ErrorContext(this.getName(), e, eventMessages));
            }
            this.logger.info("Exception occurred while processing a message, but unit of work was committed. {}", (Object)e.getClass().getName());
        }
    }

    protected EventHandlerInvoker eventHandlerInvoker() {
        return this.eventHandlerInvoker;
    }

    protected void reportIgnored(EventMessage<?> eventMessage) {
        this.messageMonitor.onMessageIngested(eventMessage).reportIgnored();
    }
}

