/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.deadline.quartz;

import java.sql.Date;
import java.time.Duration;
import java.time.Instant;
import org.axonframework.common.IdentifierFactory;
import org.axonframework.common.transaction.NoTransactionManager;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.deadline.AbstractDeadlineManager;
import org.axonframework.deadline.DeadlineException;
import org.axonframework.deadline.DeadlineMessage;
import org.axonframework.deadline.GenericDeadlineMessage;
import org.axonframework.deadline.quartz.DeadlineJob;
import org.axonframework.messaging.ScopeAwareProvider;
import org.axonframework.messaging.ScopeDescriptor;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.xml.XStreamSerializer;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.matchers.GroupMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuartzDeadlineManager
extends AbstractDeadlineManager {
    private static final Logger logger = LoggerFactory.getLogger(QuartzDeadlineManager.class);
    private static final String JOB_NAME_PREFIX = "deadline-";
    private final Scheduler scheduler;
    private final ScopeAwareProvider scopeAwareProvider;
    private final TransactionManager transactionManager;
    private final Serializer serializer;

    public QuartzDeadlineManager(Scheduler scheduler, ScopeAwareProvider scopeAwareProvider) {
        this(scheduler, scopeAwareProvider, NoTransactionManager.INSTANCE);
    }

    public QuartzDeadlineManager(Scheduler scheduler, ScopeAwareProvider scopeAwareProvider, TransactionManager transactionManager) {
        this(scheduler, scopeAwareProvider, transactionManager, new XStreamSerializer());
    }

    public QuartzDeadlineManager(Scheduler scheduler, ScopeAwareProvider scopeAwareProvider, TransactionManager transactionManager, Serializer serializer) {
        this.scheduler = scheduler;
        this.scopeAwareProvider = scopeAwareProvider;
        this.transactionManager = transactionManager;
        this.serializer = serializer;
        try {
            this.initialize();
        }
        catch (SchedulerException e) {
            throw new DeadlineException("Unable to initialize quartz scheduler", e);
        }
    }

    private void initialize() throws SchedulerException {
        this.scheduler.getContext().put(DeadlineJob.TRANSACTION_MANAGER_KEY, (Object)this.transactionManager);
        this.scheduler.getContext().put(DeadlineJob.SCOPE_AWARE_RESOLVER, (Object)this.scopeAwareProvider);
        this.scheduler.getContext().put(DeadlineJob.JOB_DATA_SERIALIZER, (Object)this.serializer);
    }

    @Override
    public void schedule(Instant triggerDateTime, String deadlineName, Object messageOrPayload, ScopeDescriptor deadlineScope, String scheduleId) {
        this.runOnPrepareCommitOrNow(() -> {
            DeadlineMessage deadlineMessage = GenericDeadlineMessage.asDeadlineMessage(deadlineName, messageOrPayload);
            try {
                JobDetail jobDetail = this.buildJobDetail(deadlineMessage, deadlineScope, new JobKey(scheduleId, deadlineName));
                this.scheduler.scheduleJob(jobDetail, QuartzDeadlineManager.buildTrigger(triggerDateTime, jobDetail.getKey()));
            }
            catch (SchedulerException e) {
                throw new DeadlineException("An error occurred while setting a timer for a deadline", e);
            }
        });
    }

    @Override
    public void schedule(Duration triggerDuration, String deadlineName, Object messageOrPayload, ScopeDescriptor deadlineScope, String scheduleId) {
        this.schedule(Instant.now().plus(triggerDuration), deadlineName, messageOrPayload, deadlineScope, scheduleId);
    }

    @Override
    public String generateScheduleId() {
        return JOB_NAME_PREFIX + IdentifierFactory.getInstance().generateIdentifier();
    }

    @Override
    public void cancelSchedule(String deadlineName, String scheduleId) {
        this.runOnPrepareCommitOrNow(() -> this.cancelSchedule(JobKey.jobKey((String)scheduleId, (String)deadlineName)));
    }

    @Override
    public void cancelAll(String deadlineName) {
        this.runOnPrepareCommitOrNow(() -> {
            try {
                this.scheduler.getJobKeys(GroupMatcher.groupEquals((String)deadlineName)).forEach(this::cancelSchedule);
            }
            catch (SchedulerException e) {
                throw new DeadlineException("An error occurred while cancelling a timer for a deadline manager", e);
            }
        });
    }

    private void cancelSchedule(JobKey jobKey) {
        try {
            if (!this.scheduler.deleteJob(jobKey)) {
                logger.warn("The job belonging to this token could not be deleted.");
            }
        }
        catch (SchedulerException e) {
            throw new DeadlineException("An error occurred while cancelling a timer for a deadline manager", e);
        }
    }

    private JobDetail buildJobDetail(DeadlineMessage deadlineMessage, ScopeDescriptor deadlineScope, JobKey jobKey) {
        JobDataMap jobData = DeadlineJob.DeadlineJobDataBinder.toJobData(this.serializer, deadlineMessage, deadlineScope);
        return JobBuilder.newJob(DeadlineJob.class).withDescription(deadlineMessage.getPayloadType().getName()).withIdentity(jobKey).usingJobData(jobData).build();
    }

    private static Trigger buildTrigger(Instant triggerDateTime, JobKey key) {
        return TriggerBuilder.newTrigger().forJob(key).startAt(Date.from(triggerDateTime)).build();
    }
}

