/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.deadline;

import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.axonframework.common.Assert;
import org.axonframework.common.AxonThreadFactory;
import org.axonframework.common.transaction.NoTransactionManager;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.deadline.AbstractDeadlineManager;
import org.axonframework.deadline.DeadlineMessage;
import org.axonframework.deadline.GenericDeadlineMessage;
import org.axonframework.messaging.ExecutionException;
import org.axonframework.messaging.ScopeAwareProvider;
import org.axonframework.messaging.ScopeDescriptor;
import org.axonframework.messaging.unitofwork.DefaultUnitOfWork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleDeadlineManager
extends AbstractDeadlineManager {
    private static final Logger logger = LoggerFactory.getLogger(SimpleDeadlineManager.class);
    private static final String THREAD_FACTORY_GROUP_NAME = "deadlineManager";
    private final ScopeAwareProvider scopeAwareProvider;
    private final ScheduledExecutorService scheduledExecutorService;
    private final TransactionManager transactionManager;
    private final Map<DeadlineId, Future<?>> scheduledTasks = new ConcurrentHashMap();

    public SimpleDeadlineManager(ScopeAwareProvider scopeAwareProvider) {
        this(scopeAwareProvider, NoTransactionManager.INSTANCE);
    }

    public SimpleDeadlineManager(ScopeAwareProvider scopeAwareProvider, TransactionManager transactionManager) {
        this(scopeAwareProvider, Executors.newSingleThreadScheduledExecutor(new AxonThreadFactory(THREAD_FACTORY_GROUP_NAME)), transactionManager);
    }

    public SimpleDeadlineManager(ScopeAwareProvider scopeAwareProvider, ScheduledExecutorService scheduledExecutorService, TransactionManager transactionManager) {
        Assert.notNull(scopeAwareProvider, () -> "cannot process deadline messages without scope aware components to send them too");
        Assert.notNull(scheduledExecutorService, () -> "scheduledExecutorService may not be null");
        Assert.notNull(transactionManager, () -> "transactionManager may not be null");
        this.scheduledExecutorService = scheduledExecutorService;
        this.transactionManager = transactionManager;
        this.scopeAwareProvider = scopeAwareProvider;
    }

    @Override
    public void schedule(Duration triggerDuration, String deadlineName, Object messageOrPayload, ScopeDescriptor deadlineScope, String scheduleId) {
        this.runOnPrepareCommitOrNow(() -> {
            ScheduledFuture<?> scheduledFuture = this.scheduledExecutorService.schedule(new DeadlineTask(deadlineName, deadlineScope, messageOrPayload, scheduleId), triggerDuration.toMillis(), TimeUnit.MILLISECONDS);
            this.scheduledTasks.put(new DeadlineId(deadlineName, scheduleId), scheduledFuture);
        });
    }

    @Override
    public void cancelSchedule(String deadlineName, String scheduleId) {
        this.runOnPrepareCommitOrNow(() -> this.cancelSchedule(new DeadlineId(deadlineName, scheduleId)));
    }

    @Override
    public void cancelAll(String deadlineName) {
        this.runOnPrepareCommitOrNow(() -> this.scheduledTasks.entrySet().stream().map(Map.Entry::getKey).filter(scheduledTaskId -> scheduledTaskId.getDeadlineName().equals(deadlineName)).forEach(this::cancelSchedule));
    }

    private void cancelSchedule(DeadlineId deadlineId) {
        Future<?> future = this.scheduledTasks.remove(deadlineId);
        if (future != null) {
            future.cancel(false);
        }
    }

    private static class DeadlineId {
        private final String deadlineName;
        private final String deadlineId;

        private DeadlineId(String deadlineName, String deadlineId) {
            this.deadlineId = deadlineId;
            this.deadlineName = deadlineName;
        }

        public String getDeadlineName() {
            return this.deadlineName;
        }

        public String getDeadlineId() {
            return this.deadlineId;
        }

        public int hashCode() {
            return Objects.hash(this.deadlineName, this.deadlineId);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            DeadlineId other = (DeadlineId)obj;
            return Objects.equals(this.deadlineName, other.deadlineName) && Objects.equals(this.deadlineId, other.deadlineId);
        }

        public String toString() {
            return "DeadlineId{deadlineName='" + this.deadlineName + '\'' + ", deadlineId='" + this.deadlineId + '\'' + '}';
        }
    }

    private class DeadlineTask
    implements Runnable {
        private final String deadlineName;
        private final ScopeDescriptor deadlineScope;
        private final Object messageOrPayload;
        private final String deadlineId;

        private DeadlineTask(String deadlineName, ScopeDescriptor deadlineScope, Object messageOrPayload, String deadlineId) {
            this.deadlineName = deadlineName;
            this.deadlineScope = deadlineScope;
            this.messageOrPayload = messageOrPayload;
            this.deadlineId = deadlineId;
        }

        @Override
        public void run() {
            DeadlineMessage deadlineMessage = GenericDeadlineMessage.asDeadlineMessage(this.deadlineName, this.messageOrPayload);
            if (logger.isDebugEnabled()) {
                logger.debug("Triggered deadline");
            }
            try {
                DefaultUnitOfWork unitOfWork = new DefaultUnitOfWork(deadlineMessage);
                unitOfWork.attachTransaction(SimpleDeadlineManager.this.transactionManager);
                unitOfWork.execute(() -> this.executeScheduledDeadline(deadlineMessage, this.deadlineScope));
            }
            finally {
                SimpleDeadlineManager.this.scheduledTasks.remove(new DeadlineId(this.deadlineName, this.deadlineId));
            }
        }

        private void executeScheduledDeadline(DeadlineMessage deadlineMessage, ScopeDescriptor deadlineScope) {
            SimpleDeadlineManager.this.scopeAwareProvider.provideScopeAwareStream(deadlineScope).filter(scopeAwareComponent -> scopeAwareComponent.canResolve(deadlineScope)).forEach(scopeAwareComponent -> {
                try {
                    scopeAwareComponent.send(deadlineMessage, deadlineScope);
                }
                catch (Exception e) {
                    String exceptionMessage = String.format("Failed to send a DeadlineMessage for scope [%s]", deadlineScope.scopeDescription());
                    throw new ExecutionException(exceptionMessage, e);
                }
            });
        }
    }
}

