/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.deadline;

import java.time.Duration;
import java.time.Instant;
import org.axonframework.common.IdentifierFactory;
import org.axonframework.messaging.Scope;
import org.axonframework.messaging.ScopeDescriptor;

public interface DeadlineManager {
    default public String schedule(Instant triggerDateTime, String deadlineName) {
        return this.schedule(triggerDateTime, deadlineName, null);
    }

    default public String schedule(Instant triggerDateTime, String deadlineName, Object messageOrPayload) {
        return this.schedule(triggerDateTime, deadlineName, messageOrPayload, Scope.describeCurrentScope());
    }

    default public String schedule(Instant triggerDateTime, String deadlineName, Object messageOrPayload, ScopeDescriptor deadlineScope) {
        String scheduleId = this.generateScheduleId();
        this.schedule(triggerDateTime, deadlineName, messageOrPayload, deadlineScope, scheduleId);
        return scheduleId;
    }

    default public void schedule(Instant triggerDateTime, String deadlineName, Object messageOrPayload, ScopeDescriptor deadlineScope, String scheduleId) {
        this.schedule(Duration.between(Instant.now(), triggerDateTime), deadlineName, messageOrPayload, deadlineScope, scheduleId);
    }

    default public String schedule(Duration triggerDuration, String deadlineName) {
        return this.schedule(triggerDuration, deadlineName, null);
    }

    default public String schedule(Duration triggerDuration, String deadlineName, Object messageOrPayload) {
        return this.schedule(triggerDuration, deadlineName, messageOrPayload, Scope.describeCurrentScope());
    }

    default public String schedule(Duration triggerDuration, String deadlineName, Object messageOrPayload, ScopeDescriptor deadlineScope) {
        String scheduleId = this.generateScheduleId();
        this.schedule(triggerDuration, deadlineName, messageOrPayload, deadlineScope, scheduleId);
        return scheduleId;
    }

    public void schedule(Duration var1, String var2, Object var3, ScopeDescriptor var4, String var5);

    default public String generateScheduleId() {
        return IdentifierFactory.getInstance().generateIdentifier();
    }

    public void cancelSchedule(String var1, String var2);

    public void cancelAll(String var1);
}

