/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.config;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.axonframework.common.Assert;
import org.axonframework.common.annotation.AnnotationUtils;
import org.axonframework.common.transaction.NoTransactionManager;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.config.Component;
import org.axonframework.config.Configuration;
import org.axonframework.config.EventProcessingConfiguration;
import org.axonframework.config.ModuleConfiguration;
import org.axonframework.config.ProcessingGroup;
import org.axonframework.eventhandling.DirectEventProcessingStrategy;
import org.axonframework.eventhandling.ErrorHandler;
import org.axonframework.eventhandling.EventHandlerInvoker;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.EventProcessingStrategy;
import org.axonframework.eventhandling.EventProcessor;
import org.axonframework.eventhandling.ListenerInvocationErrorHandler;
import org.axonframework.eventhandling.LoggingErrorHandler;
import org.axonframework.eventhandling.PropagatingErrorHandler;
import org.axonframework.eventhandling.SubscribingEventProcessor;
import org.axonframework.eventhandling.TrackedEventMessage;
import org.axonframework.eventhandling.TrackingEventProcessor;
import org.axonframework.eventhandling.TrackingEventProcessorConfiguration;
import org.axonframework.eventhandling.saga.AnnotatedSagaManager;
import org.axonframework.eventhandling.saga.SagaRepository;
import org.axonframework.eventhandling.saga.repository.AnnotatedSagaRepository;
import org.axonframework.eventhandling.saga.repository.SagaStore;
import org.axonframework.eventhandling.saga.repository.inmemory.InMemorySagaStore;
import org.axonframework.eventhandling.tokenstore.TokenStore;
import org.axonframework.eventhandling.tokenstore.inmemory.InMemoryTokenStore;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.StreamableMessageSource;
import org.axonframework.messaging.SubscribableMessageSource;
import org.axonframework.messaging.interceptors.CorrelationDataInterceptor;
import org.axonframework.messaging.unitofwork.RollbackConfiguration;
import org.axonframework.messaging.unitofwork.RollbackConfigurationType;
import org.axonframework.monitoring.MessageMonitor;

public class SagaConfiguration<S>
implements ModuleConfiguration {
    private final Class<S> sagaType;
    private final ProcessorInfo processorInfo;
    private final Function<Configuration, SubscribableMessageSource<EventMessage<?>>> subscribableMessageSourceBuilder;
    private final Function<Configuration, StreamableMessageSource<TrackedEventMessage<?>>> streamableMessageSourceBuilder;
    private final Function<Configuration, EventProcessingStrategy> processingStrategy;
    private final Component<TrackingEventProcessorConfiguration> trackingEventProcessorConfiguration;
    private final Component<AnnotatedSagaManager<S>> sagaManager;
    private final Component<SagaRepository<S>> sagaRepository;
    private final Component<SagaStore<? super S>> sagaStore;
    @Deprecated
    private final Component<RollbackConfiguration> rollbackConfiguration;
    @Deprecated
    private final Component<ErrorHandler> errorHandler;
    private final Component<ListenerInvocationErrorHandler> listenerInvocationErrorHandler;
    @Deprecated
    private final Component<TokenStore> tokenStore;
    @Deprecated
    private final Component<TransactionManager> transactionManager;
    @Deprecated
    private final Component<MessageMonitor<? super EventMessage<?>>> messageMonitor;
    private final List<Function<Configuration, MessageHandlerInterceptor<? super EventMessage<?>>>> handlerInterceptors = new ArrayList();
    private Configuration config;

    @Override
    public void start() {
    }

    @Override
    public void shutdown() {
    }

    public static <S> SagaConfiguration<S> subscribingSagaManager(Class<S> sagaType) {
        return SagaConfiguration.subscribingSagaManager(sagaType, Configuration::eventBus);
    }

    public static <S> SagaConfiguration<S> subscribingSagaManager(Class<S> sagaType, String processingGroup) {
        return SagaConfiguration.subscribingSagaManager(sagaType, processingGroup, Configuration::eventBus, c -> DirectEventProcessingStrategy.INSTANCE);
    }

    public static <S> SagaConfiguration<S> subscribingSagaManager(Class<S> sagaType, Function<Configuration, SubscribableMessageSource<EventMessage<?>>> messageSourceBuilder) {
        return SagaConfiguration.subscribingSagaManager(sagaType, messageSourceBuilder, c -> DirectEventProcessingStrategy.INSTANCE);
    }

    public static <S> SagaConfiguration<S> subscribingSagaManager(Class<S> sagaType, Function<Configuration, SubscribableMessageSource<EventMessage<?>>> messageSourceBuilder, Function<Configuration, EventProcessingStrategy> eventProcessingStrategy) {
        ProcessorInfo processorInfo = new ProcessorInfo(true, ProcessorInfo.ProcessorType.SUBSCRIBING, SagaConfiguration.processingGroupName(sagaType));
        return new SagaConfiguration<S>(sagaType, processorInfo, SubscribingEventProcessor.class, c -> null, messageSourceBuilder, eventProcessingStrategy);
    }

    public static <S> SagaConfiguration<S> subscribingSagaManager(Class<S> sagaType, String processingGroup, Function<Configuration, SubscribableMessageSource<EventMessage<?>>> messageSourceBuilder, Function<Configuration, EventProcessingStrategy> eventProcessingStrategy) {
        ProcessorInfo processorInfo = new ProcessorInfo(false, ProcessorInfo.ProcessorType.SUBSCRIBING, processingGroup);
        return new SagaConfiguration<S>(sagaType, processorInfo, SubscribingEventProcessor.class, c -> null, messageSourceBuilder, eventProcessingStrategy);
    }

    public static <S> SagaConfiguration<S> trackingSagaManager(Class<S> sagaType) {
        return SagaConfiguration.trackingSagaManager(sagaType, Configuration::eventBus);
    }

    public static <S> SagaConfiguration<S> trackingSagaManager(Class<S> sagaType, String processingGroup) {
        return SagaConfiguration.trackingSagaManager(sagaType, processingGroup, Configuration::eventBus);
    }

    public static <S> SagaConfiguration<S> trackingSagaManager(Class<S> sagaType, Function<Configuration, StreamableMessageSource<TrackedEventMessage<?>>> messageSourceBuilder) {
        ProcessorInfo processorInfo = new ProcessorInfo(true, ProcessorInfo.ProcessorType.TRACKING, SagaConfiguration.processingGroupName(sagaType));
        return new SagaConfiguration<S>(sagaType, processorInfo, TrackingEventProcessor.class, messageSourceBuilder, c -> null, c -> null);
    }

    public static <S> SagaConfiguration<S> trackingSagaManager(Class<S> sagaType, String processingGroup, Function<Configuration, StreamableMessageSource<TrackedEventMessage<?>>> messageSourceBuilder) {
        ProcessorInfo processorInfo = new ProcessorInfo(false, ProcessorInfo.ProcessorType.TRACKING, processingGroup);
        return new SagaConfiguration<S>(sagaType, processorInfo, TrackingEventProcessor.class, messageSourceBuilder, c -> null, c -> null);
    }

    private SagaConfiguration(Class<S> sagaType, ProcessorInfo processorInfo, Class<? extends EventProcessor> eventProcessorType, Function<Configuration, StreamableMessageSource<TrackedEventMessage<?>>> streamableMessageSourceBuilder, Function<Configuration, SubscribableMessageSource<EventMessage<?>>> subscribableMessageSourceBuilder, Function<Configuration, EventProcessingStrategy> processingStrategy) {
        this.sagaType = sagaType;
        this.processorInfo = processorInfo;
        this.streamableMessageSourceBuilder = streamableMessageSourceBuilder;
        this.subscribableMessageSourceBuilder = subscribableMessageSourceBuilder;
        this.processingStrategy = processingStrategy;
        String managerName = sagaType.getSimpleName() + "Manager";
        String repositoryName = sagaType.getSimpleName() + "Repository";
        this.transactionManager = new Component<TransactionManager>(() -> this.config, "transactionManager", c -> c.getComponent(TransactionManager.class, NoTransactionManager::instance));
        this.messageMonitor = new Component<MessageMonitor>(() -> this.config, "messageMonitor", c -> c.messageMonitor(eventProcessorType, processorInfo.getProcessingGroup()));
        this.tokenStore = new Component<TokenStore>(() -> this.config, "tokenStore", c -> c.getComponent(TokenStore.class, InMemoryTokenStore::new));
        this.errorHandler = new Component<ErrorHandler>(() -> this.config, "errorHandler", c -> c.getComponent(ErrorHandler.class, () -> PropagatingErrorHandler.INSTANCE));
        this.listenerInvocationErrorHandler = new Component<ListenerInvocationErrorHandler>(() -> this.config, "listenerInvocationErrorHandler", c -> c.getComponent(ListenerInvocationErrorHandler.class, LoggingErrorHandler::new));
        this.rollbackConfiguration = new Component<RollbackConfiguration>(() -> this.config, "rollbackConfiguration", c -> c.getComponent(RollbackConfiguration.class, () -> RollbackConfigurationType.ANY_THROWABLE));
        this.sagaStore = new Component<SagaStore>(() -> this.config, "sagaStore", c -> c.getComponent(SagaStore.class, InMemorySagaStore::new));
        this.sagaRepository = new Component<SagaRepository>(() -> this.config, repositoryName, c -> new AnnotatedSagaRepository<S>(sagaType, this.sagaStore.get(), c.resourceInjector(), c.parameterResolverFactory(), c.handlerDefinition(sagaType)));
        this.sagaManager = new Component<AnnotatedSagaManager>(() -> this.config, managerName, c -> new AnnotatedSagaManager<S>(sagaType, this.sagaRepository.get(), c.parameterResolverFactory(), c.handlerDefinition(sagaType), this.listenerInvocationErrorHandler.get()));
        this.trackingEventProcessorConfiguration = new Component<TrackingEventProcessorConfiguration>(() -> this.config, "ProcessorConfiguration", c -> c.getComponent(TrackingEventProcessorConfiguration.class, TrackingEventProcessorConfiguration::forSingleThreadedProcessing));
    }

    public Class<S> getSagaType() {
        return this.sagaType;
    }

    public SagaConfiguration<S> configureSagaStore(Function<Configuration, SagaStore<? super S>> sagaStoreBuilder) {
        this.sagaStore.update(sagaStoreBuilder);
        return this;
    }

    @Deprecated
    public SagaConfiguration<S> registerHandlerInterceptor(Function<Configuration, MessageHandlerInterceptor<? super EventMessage<?>>> handlerInterceptorBuilder) {
        if (this.config != null) {
            this.eventProcessingConfiguration().registerHandlerInterceptor(this.processorInfo.getProcessingGroup(), handlerInterceptorBuilder);
        } else {
            this.handlerInterceptors.add(handlerInterceptorBuilder);
        }
        return this;
    }

    public SagaConfiguration<S> configureTrackingProcessor(Function<Configuration, TrackingEventProcessorConfiguration> trackingEventProcessorConfiguration) {
        this.trackingEventProcessorConfiguration.update(trackingEventProcessorConfiguration);
        return this;
    }

    @Deprecated
    public SagaConfiguration<S> configureTokenStore(Function<Configuration, TokenStore> tokenStore) {
        this.tokenStore.update(tokenStore);
        return this;
    }

    @Deprecated
    public SagaConfiguration<S> configureErrorHandler(Function<Configuration, ErrorHandler> errorHandler) {
        this.errorHandler.update(errorHandler);
        return this;
    }

    public SagaConfiguration<S> configureListenerInvocationErrorHandler(Function<Configuration, ListenerInvocationErrorHandler> listenerInvocationErrorHandler) {
        this.listenerInvocationErrorHandler.update(listenerInvocationErrorHandler);
        return this;
    }

    @Deprecated
    public SagaConfiguration<S> configureRollbackConfiguration(Function<Configuration, RollbackConfiguration> rollbackConfiguration) {
        this.rollbackConfiguration.update(rollbackConfiguration);
        return this;
    }

    @Deprecated
    public SagaConfiguration<S> configureTransactionManager(Function<Configuration, TransactionManager> transactionManager) {
        this.transactionManager.update(transactionManager);
        return this;
    }

    @Deprecated
    public SagaConfiguration<S> configureMessageMonitor(Function<Configuration, MessageMonitor<? super EventMessage<?>>> messageMonitor) {
        this.messageMonitor.update(messageMonitor);
        return this;
    }

    @Override
    public void initialize(Configuration config) {
        this.config = config;
        this.eventProcessingConfiguration().registerHandlerInvoker(this.processorInfo.getProcessingGroup(), c -> this.sagaManager.get());
        this.eventProcessingConfiguration().registerTokenStore(this.processorInfo.getProcessingGroup(), c -> this.tokenStore.get());
        this.eventProcessingConfiguration().configureMessageMonitor(this.processorInfo.getProcessingGroup(), c -> this.messageMonitor.get());
        this.eventProcessingConfiguration().configureErrorHandler(this.processorInfo.getProcessingGroup(), c -> this.errorHandler.get());
        this.eventProcessingConfiguration().configureRollbackConfiguration(this.processorInfo.getProcessingGroup(), c -> this.rollbackConfiguration.get());
        this.eventProcessingConfiguration().configureTransactionManager(this.processorInfo.getProcessingGroup(), c -> this.transactionManager.get());
        this.handlerInterceptors.forEach(i -> this.eventProcessingConfiguration().registerHandlerInterceptor(this.processorInfo.getProcessingGroup(), (Function<Configuration, MessageHandlerInterceptor<? super EventMessage<?>>>)i));
        if (this.processorInfo.isCreateNewProcessor()) {
            switch (this.processorInfo.getType()) {
                case TRACKING: {
                    this.eventProcessingConfiguration().registerEventProcessor(this.processorInfo.getProcessingGroup(), this::buildTrackingEventProcessor);
                    break;
                }
                case SUBSCRIBING: {
                    this.eventProcessingConfiguration().registerEventProcessor(this.processorInfo.getProcessingGroup(), this::buildSubscribingEventProcessor);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported event processor type.");
                }
            }
        }
    }

    private EventProcessor buildTrackingEventProcessor(String name, Configuration config, EventHandlerInvoker eventHandlerInvoker) {
        TrackingEventProcessor trackingEventProcessor = new TrackingEventProcessor(name, eventHandlerInvoker, this.streamableMessageSourceBuilder.apply(config), this.tokenStore.get(), this.transactionManager.get(), this.messageMonitor.get(), this.rollbackConfiguration.get(), this.errorHandler.get(), this.trackingEventProcessorConfiguration.get());
        trackingEventProcessor.registerInterceptor(new CorrelationDataInterceptor(config.correlationDataProviders()));
        return trackingEventProcessor;
    }

    private EventProcessor buildSubscribingEventProcessor(String name, Configuration config, EventHandlerInvoker eventHandlerInvoker) {
        SubscribingEventProcessor subscribingEventProcessor = new SubscribingEventProcessor(name, eventHandlerInvoker, this.rollbackConfiguration.get(), this.subscribableMessageSourceBuilder.apply(config), this.processingStrategy.apply(config), this.errorHandler.get(), this.messageMonitor.get());
        subscribingEventProcessor.registerInterceptor(new CorrelationDataInterceptor(config.correlationDataProviders()));
        return subscribingEventProcessor;
    }

    public EventProcessor getProcessor() {
        return this.eventProcessingConfiguration().eventProcessorByProcessingGroup(this.processorInfo.getProcessingGroup()).orElse(null);
    }

    public SagaStore<? super S> getSagaStore() {
        Assert.state(this.config != null, () -> "Configuration is not initialized yet");
        return this.sagaStore.get();
    }

    public SagaRepository<S> getSagaRepository() {
        Assert.state(this.config != null, () -> "Configuration is not initialized yet");
        return this.sagaRepository.get();
    }

    public AnnotatedSagaManager<S> getSagaManager() {
        Assert.state(this.config != null, () -> "Configuration is not initialized yet");
        return this.sagaManager.get();
    }

    private static String processingGroupName(Class<?> sagaType) {
        return AnnotationUtils.findAnnotationAttributes(sagaType, ProcessingGroup.class).map(attrs -> (String)attrs.get("processingGroup")).orElse(sagaType.getSimpleName() + "Processor");
    }

    private EventProcessingConfiguration eventProcessingConfiguration() {
        return this.config.eventProcessingConfiguration();
    }

    private static class ProcessorInfo {
        private final boolean createNewProcessor;
        private final ProcessorType type;
        private final String processingGroup;

        private ProcessorInfo(boolean createNewProcessor, ProcessorType type, String processingGroup) {
            this.createNewProcessor = createNewProcessor;
            this.type = type;
            this.processingGroup = processingGroup;
        }

        public boolean isCreateNewProcessor() {
            return this.createNewProcessor;
        }

        public ProcessorType getType() {
            return this.type;
        }

        public String getProcessingGroup() {
            return this.processingGroup;
        }

        private static enum ProcessorType {
            SUBSCRIBING,
            TRACKING;

        }
    }
}

