/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.axonframework.common.Assert;
import org.axonframework.common.transaction.NoTransactionManager;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.config.Component;
import org.axonframework.config.Configuration;
import org.axonframework.config.MessageMonitorFactory;
import org.axonframework.config.ModuleConfiguration;
import org.axonframework.eventhandling.DirectEventProcessingStrategy;
import org.axonframework.eventhandling.ErrorHandler;
import org.axonframework.eventhandling.EventHandlerInvoker;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.EventProcessor;
import org.axonframework.eventhandling.MultiEventHandlerInvoker;
import org.axonframework.eventhandling.PropagatingErrorHandler;
import org.axonframework.eventhandling.SubscribingEventProcessor;
import org.axonframework.eventhandling.TrackedEventMessage;
import org.axonframework.eventhandling.TrackingEventProcessor;
import org.axonframework.eventhandling.TrackingEventProcessorConfiguration;
import org.axonframework.eventhandling.tokenstore.TokenStore;
import org.axonframework.eventhandling.tokenstore.inmemory.InMemoryTokenStore;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.StreamableMessageSource;
import org.axonframework.messaging.SubscribableMessageSource;
import org.axonframework.messaging.interceptors.CorrelationDataInterceptor;
import org.axonframework.messaging.unitofwork.RollbackConfiguration;
import org.axonframework.messaging.unitofwork.RollbackConfigurationType;
import org.axonframework.monitoring.MessageMonitor;

public class EventProcessingConfiguration
implements ModuleConfiguration {
    private final Map<String, List<Function<Configuration, EventHandlerInvoker>>> invokerBuilders = new HashMap<String, List<Function<Configuration, EventHandlerInvoker>>>();
    private final Map<String, String> processingGroupsAssignments = new HashMap<String, String>();
    private Function<String, String> defaultProcessingGroupAssignment = Function.identity();
    private final Map<String, EventProcessorBuilder> eventProcessorBuilders = new HashMap<String, EventProcessorBuilder>();
    private final Map<String, Component<EventProcessor>> eventProcessors = new HashMap<String, Component<EventProcessor>>();
    private final List<BiFunction<Configuration, String, MessageHandlerInterceptor<? super EventMessage<?>>>> defaultHandlerInterceptors = new ArrayList();
    private final Map<String, List<Function<Configuration, MessageHandlerInterceptor<? super EventMessage<?>>>>> handlerInterceptorsBuilders = new HashMap();
    private final Map<String, Function<Configuration, ErrorHandler>> errorHandlers = new HashMap<String, Function<Configuration, ErrorHandler>>();
    private final Map<String, Function<Configuration, RollbackConfiguration>> rollbackConfigurations = new HashMap<String, Function<Configuration, RollbackConfiguration>>();
    private final Map<String, Function<Configuration, TransactionManager>> transactionManagers = new HashMap<String, Function<Configuration, TransactionManager>>();
    private final Map<String, MessageMonitorFactory> messageMonitorFactories = new HashMap<String, MessageMonitorFactory>();
    private final Map<String, Function<Configuration, TokenStore>> tokenStore = new HashMap<String, Function<Configuration, TokenStore>>();
    private EventProcessorBuilder defaultEventProcessorBuilder = this::defaultEventProcessor;
    private Configuration configuration;
    private final Component<ErrorHandler> defaultErrorHandler = new Component<ErrorHandler>(() -> this.configuration, "errorHandler", c -> c.getComponent(ErrorHandler.class, PropagatingErrorHandler::instance));
    private final Component<RollbackConfiguration> defaultRollbackConfiguration = new Component<RollbackConfiguration>(() -> this.configuration, "rollbackConfiguration", c -> c.getComponent(RollbackConfiguration.class, () -> RollbackConfigurationType.ANY_THROWABLE));
    private final Component<TransactionManager> defaultTransactionManager = new Component<TransactionManager>(() -> this.configuration, "transactionManager", c -> c.getComponent(TransactionManager.class, NoTransactionManager::instance));

    public EventProcessingConfiguration registerHandlerInvoker(String processingGroup, Function<Configuration, EventHandlerInvoker> eventHandlerInvokerBuilder) {
        List invokerBuilderFunctions = this.invokerBuilders.computeIfAbsent(processingGroup, k -> new ArrayList());
        invokerBuilderFunctions.add(eventHandlerInvokerBuilder);
        return this;
    }

    public EventProcessingConfiguration assignProcessingGroup(String processingGroup, String processorName) {
        this.processingGroupsAssignments.put(processingGroup, processorName);
        return this;
    }

    public EventProcessingConfiguration assignProcessingGroup(Function<String, String> assignmentRule) {
        this.defaultProcessingGroupAssignment = assignmentRule;
        return this;
    }

    public EventProcessingConfiguration registerEventProcessor(String name, EventProcessorBuilder eventProcessorBuilder) {
        if (this.eventProcessorBuilders.containsKey(name)) {
            throw new IllegalArgumentException(String.format("Event processor with name %s already exists", name));
        }
        this.eventProcessorBuilders.put(name, eventProcessorBuilder);
        return this;
    }

    public EventProcessingConfiguration registerTrackingEventProcessor(String name) {
        return this.registerTrackingEventProcessorUsingSource(name, Configuration::eventBus);
    }

    public EventProcessingConfiguration registerTrackingEventProcessorUsingSource(String name, Function<Configuration, StreamableMessageSource<TrackedEventMessage<?>>> source) {
        return this.registerTrackingEventProcessor(name, source, c -> c.getComponent(TrackingEventProcessorConfiguration.class, TrackingEventProcessorConfiguration::forSingleThreadedProcessing));
    }

    public EventProcessingConfiguration registerTrackingEventProcessor(String name, Function<Configuration, TrackingEventProcessorConfiguration> processorConfiguration) {
        return this.registerTrackingEventProcessor(name, Configuration::eventBus, processorConfiguration);
    }

    public EventProcessingConfiguration registerTrackingEventProcessor(String name, Function<Configuration, StreamableMessageSource<TrackedEventMessage<?>>> source, Function<Configuration, TrackingEventProcessorConfiguration> processorConfiguration) {
        this.registerEventProcessor(name, (n, c, ehi) -> this.trackingEventProcessor(c, n, ehi, processorConfiguration, source));
        return this;
    }

    public EventProcessingConfiguration registerSubscribingEventProcessor(String name) {
        return this.registerSubscribingEventProcessor(name, Configuration::eventBus);
    }

    public EventProcessingConfiguration registerSubscribingEventProcessor(String name, Function<Configuration, SubscribableMessageSource<? extends EventMessage<?>>> messageSource) {
        this.registerEventProcessor(name, (n, c, ehi) -> this.subscribingEventProcessor(n, c, ehi, messageSource));
        return this;
    }

    public EventProcessingConfiguration usingTrackingProcessors() {
        return this.usingTrackingProcessors(c -> c.getComponent(TrackingEventProcessorConfiguration.class, TrackingEventProcessorConfiguration::forSingleThreadedProcessing));
    }

    public EventProcessingConfiguration usingTrackingProcessors(Function<Configuration, TrackingEventProcessorConfiguration> processorConfig) {
        this.registerEventProcessorFactory((name, config, ehi) -> {
            TrackingEventProcessor trackingEventProcessor = this.trackingEventProcessor(config, name, ehi, processorConfig, Configuration::eventBus);
            trackingEventProcessor.registerInterceptor(new CorrelationDataInterceptor(config.correlationDataProviders()));
            return trackingEventProcessor;
        });
        return this;
    }

    public EventProcessingConfiguration registerTokenStore(String name, Function<Configuration, TokenStore> tokenStore) {
        this.tokenStore.put(name, tokenStore);
        return this;
    }

    public EventProcessingConfiguration registerHandlerInterceptor(String processorName, Function<Configuration, MessageHandlerInterceptor<? super EventMessage<?>>> interceptorBuilder) {
        if (this.configuration != null) {
            this.eventProcessor(processorName).ifPresent(eventProcessor -> eventProcessor.registerInterceptor((MessageHandlerInterceptor)interceptorBuilder.apply(this.configuration)));
        }
        this.handlerInterceptorsBuilders.computeIfAbsent(processorName, k -> new ArrayList()).add(interceptorBuilder);
        return this;
    }

    public EventProcessingConfiguration registerHandlerInterceptor(BiFunction<Configuration, String, MessageHandlerInterceptor<? super EventMessage<?>>> interceptorBuilder) {
        this.defaultHandlerInterceptors.add(interceptorBuilder);
        return this;
    }

    public List<MessageHandlerInterceptor<? super EventMessage<?>>> interceptorsFor(String processorName) {
        Assert.state(this.configuration != null, () -> "Configuration is not initialized yet");
        Component<EventProcessor> eventProcessorComponent = this.eventProcessors.get(processorName);
        if (eventProcessorComponent == null) {
            return Collections.emptyList();
        }
        return eventProcessorComponent.get().getHandlerInterceptors();
    }

    public EventProcessingConfiguration registerEventProcessorFactory(EventProcessorBuilder eventProcessorBuilder) {
        this.defaultEventProcessorBuilder = eventProcessorBuilder;
        return this;
    }

    public EventProcessingConfiguration configureErrorHandler(Function<Configuration, ErrorHandler> errorHandlerBuilder) {
        this.defaultErrorHandler.update(errorHandlerBuilder);
        return this;
    }

    public EventProcessingConfiguration configureErrorHandler(String name, Function<Configuration, ErrorHandler> errorHandlerBuilder) {
        this.errorHandlers.put(name, errorHandlerBuilder);
        return this;
    }

    public EventProcessingConfiguration configureRollbackConfiguration(String name, Function<Configuration, RollbackConfiguration> rollbackConfigurationBuilder) {
        this.rollbackConfigurations.put(name, rollbackConfigurationBuilder);
        return this;
    }

    public EventProcessingConfiguration configureTransactionManager(String name, Function<Configuration, TransactionManager> transactionManagerBuilder) {
        this.transactionManagers.put(name, transactionManagerBuilder);
        return this;
    }

    public EventProcessingConfiguration configureMessageMonitor(String name, Function<Configuration, MessageMonitor<Message<?>>> messageMonitorBuilder) {
        return this.configureMessageMonitor(name, (Configuration configuration, Class<?> componentType, String componentName) -> (MessageMonitor)messageMonitorBuilder.apply(configuration));
    }

    public EventProcessingConfiguration configureMessageMonitor(String name, MessageMonitorFactory messageMonitorFactory) {
        this.messageMonitorFactories.put(name, messageMonitorFactory);
        return this;
    }

    public Map<String, EventProcessor> eventProcessors() {
        Assert.state(this.configuration != null, () -> "Configuration is not initialized yet");
        HashMap<String, EventProcessor> result = new HashMap<String, EventProcessor>(this.eventProcessors.size());
        this.eventProcessors.forEach((name, component) -> {
            EventProcessor cfr_ignored_0 = (EventProcessor)result.put((String)name, (EventProcessor)component.get());
        });
        return result;
    }

    public <T extends EventProcessor> Optional<T> eventProcessor(String name) {
        return Optional.ofNullable(this.eventProcessors().get(name));
    }

    public <T extends EventProcessor> Optional<T> eventProcessor(String name, Class<T> expectedType) {
        return this.eventProcessor(name).filter(expectedType::isInstance).map(expectedType::cast);
    }

    public <T extends EventProcessor> Optional<T> eventProcessorByProcessingGroup(String processingGroup) {
        return Optional.ofNullable(this.eventProcessors().get(this.processorNameForProcessingGroup(processingGroup)));
    }

    public <T extends EventProcessor> Optional<T> eventProcessorByProcessingGroup(String processingGroup, Class<T> expectedType) {
        return this.eventProcessorByProcessingGroup(processingGroup).filter(expectedType::isInstance).map(expectedType::cast);
    }

    @Override
    public int phase() {
        return 10;
    }

    @Override
    public void initialize(Configuration config) {
        this.configuration = config;
        this.eventProcessors.clear();
        HashMap<String, List> builderFunctionsPerProcessor = new HashMap<String, List>();
        this.invokerBuilders.forEach((processingGroup, builderFunctions) -> {
            String processorName = this.processorNameForProcessingGroup((String)processingGroup);
            builderFunctionsPerProcessor.compute(processorName, (k, currentBuilderFunctions) -> {
                if (currentBuilderFunctions == null) {
                    return builderFunctions;
                }
                currentBuilderFunctions.addAll(builderFunctions);
                return currentBuilderFunctions;
            });
        });
        builderFunctionsPerProcessor.forEach((processorName, builderFunctions) -> this.eventProcessors.put((String)processorName, new Component<EventProcessor>(config, (String)processorName, c -> this.buildEventProcessor(config, (List<Function<Configuration, EventHandlerInvoker>>)builderFunctions, (String)processorName))));
    }

    @Override
    public void start() {
        this.eventProcessors.forEach((name, component) -> ((EventProcessor)component.get()).start());
    }

    @Override
    public void shutdown() {
        this.eventProcessors.forEach((name, component) -> ((EventProcessor)component.get()).shutDown());
    }

    private SubscribingEventProcessor defaultEventProcessor(String name, Configuration conf, EventHandlerInvoker eventHandlerInvoker) {
        SubscribingEventProcessor eventProcessor = this.subscribingEventProcessor(name, conf, eventHandlerInvoker, Configuration::eventBus);
        eventProcessor.registerInterceptor(new CorrelationDataInterceptor(conf.correlationDataProviders()));
        return eventProcessor;
    }

    private SubscribingEventProcessor subscribingEventProcessor(String name, Configuration conf, EventHandlerInvoker eventHandlerInvoker, Function<Configuration, SubscribableMessageSource<? extends EventMessage<?>>> messageSource) {
        return new SubscribingEventProcessor(name, eventHandlerInvoker, this.getRollbackConfiguration(conf, name), messageSource.apply(conf), DirectEventProcessingStrategy.INSTANCE, this.getErrorHandler(conf, name), this.getMessageMonitor(conf, SubscribingEventProcessor.class, name));
    }

    private TrackingEventProcessor trackingEventProcessor(Configuration conf, String name, EventHandlerInvoker eventHandlerInvoker, Function<Configuration, TrackingEventProcessorConfiguration> config, Function<Configuration, StreamableMessageSource<TrackedEventMessage<?>>> source) {
        return new TrackingEventProcessor(name, eventHandlerInvoker, source.apply(conf), this.tokenStore.getOrDefault(name, c -> c.getComponent(TokenStore.class, InMemoryTokenStore::new)).apply(conf), this.getTransactionManager(conf, name), this.getMessageMonitor(conf, EventProcessor.class, name), this.getRollbackConfiguration(conf, name), this.getErrorHandler(conf, name), config.apply(conf));
    }

    private MessageMonitor<? super Message<?>> getMessageMonitor(Configuration config, Class<?> componentType, String componentName) {
        if (this.messageMonitorFactories.containsKey(componentName)) {
            return this.messageMonitorFactories.get(componentName).create(config, componentType, componentName);
        }
        return config.messageMonitor(componentType, componentName);
    }

    private ErrorHandler getErrorHandler(Configuration config, String componentName) {
        return this.errorHandlers.containsKey(componentName) ? this.errorHandlers.get(componentName).apply(config) : this.defaultErrorHandler.get();
    }

    private RollbackConfiguration getRollbackConfiguration(Configuration config, String componentName) {
        return this.rollbackConfigurations.containsKey(componentName) ? this.rollbackConfigurations.get(componentName).apply(config) : this.defaultRollbackConfiguration.get();
    }

    private TransactionManager getTransactionManager(Configuration config, String componentName) {
        return this.transactionManagers.containsKey(componentName) ? this.transactionManagers.get(componentName).apply(config) : this.defaultTransactionManager.get();
    }

    private String processorNameForProcessingGroup(String processingGroup) {
        return this.processingGroupsAssignments.getOrDefault(processingGroup, this.defaultProcessingGroupAssignment.apply(processingGroup));
    }

    private EventProcessor buildEventProcessor(Configuration config, List<Function<Configuration, EventHandlerInvoker>> builderFunctions, String processorName) {
        List<EventHandlerInvoker> invokers = builderFunctions.stream().map(invokerBuilder -> (EventHandlerInvoker)invokerBuilder.apply(config)).collect(Collectors.toList());
        MultiEventHandlerInvoker multiEventHandlerInvoker = new MultiEventHandlerInvoker(invokers);
        EventProcessor eventProcessor = this.eventProcessorBuilders.getOrDefault(processorName, this.defaultEventProcessorBuilder).build(processorName, this.configuration, multiEventHandlerInvoker);
        ((List)this.handlerInterceptorsBuilders.getOrDefault(processorName, new ArrayList())).stream().map(hi -> (MessageHandlerInterceptor)hi.apply(config)).forEach(eventProcessor::registerInterceptor);
        this.defaultHandlerInterceptors.stream().map(f -> (MessageHandlerInterceptor)f.apply(this.configuration, processorName)).filter(Objects::nonNull).forEach(eventProcessor::registerInterceptor);
        return eventProcessor;
    }

    @FunctionalInterface
    public static interface EventProcessorBuilder {
        public EventProcessor build(String var1, Configuration var2, EventHandlerInvoker var3);
    }
}

