/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.axonframework.common.Assert;
import org.axonframework.common.annotation.AnnotationUtils;
import org.axonframework.common.transaction.NoTransactionManager;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.config.Component;
import org.axonframework.config.Configuration;
import org.axonframework.config.MessageMonitorFactory;
import org.axonframework.config.ModuleConfiguration;
import org.axonframework.config.ProcessingGroup;
import org.axonframework.eventhandling.ErrorHandler;
import org.axonframework.eventhandling.EventHandlerInvoker;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.EventProcessor;
import org.axonframework.eventhandling.ListenerInvocationErrorHandler;
import org.axonframework.eventhandling.LoggingErrorHandler;
import org.axonframework.eventhandling.MultiEventHandlerInvoker;
import org.axonframework.eventhandling.PropagatingErrorHandler;
import org.axonframework.eventhandling.SimpleEventHandlerInvoker;
import org.axonframework.eventhandling.TrackedEventMessage;
import org.axonframework.eventhandling.TrackingEventProcessor;
import org.axonframework.eventhandling.TrackingEventProcessorConfiguration;
import org.axonframework.eventhandling.async.SequencingPolicy;
import org.axonframework.eventhandling.async.SequentialPerAggregatePolicy;
import org.axonframework.eventhandling.tokenstore.TokenStore;
import org.axonframework.eventhandling.tokenstore.inmemory.InMemoryTokenStore;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.StreamableMessageSource;
import org.axonframework.messaging.SubscribableMessageSource;
import org.axonframework.messaging.interceptors.CorrelationDataInterceptor;
import org.axonframework.messaging.unitofwork.RollbackConfigurationType;
import org.axonframework.monitoring.MessageMonitor;

public class EventHandlingConfiguration
implements ModuleConfiguration {
    private final Map<String, BiConsumer<Configuration, List<?>>> eventProcessorBuilders = new HashMap();
    private final List<Consumer<Configuration>> onInit = new ArrayList<Consumer<Configuration>>();
    private final List<Component<Object>> eventHandlers = new ArrayList<Component<Object>>();
    private final List<BiFunction<Configuration, String, MessageHandlerInterceptor<? super EventMessage<?>>>> defaultHandlerInterceptors = new ArrayList();
    private final Map<String, Function<Configuration, SequencingPolicy<? super EventMessage<?>>>> sequencingPolicies = new HashMap();
    private final Map<String, List<Function<Configuration, MessageHandlerInterceptor<? super EventMessage<?>>>>> handlerInterceptors = new HashMap();
    private final List<ProcessorSelector> selectors = new ArrayList<ProcessorSelector>();
    private final Map<String, Function<Configuration, ListenerInvocationErrorHandler>> listenerInvocationErrorHandlers = new HashMap<String, Function<Configuration, ListenerInvocationErrorHandler>>();
    @Deprecated
    private final Map<String, MessageMonitorFactory> messageMonitorFactories = new HashMap<String, MessageMonitorFactory>();
    @Deprecated
    private final Map<String, Function<Configuration, ErrorHandler>> errorHandlers = new HashMap<String, Function<Configuration, ErrorHandler>>();
    @Deprecated
    private final Map<String, Function<Configuration, TokenStore>> tokenStore = new HashMap<String, Function<Configuration, TokenStore>>();
    private Function<Object, String> fallback = o -> o.getClass().getPackage().getName();
    private final ProcessorSelector defaultSelector = new ProcessorSelector(Integer.MIN_VALUE, o -> {
        Class<?> handlerType = o.getClass();
        Optional<Map<String, Object>> annAttr = AnnotationUtils.findAnnotationAttributes(handlerType, ProcessingGroup.class);
        return Optional.of(annAttr.map(attr -> (String)attr.get("processingGroup")).orElseGet(() -> this.fallback.apply(o)));
    });
    private Configuration config;
    private final Component<SequencingPolicy<? super EventMessage<?>>> defaultSequencingPolicy = new Component<SequencingPolicy>(() -> this.config, "sequencingPolicy", c -> SequentialPerAggregatePolicy.instance());
    private final Component<ListenerInvocationErrorHandler> defaultListenerInvocationErrorHandler = new Component<ListenerInvocationErrorHandler>(() -> this.config, "listenerInvocationErrorHandler", c -> c.getComponent(ListenerInvocationErrorHandler.class, LoggingErrorHandler::new));
    @Deprecated
    private final Component<ErrorHandler> defaultErrorHandler = new Component<ErrorHandler>(() -> this.config, "errorHandler", c -> c.getComponent(ErrorHandler.class, PropagatingErrorHandler::instance));

    @Deprecated
    public List<MessageHandlerInterceptor<? super EventMessage<?>>> interceptorsFor(Configuration configuration, String processorName) {
        ArrayList interceptors = new ArrayList();
        this.defaultHandlerInterceptors.stream().map(f -> (MessageHandlerInterceptor)f.apply(configuration, processorName)).filter(Objects::nonNull).forEach(interceptors::add);
        this.handlerInterceptors.getOrDefault(processorName, Collections.emptyList()).stream().map(f -> (MessageHandlerInterceptor)f.apply(configuration)).filter(Objects::nonNull).forEach(interceptors::add);
        interceptors.add(new CorrelationDataInterceptor(configuration.correlationDataProviders()));
        return interceptors;
    }

    @Deprecated
    public EventHandlingConfiguration usingTrackingProcessors() {
        return this.usingTrackingProcessors(c -> c.getComponent(TrackingEventProcessorConfiguration.class, TrackingEventProcessorConfiguration::forSingleThreadedProcessing), c -> SequentialPerAggregatePolicy.instance());
    }

    @Deprecated
    public EventHandlingConfiguration usingTrackingProcessors(Function<Configuration, TrackingEventProcessorConfiguration> config, Function<Configuration, SequencingPolicy<? super EventMessage<?>>> sequencingPolicy) {
        return this.registerEventProcessorFactory((conf, name, handlers) -> this.buildTrackingEventProcessor(conf, name, handlers, config, Configuration::eventBus, sequencingPolicy));
    }

    @Deprecated
    public EventHandlingConfiguration registerTrackingProcessor(String name) {
        return this.registerTrackingProcessor(name, Configuration::eventBus);
    }

    @Deprecated
    public EventHandlingConfiguration registerTrackingProcessor(String name, Function<Configuration, StreamableMessageSource<TrackedEventMessage<?>>> source) {
        return this.registerTrackingProcessor(name, source, c -> c.getComponent(TrackingEventProcessorConfiguration.class, TrackingEventProcessorConfiguration::forSingleThreadedProcessing), c -> c.getComponent(SequencingPolicy.class, SequentialPerAggregatePolicy::instance));
    }

    @Deprecated
    public EventHandlingConfiguration registerTrackingProcessor(String name, Function<Configuration, TrackingEventProcessorConfiguration> processorConfiguration, Function<Configuration, SequencingPolicy<? super EventMessage<?>>> sequencingPolicy) {
        return this.registerTrackingProcessor(name, Configuration::eventBus, processorConfiguration, sequencingPolicy);
    }

    @Deprecated
    public EventHandlingConfiguration registerTrackingProcessor(String name, Function<Configuration, StreamableMessageSource<TrackedEventMessage<?>>> source, Function<Configuration, TrackingEventProcessorConfiguration> processorConfiguration, Function<Configuration, SequencingPolicy<? super EventMessage<?>>> sequencingPolicy) {
        this.eventProcessorBuilders.put(name, (conf, handlers) -> conf.eventProcessingConfiguration().registerEventProcessor(name, (String n, Configuration c, EventHandlerInvoker ehi) -> this.buildTrackingEventProcessor(c, n, (List<?>)handlers, processorConfiguration, source, sequencingPolicy)));
        return this;
    }

    private EventProcessor buildTrackingEventProcessor(Configuration conf, String name, List<?> handlers, Function<Configuration, TrackingEventProcessorConfiguration> config, Function<Configuration, StreamableMessageSource<TrackedEventMessage<?>>> source, Function<Configuration, SequencingPolicy<? super EventMessage<?>>> sequencingPolicy) {
        return new TrackingEventProcessor(name, new SimpleEventHandlerInvoker(handlers, conf.parameterResolverFactory(), this.getListenerInvocationErrorHandler(conf, name), sequencingPolicy.apply(conf)), source.apply(conf), this.tokenStore.getOrDefault(name, c -> c.getComponent(TokenStore.class, InMemoryTokenStore::new)).apply(conf), conf.getComponent(TransactionManager.class, NoTransactionManager::instance), this.getMessageMonitor(conf, EventProcessor.class, name), RollbackConfigurationType.ANY_THROWABLE, this.getErrorHandler(conf, name), config.apply(conf));
    }

    private ListenerInvocationErrorHandler getListenerInvocationErrorHandler(Configuration config, String componentName) {
        return this.listenerInvocationErrorHandlers.containsKey(componentName) ? this.listenerInvocationErrorHandlers.get(componentName).apply(config) : this.defaultListenerInvocationErrorHandler.get();
    }

    private SequencingPolicy<? super EventMessage<?>> getSequencingPolicy(Configuration config, String componentName) {
        return this.sequencingPolicies.containsKey(componentName) ? this.sequencingPolicies.get(componentName).apply(config) : this.defaultSequencingPolicy.get();
    }

    private MessageMonitor<? super Message<?>> getMessageMonitor(Configuration configuration, Class<?> componentType, String componentName) {
        if (this.messageMonitorFactories.containsKey(componentName)) {
            return this.messageMonitorFactories.get(componentName).create(configuration, componentType, componentName);
        }
        return configuration.messageMonitor(componentType, componentName);
    }

    private ErrorHandler getErrorHandler(Configuration config, String componentName) {
        return this.errorHandlers.containsKey(componentName) ? this.errorHandlers.get(componentName).apply(config) : this.defaultErrorHandler.get();
    }

    @Deprecated
    public EventHandlingConfiguration registerEventProcessorFactory(EventProcessorBuilder eventProcessorBuilder) {
        this.onInit.add(conf -> conf.eventProcessingConfiguration().registerEventProcessorFactory((String name, Configuration config, EventHandlerInvoker eventHandlerInvoker) -> this.buildEventProcessor(name, config, (MultiEventHandlerInvoker)eventHandlerInvoker, eventProcessorBuilder)));
        return this;
    }

    private EventProcessor buildEventProcessor(String processorName, Configuration config, MultiEventHandlerInvoker eventHandlerInvoker, EventProcessorBuilder eventProcessorBuilder) {
        return eventProcessorBuilder.createEventProcessor(config, processorName, eventHandlerInvoker.delegates().stream().map(i -> ((SimpleEventHandlerInvoker)i).eventListeners()).flatMap(Collection::stream).collect(Collectors.toList()));
    }

    @Deprecated
    public EventHandlingConfiguration registerEventProcessor(String name, EventProcessorBuilder eventProcessorBuilder) {
        this.eventProcessorBuilders.put(name, (config, handlers) -> config.eventProcessingConfiguration().registerEventProcessor(name, (String n, Configuration c, EventHandlerInvoker ehi) -> eventProcessorBuilder.createEventProcessor(c, n, (List<?>)handlers)));
        return this;
    }

    @Deprecated
    public EventHandlingConfiguration registerHandlerInterceptor(String processorName, Function<Configuration, MessageHandlerInterceptor<? super EventMessage<?>>> interceptorBuilder) {
        this.handlerInterceptors.computeIfAbsent(processorName, k -> new ArrayList()).add(interceptorBuilder);
        return this;
    }

    @Deprecated
    public EventHandlingConfiguration registerHandlerInterceptor(BiFunction<Configuration, String, MessageHandlerInterceptor<? super EventMessage<?>>> interceptorBuilder) {
        this.defaultHandlerInterceptors.add(interceptorBuilder);
        return this;
    }

    public EventHandlingConfiguration byDefaultAssignTo(String processingGroup) {
        return this.byDefaultAssignTo((Object object) -> processingGroup);
    }

    public EventHandlingConfiguration byDefaultAssignTo(Function<Object, String> assignmentFunction) {
        this.fallback = assignmentFunction;
        return this;
    }

    public EventHandlingConfiguration assignHandlersMatching(String processingGroup, Predicate<Object> criteria) {
        return this.assignHandlersMatching(processingGroup, 0, criteria);
    }

    public EventHandlingConfiguration assignHandlersMatching(String name, int priority, Predicate<Object> criteria) {
        this.selectors.add(new ProcessorSelector(name, priority, criteria));
        return this;
    }

    public EventHandlingConfiguration registerSequencingPolicy(String name, Function<Configuration, SequencingPolicy<? super EventMessage<?>>> policyBuilder) {
        this.sequencingPolicies.put(name, policyBuilder);
        return this;
    }

    public EventHandlingConfiguration registerDefaultSequencingPolicy(Function<Configuration, SequencingPolicy<? super EventMessage<?>>> policyBuilder) {
        this.defaultSequencingPolicy.update(policyBuilder);
        return this;
    }

    public EventHandlingConfiguration registerEventHandler(Function<Configuration, Object> eventHandlerBuilder) {
        this.eventHandlers.add(new Component<Object>(() -> this.config, "eventHandler", eventHandlerBuilder));
        return this;
    }

    @Override
    public void initialize(Configuration config) {
        this.selectors.sort(Comparator.comparing(ProcessorSelector::getPriority).reversed());
        this.config = config;
        HashMap<String, List> assignments = new HashMap<String, List>();
        this.eventHandlers.stream().map(Component::get).forEach(handler -> {
            String processor = this.selectors.stream().map(s -> s.select(handler)).filter(Optional::isPresent).map(Optional::get).findFirst().orElseGet(() -> this.defaultSelector.select(handler).orElseThrow(IllegalStateException::new));
            assignments.computeIfAbsent(processor, k -> new ArrayList()).add(handler);
        });
        this.onInit.forEach(h -> h.accept(config));
        assignments.forEach((name, handlers) -> {
            config.eventProcessingConfiguration().registerHandlerInvoker((String)name, c -> new SimpleEventHandlerInvoker((List<?>)handlers, c.parameterResolverFactory(), this.getListenerInvocationErrorHandler((Configuration)c, (String)name), this.getSequencingPolicy((Configuration)c, (String)name)));
            if (this.eventProcessorBuilders.containsKey(name)) {
                this.eventProcessorBuilders.get(name).accept(config, (List<?>)handlers);
            }
            this.interceptorsFor(config, (String)name).forEach(i -> config.eventProcessingConfiguration().registerHandlerInterceptor((String)name, c -> i));
        });
    }

    private SequencingPolicy<? super EventMessage<?>> getSequencingPolicy(String name, Configuration configuration) {
        if (this.sequencingPolicies.containsKey(name)) {
            return this.sequencingPolicies.get(name).apply(configuration);
        }
        return this.defaultSequencingPolicy.get();
    }

    @Override
    public void start() {
    }

    @Override
    public void shutdown() {
    }

    @Deprecated
    public EventHandlingConfiguration registerSubscribingEventProcessor(String name) {
        return this.registerSubscribingEventProcessor(name, Configuration::eventBus);
    }

    @Deprecated
    public EventHandlingConfiguration registerSubscribingEventProcessor(String name, Function<Configuration, SubscribableMessageSource<? extends EventMessage<?>>> messageSource) {
        this.onInit.add(conf -> conf.eventProcessingConfiguration().registerSubscribingEventProcessor(name, messageSource));
        return this;
    }

    @Deprecated
    public EventHandlingConfiguration registerTokenStore(String name, Function<Configuration, TokenStore> tokenStore) {
        this.tokenStore.put(name, tokenStore);
        this.onInit.add(conf -> conf.eventProcessingConfiguration().registerTokenStore(name, tokenStore));
        return this;
    }

    @Deprecated
    public List<EventProcessor> getProcessors() {
        Assert.state(this.config != null, () -> "Configuration is not initialized yet");
        return new ArrayList<EventProcessor>(this.config.eventProcessingConfiguration().eventProcessors().values());
    }

    @Deprecated
    public <T extends EventProcessor> Optional<T> getProcessor(String name) {
        Assert.state(this.config != null, () -> "Configuration is not initialized yet");
        return this.config.eventProcessingConfiguration().eventProcessor(name);
    }

    @Deprecated
    public <T extends EventProcessor> Optional<T> getProcessor(String name, Class<T> expectedType) {
        Assert.state(this.config != null, () -> "Configuration is not initialized yet");
        return this.config.eventProcessingConfiguration().eventProcessor(name, expectedType);
    }

    public EventHandlingConfiguration configureListenerInvocationErrorHandler(Function<Configuration, ListenerInvocationErrorHandler> listenerInvocationErrorHandlerBuilder) {
        this.defaultListenerInvocationErrorHandler.update(listenerInvocationErrorHandlerBuilder);
        return this;
    }

    public EventHandlingConfiguration configureListenerInvocationErrorHandler(String processingGroup, Function<Configuration, ListenerInvocationErrorHandler> listenerInvocationErrorHandlerBuilder) {
        this.listenerInvocationErrorHandlers.put(processingGroup, listenerInvocationErrorHandlerBuilder);
        return this;
    }

    public EventHandlingConfiguration configureSequencingPolicy(Function<Configuration, SequencingPolicy<? super EventMessage<?>>> sequencingPolicyBuilder) {
        this.defaultSequencingPolicy.update(sequencingPolicyBuilder);
        return this;
    }

    public EventHandlingConfiguration configureSequencingPolicy(String processingGroup, Function<Configuration, SequencingPolicy<? super EventMessage<?>>> sequencingPolicyBuilder) {
        this.sequencingPolicies.put(processingGroup, sequencingPolicyBuilder);
        return this;
    }

    @Deprecated
    public EventHandlingConfiguration configureMessageMonitor(String name, Function<Configuration, MessageMonitor<Message<?>>> messageMonitorBuilder) {
        return this.configureMessageMonitor(name, (Configuration configuration, Class<?> componentType, String componentName) -> (MessageMonitor)messageMonitorBuilder.apply(configuration));
    }

    @Deprecated
    public EventHandlingConfiguration configureMessageMonitor(String name, MessageMonitorFactory messageMonitorFactory) {
        this.messageMonitorFactories.put(name, messageMonitorFactory);
        this.onInit.add(conf -> conf.eventProcessingConfiguration().configureMessageMonitor(name, messageMonitorFactory));
        return this;
    }

    @Deprecated
    public EventHandlingConfiguration configureErrorHandler(Function<Configuration, ErrorHandler> errorHandlerBuilder) {
        this.defaultErrorHandler.update(errorHandlerBuilder);
        this.onInit.add(conf -> conf.eventProcessingConfiguration().configureErrorHandler(errorHandlerBuilder));
        return this;
    }

    @Deprecated
    public EventHandlingConfiguration configureErrorHandler(String name, Function<Configuration, ErrorHandler> errorHandlerBuilder) {
        this.errorHandlers.put(name, errorHandlerBuilder);
        this.onInit.add(conf -> conf.eventProcessingConfiguration().configureErrorHandler(name, errorHandlerBuilder));
        return this;
    }

    private static class ProcessorSelector {
        private final int priority;
        private final Function<Object, Optional<String>> function;

        private ProcessorSelector(int priority, Function<Object, Optional<String>> selectorFunction) {
            this.priority = priority;
            this.function = selectorFunction;
        }

        private ProcessorSelector(String name, int priority, Predicate<Object> criteria) {
            this(priority, handler -> {
                if (criteria.test(handler)) {
                    return Optional.of(name);
                }
                return Optional.empty();
            });
        }

        public Optional<String> select(Object handler) {
            return this.function.apply(handler);
        }

        public int getPriority() {
            return this.priority;
        }
    }

    @FunctionalInterface
    @Deprecated
    public static interface EventProcessorBuilder {
        public EventProcessor createEventProcessor(Configuration var1, String var2, List<?> var3);
    }
}

