/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.config;

import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.gateway.CommandGateway;
import org.axonframework.commandhandling.model.Repository;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.config.EventProcessingConfiguration;
import org.axonframework.config.ModuleConfiguration;
import org.axonframework.deadline.DeadlineManager;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.saga.ResourceInjector;
import org.axonframework.eventhandling.saga.repository.NoResourceInjector;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.correlation.CorrelationDataProvider;
import org.axonframework.monitoring.MessageMonitor;
import org.axonframework.queryhandling.QueryBus;
import org.axonframework.queryhandling.QueryGateway;
import org.axonframework.queryhandling.QueryUpdateEmitter;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.upcasting.event.EventUpcasterChain;

public interface Configuration {
    default public EventBus eventBus() {
        return this.getComponent(EventBus.class);
    }

    default public EventStore eventStore() {
        EventBus eventBus = this.eventBus();
        if (!(eventBus instanceof EventStore)) {
            throw new AxonConfigurationException("A component is requesting an Event Store, however, there is none configured");
        }
        return (EventStore)eventBus;
    }

    default public <T extends ModuleConfiguration> List<T> findModules(Class<T> moduleType) {
        return this.getModules().stream().filter(m -> moduleType.isInstance(m.unwrap())).map(m -> m.unwrap()).collect(Collectors.toList());
    }

    default public EventProcessingConfiguration eventProcessingConfiguration() {
        List<EventProcessingConfiguration> modules = this.findModules(EventProcessingConfiguration.class);
        switch (modules.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return modules.get(0);
            }
        }
        throw new AxonConfigurationException("Found more than one EventProcessingConfiguration modules");
    }

    default public CommandBus commandBus() {
        return this.getComponent(CommandBus.class);
    }

    default public QueryBus queryBus() {
        return this.getComponent(QueryBus.class);
    }

    default public QueryUpdateEmitter queryUpdateEmitter() {
        return this.getComponent(QueryUpdateEmitter.class);
    }

    default public ResourceInjector resourceInjector() {
        return this.getComponent(ResourceInjector.class, () -> NoResourceInjector.INSTANCE);
    }

    default public CommandGateway commandGateway() {
        return this.getComponent(CommandGateway.class);
    }

    default public QueryGateway queryGateway() {
        return this.getComponent(QueryGateway.class);
    }

    public <T> Repository<T> repository(Class<T> var1);

    default public <T> T getComponent(Class<T> componentType) {
        return (T)this.getComponent(componentType, () -> null);
    }

    public <T> T getComponent(Class<T> var1, Supplier<T> var2);

    public <M extends Message<?>> MessageMonitor<? super M> messageMonitor(Class<?> var1, String var2);

    default public Serializer serializer() {
        return this.getComponent(Serializer.class);
    }

    public Serializer eventSerializer();

    public Serializer messageSerializer();

    public void start();

    public void shutdown();

    public List<CorrelationDataProvider> correlationDataProviders();

    default public ParameterResolverFactory parameterResolverFactory() {
        return this.getComponent(ParameterResolverFactory.class);
    }

    public HandlerDefinition handlerDefinition(Class<?> var1);

    default public DeadlineManager deadlineManager() {
        return this.getComponent(DeadlineManager.class);
    }

    public List<ModuleConfiguration> getModules();

    default public void onStart(Runnable startHandler) {
        this.onStart(0, startHandler);
    }

    public void onStart(int var1, Runnable var2);

    default public void onShutdown(Runnable shutdownHandler) {
        this.onShutdown(0, shutdownHandler);
    }

    public void onShutdown(int var1, Runnable var2);

    public EventUpcasterChain upcasterChain();
}

