/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.config;

import java.util.function.Function;
import java.util.function.Supplier;
import org.axonframework.common.Assert;
import org.axonframework.config.Configuration;

public class Component<B> {
    private final String name;
    private final Supplier<Configuration> configuration;
    private Function<Configuration, ? extends B> builderFunction;
    private B instance;

    public Component(Configuration config, String name, Function<Configuration, ? extends B> builderFunction) {
        this(() -> config, name, builderFunction);
    }

    public Component(Supplier<Configuration> config, String name, Function<Configuration, ? extends B> builderFunction) {
        this.configuration = config;
        this.name = name;
        this.builderFunction = builderFunction;
    }

    public B get() {
        if (this.instance == null) {
            this.instance = this.builderFunction.apply(this.configuration.get());
        }
        return this.instance;
    }

    public void update(Function<Configuration, ? extends B> builderFunction) {
        Assert.state(this.instance == null, () -> "Cannot change " + this.name + ": it is already in use");
        this.builderFunction = builderFunction;
    }
}

