/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.lock;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.axonframework.common.Assert;
import org.axonframework.common.lock.DeadlockException;
import org.axonframework.common.lock.Lock;
import org.axonframework.common.lock.LockAcquisitionFailedException;
import org.axonframework.common.lock.LockFactory;

public class PessimisticLockFactory
implements LockFactory {
    private static final Set<PessimisticLockFactory> INSTANCES = Collections.newSetFromMap(Collections.synchronizedMap(new WeakHashMap()));
    private final ConcurrentHashMap<String, DisposableLock> locks = new ConcurrentHashMap();
    private final BackoffParameters backoffParameters;

    private static Set<Thread> threadsWaitingForMyLocks(Thread owner) {
        return PessimisticLockFactory.threadsWaitingForMyLocks(owner, INSTANCES);
    }

    private static Set<Thread> threadsWaitingForMyLocks(Thread owner, Set<PessimisticLockFactory> locksInUse) {
        HashSet<Thread> waitingThreads = new HashSet<Thread>();
        for (PessimisticLockFactory lock : locksInUse) {
            lock.locks.values().stream().filter(disposableLock -> disposableLock.isHeldBy(owner)).forEach(disposableLock -> disposableLock.queuedThreads().stream().filter(waitingThreads::add).forEach(thread -> waitingThreads.addAll(PessimisticLockFactory.threadsWaitingForMyLocks(thread, locksInUse))));
        }
        return waitingThreads;
    }

    @Deprecated
    public PessimisticLockFactory() {
        this(new BackoffParameters(-1, -1, 100));
    }

    public PessimisticLockFactory(BackoffParameters backoffParameters) {
        this.backoffParameters = backoffParameters;
        INSTANCES.add(this);
    }

    @Override
    public Lock obtainLock(String identifier) {
        boolean lockObtained = false;
        DisposableLock lock = null;
        while (!lockObtained) {
            lock = this.lockFor(identifier);
            lockObtained = lock.lock();
            if (lockObtained) continue;
            this.locks.remove(identifier, lock);
        }
        return lock;
    }

    private DisposableLock lockFor(String identifier) {
        DisposableLock lock = this.locks.get(identifier);
        while (lock == null) {
            this.locks.putIfAbsent(identifier, new DisposableLock(identifier));
            lock = this.locks.get(identifier);
        }
        return lock;
    }

    private class DisposableLock
    implements Lock {
        private final String identifier;
        private final PubliclyOwnedReentrantLock lock;
        private volatile boolean isClosed = false;

        private DisposableLock(String identifier) {
            this.identifier = identifier;
            this.lock = new PubliclyOwnedReentrantLock();
        }

        @Override
        public void release() {
            try {
                this.lock.unlock();
            }
            finally {
                this.disposeIfUnused();
            }
        }

        @Override
        public boolean isHeld() {
            return this.lock.isHeldByCurrentThread();
        }

        public boolean lock() {
            if (PessimisticLockFactory.this.backoffParameters.maximumQueuedThreadsReached(this.lock.getQueueLength())) {
                throw new LockAcquisitionFailedException("Failed to acquire lock for aggregate identifier " + this.identifier + ": too many queued threads.");
            }
            try {
                if (!this.lock.tryLock(0L, TimeUnit.NANOSECONDS)) {
                    int attempts = ((PessimisticLockFactory)PessimisticLockFactory.this).backoffParameters.acquireAttempts - 1;
                    do {
                        this.checkForDeadlock();
                        if (!PessimisticLockFactory.this.backoffParameters.hasAcquireAttemptLimit() || --attempts >= 1) continue;
                        throw new LockAcquisitionFailedException("Failed to acquire lock for aggregate identifier(" + this.identifier + "), maximum attempts exceeded (" + ((PessimisticLockFactory)PessimisticLockFactory.this).backoffParameters.maximumQueued + ")");
                    } while (!this.lock.tryLock(((PessimisticLockFactory)PessimisticLockFactory.this).backoffParameters.lockAttemptTimeout, TimeUnit.MILLISECONDS));
                }
            }
            catch (InterruptedException e) {
                throw new LockAcquisitionFailedException("Thread was interrupted", e);
            }
            if (this.isClosed) {
                this.lock.unlock();
                return false;
            }
            return true;
        }

        private void checkForDeadlock() {
            if (!this.lock.isHeldByCurrentThread() && this.lock.isLocked()) {
                for (Thread thread : PessimisticLockFactory.threadsWaitingForMyLocks(Thread.currentThread())) {
                    if (!this.lock.isHeldBy(thread)) continue;
                    throw new DeadlockException("An imminent deadlock was detected while attempting to acquire a lock");
                }
            }
        }

        private void disposeIfUnused() {
            if (this.lock.tryLock()) {
                try {
                    if (this.lock.getHoldCount() == 1) {
                        this.isClosed = true;
                        PessimisticLockFactory.this.locks.remove(this.identifier, this);
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
        }

        public Collection<Thread> queuedThreads() {
            return this.lock.getQueuedThreads();
        }

        public boolean isHeldBy(Thread owner) {
            return this.lock.isHeldBy(owner);
        }
    }

    private static final class PubliclyOwnedReentrantLock
    extends ReentrantLock {
        private static final long serialVersionUID = -2259228494514612163L;

        private PubliclyOwnedReentrantLock() {
        }

        @Override
        public Collection<Thread> getQueuedThreads() {
            return super.getQueuedThreads();
        }

        public boolean isHeldBy(Thread thread) {
            return thread.equals(this.getOwner());
        }
    }

    public static final class BackoffParameters {
        public final int acquireAttempts;
        public final int maximumQueued;
        public final int lockAttemptTimeout;

        public BackoffParameters(int acquireAttempts, int maximumQueued, int lockAttemptTimeout) {
            Assert.isTrue(acquireAttempts > 0 || acquireAttempts == -1, () -> "acquireAttempts needs to be a positive integer or -1, but was '" + acquireAttempts + "'");
            this.acquireAttempts = acquireAttempts;
            Assert.isTrue(maximumQueued > 0 || maximumQueued == -1, () -> "maximumQueued needs to be a positive integer or -1, but was '" + maximumQueued + "'");
            this.maximumQueued = maximumQueued;
            Assert.isFalse(lockAttemptTimeout < 0, () -> "lockAttemptTimeout needs to be a non negative integer, but was '" + lockAttemptTimeout + "'");
            this.lockAttemptTimeout = lockAttemptTimeout;
        }

        public boolean hasAcquireAttemptLimit() {
            return this.acquireAttempts != -1;
        }

        public boolean hasAcquireQueueLimit() {
            return this.maximumQueued != -1;
        }

        public boolean maximumQueuedThreadsReached(int queueLength) {
            if (!this.hasAcquireQueueLimit()) {
                return false;
            }
            return queueLength >= this.maximumQueued;
        }
    }
}

