/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common;

import java.util.function.Supplier;

public abstract class Assert {
    private Assert() {
    }

    public static void state(boolean state, Supplier<String> messageSupplier) {
        if (!state) {
            throw new IllegalStateException(messageSupplier.get());
        }
    }

    public static void isTrue(boolean expression, Supplier<String> messageSupplier) {
        if (!expression) {
            throw new IllegalArgumentException(messageSupplier.get());
        }
    }

    public static void isFalse(boolean expression, Supplier<String> messageSupplier) {
        if (expression) {
            throw new IllegalArgumentException(messageSupplier.get());
        }
    }

    public static void notNull(Object value, Supplier<String> messageSupplier) {
        Assert.isTrue(value != null, messageSupplier);
    }

    public static <T> T nonNull(T value, Supplier<String> messageSupplier) {
        Assert.isTrue(value != null, messageSupplier);
        return value;
    }
}

