/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.model.inspection;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Pattern;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.model.CommandHandlerInterceptor;
import org.axonframework.commandhandling.model.inspection.CommandHandlerInterceptorHandlingMember;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.messaging.InterceptorChain;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.HandlerEnhancerDefinition;
import org.axonframework.messaging.annotation.MessageHandlingMember;
import org.axonframework.messaging.annotation.WrappedMessageHandlingMember;

public class MethodCommandHandlerInterceptorDefinition
implements HandlerEnhancerDefinition {
    @Override
    public <T> MessageHandlingMember<T> wrapHandler(MessageHandlingMember<T> original) {
        return original.annotationAttributes(CommandHandlerInterceptor.class).map(attr -> new MethodCommandHandlerInterceptorHandlingMember(original, (Map)attr)).orElse(original);
    }

    private static class MethodCommandHandlerInterceptorHandlingMember<T>
    extends WrappedMessageHandlingMember<T>
    implements CommandHandlerInterceptorHandlingMember<T> {
        private final Pattern commandNamePattern;
        private final boolean shouldInvokeInterceptorChain;

        private MethodCommandHandlerInterceptorHandlingMember(MessageHandlingMember<T> delegate, Map<String, Object> annotationAttributes) {
            super(delegate);
            Method method = delegate.unwrap(Method.class).orElseThrow(() -> new AxonConfigurationException("The @CommandHandlerInterceptor must be on method."));
            this.shouldInvokeInterceptorChain = Arrays.stream(method.getParameters()).noneMatch(p -> p.getType().equals(InterceptorChain.class));
            if (this.shouldInvokeInterceptorChain && !Void.TYPE.equals(method.getReturnType())) {
                throw new AxonConfigurationException("@CommandHandlerInterceptor must return void or declare InterceptorChain parameter.");
            }
            this.commandNamePattern = Pattern.compile((String)annotationAttributes.get("commandNamePattern"));
        }

        @Override
        public boolean shouldInvokeInterceptorChain() {
            return this.shouldInvokeInterceptorChain;
        }

        @Override
        public boolean canHandle(Message<?> message) {
            return super.canHandle(message) && this.commandNamePattern.matcher(((CommandMessage)message).getCommandName()).matches();
        }
    }
}

