/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.model.inspection;

import java.util.List;
import java.util.Map;
import org.axonframework.commandhandling.NoHandlerForCommandException;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.annotation.MessageHandlingMember;

public interface EntityModel<T> {
    public Object getIdentifier(T var1);

    public String routingKey();

    public void publish(EventMessage<?> var1, T var2);

    public Map<String, MessageHandlingMember<? super T>> commandHandlers();

    public List<MessageHandlingMember<? super T>> commandHandlerInterceptors();

    default public MessageHandlingMember<? super T> commandHandler(String commandName) {
        MessageHandlingMember<T> handler = this.commandHandlers().get(commandName);
        if (handler == null) {
            throw new NoHandlerForCommandException(String.format("No handler available to handle command [%s]", commandName));
        }
        return handler;
    }

    public <C> EntityModel<C> modelOf(Class<? extends C> var1);

    public Class<? extends T> entityClass();
}

