/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.model.inspection;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.model.inspection.ChildEntity;
import org.axonframework.commandhandling.model.inspection.ChildForwardingCommandMessageHandlingMember;
import org.axonframework.commandhandling.model.inspection.EntityModel;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.annotation.MessageHandlingMember;

public class AnnotatedChildEntity<P, C>
implements ChildEntity<P> {
    private final EntityModel<C> entityModel;
    private final Map<String, MessageHandlingMember<? super P>> commandHandlers;
    private final BiFunction<EventMessage<?>, P, Stream<C>> eventTargetResolver;

    public AnnotatedChildEntity(EntityModel<C> entityModel, boolean forwardCommands, BiFunction<CommandMessage<?>, P, C> commandTargetResolver, BiFunction<EventMessage<?>, P, Stream<C>> eventTargetResolver) {
        this.entityModel = entityModel;
        this.eventTargetResolver = eventTargetResolver;
        this.commandHandlers = new HashMap<String, MessageHandlingMember<? super P>>();
        if (forwardCommands) {
            entityModel.commandHandlers().forEach((commandType, childHandler) -> {
                MessageHandlingMember cfr_ignored_0 = this.commandHandlers.put((String)commandType, new ChildForwardingCommandMessageHandlingMember(entityModel.commandHandlerInterceptors(), childHandler, commandTargetResolver));
            });
        }
    }

    @Override
    public void publish(EventMessage<?> msg, P declaringInstance) {
        this.eventTargetResolver.apply(msg, declaringInstance).collect(Collectors.toList()).forEach(target -> this.entityModel.publish(msg, target));
    }

    @Override
    public Map<String, MessageHandlingMember<? super P>> commandHandlers() {
        return this.commandHandlers;
    }
}

