/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.model.inspection;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.axonframework.commandhandling.NoHandlerForCommandException;
import org.axonframework.commandhandling.model.AggregateRoot;
import org.axonframework.commandhandling.model.AggregateVersion;
import org.axonframework.commandhandling.model.EntityId;
import org.axonframework.commandhandling.model.inspection.AggregateMetaModelFactory;
import org.axonframework.commandhandling.model.inspection.AggregateModel;
import org.axonframework.commandhandling.model.inspection.ChildEntity;
import org.axonframework.commandhandling.model.inspection.ChildEntityDefinition;
import org.axonframework.commandhandling.model.inspection.CommandHandlerInterceptorHandlingMember;
import org.axonframework.commandhandling.model.inspection.CommandMessageHandlingMember;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.IdentifierValidator;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.common.annotation.AnnotationUtils;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.AnnotatedHandlerInspector;
import org.axonframework.messaging.annotation.ClasspathHandlerDefinition;
import org.axonframework.messaging.annotation.ClasspathParameterResolverFactory;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.MessageHandlerInvocationException;
import org.axonframework.messaging.annotation.MessageHandlingMember;
import org.axonframework.messaging.annotation.ParameterResolverFactory;

public class AnnotatedAggregateMetaModelFactory
implements AggregateMetaModelFactory {
    private final Map<Class<?>, AnnotatedAggregateModel> registry;
    private final ParameterResolverFactory parameterResolverFactory;
    private final HandlerDefinition handlerDefinition;

    public AnnotatedAggregateMetaModelFactory() {
        this(ClasspathParameterResolverFactory.forClassLoader(Thread.currentThread().getContextClassLoader()));
    }

    public AnnotatedAggregateMetaModelFactory(ParameterResolverFactory parameterResolverFactory) {
        this(parameterResolverFactory, ClasspathHandlerDefinition.forClassLoader(Thread.currentThread().getContextClassLoader()));
    }

    public AnnotatedAggregateMetaModelFactory(ParameterResolverFactory parameterResolverFactory, HandlerDefinition handlerDefinition) {
        this.parameterResolverFactory = parameterResolverFactory;
        this.handlerDefinition = handlerDefinition;
        this.registry = new ConcurrentHashMap();
    }

    public static <T> AggregateModel<T> inspectAggregate(Class<T> aggregateType) {
        return new AnnotatedAggregateMetaModelFactory().createModel(aggregateType);
    }

    public static <T> AggregateModel<T> inspectAggregate(Class<T> aggregateType, ParameterResolverFactory parameterResolverFactory) {
        return new AnnotatedAggregateMetaModelFactory(parameterResolverFactory).createModel(aggregateType);
    }

    public static <T> AggregateModel<T> inspectAggregate(Class<T> aggregateType, ParameterResolverFactory parameterResolverFactory, HandlerDefinition handlerDefinition) {
        return new AnnotatedAggregateMetaModelFactory(parameterResolverFactory, handlerDefinition).createModel(aggregateType);
    }

    public <T> AnnotatedAggregateModel<T> createModel(Class<? extends T> aggregateType) {
        if (!this.registry.containsKey(aggregateType)) {
            AnnotatedHandlerInspector<? extends T> inspector = AnnotatedHandlerInspector.inspectType(aggregateType, this.parameterResolverFactory, this.handlerDefinition);
            AnnotatedAggregateModel<? extends T> model = new AnnotatedAggregateModel<T>(aggregateType, inspector);
            this.registry.put(aggregateType, model);
            ((AnnotatedAggregateModel)model).initialize();
        }
        return this.registry.get(aggregateType);
    }

    private class AnnotatedAggregateModel<T>
    implements AggregateModel<T> {
        private final Class<? extends T> inspectedType;
        private final List<ChildEntity<T>> children;
        private final AnnotatedHandlerInspector<T> handlerInspector;
        private final List<MessageHandlingMember<? super T>> commandHandlerInterceptors;
        private final Map<String, MessageHandlingMember<? super T>> commandHandlers;
        private final List<MessageHandlingMember<? super T>> eventHandlers;
        private String aggregateType;
        private Field identifierField;
        private Field versionField;
        private String routingKey;

        public AnnotatedAggregateModel(Class<? extends T> aggregateType, AnnotatedHandlerInspector<T> handlerInspector) {
            this.inspectedType = aggregateType;
            this.commandHandlerInterceptors = new ArrayList<MessageHandlingMember<? super T>>();
            this.commandHandlers = new HashMap<String, MessageHandlingMember<? super T>>();
            this.eventHandlers = new ArrayList<MessageHandlingMember<? super T>>();
            this.children = new ArrayList<ChildEntity<T>>();
            this.handlerInspector = handlerInspector;
        }

        private void initialize() {
            this.inspectAggregateType();
            this.inspectFields();
            this.prepareHandlers();
        }

        private void prepareHandlers() {
            for (MessageHandlingMember<T> handler : this.handlerInspector.getHandlers()) {
                Optional<CommandMessageHandlingMember> commandHandler = handler.unwrap(CommandMessageHandlingMember.class);
                Optional<CommandHandlerInterceptorHandlingMember> unwrappedCommandHandlerInterceptor = handler.unwrap(CommandHandlerInterceptorHandlingMember.class);
                if (commandHandler.isPresent()) {
                    this.commandHandlers.putIfAbsent(commandHandler.get().commandName(), handler);
                    continue;
                }
                if (unwrappedCommandHandlerInterceptor.isPresent()) {
                    this.commandHandlerInterceptors.add(handler);
                    continue;
                }
                this.eventHandlers.add(handler);
            }
        }

        private void inspectAggregateType() {
            this.aggregateType = AnnotationUtils.findAnnotationAttributes(this.inspectedType, AggregateRoot.class).map(map -> (String)map.get("type")).filter(i -> i.length() > 0).orElse(this.inspectedType.getSimpleName());
        }

        private void inspectFields() {
            ServiceLoader<ChildEntityDefinition> childEntityDefinitions = ServiceLoader.load(ChildEntityDefinition.class, this.inspectedType.getClassLoader());
            for (Field field : ReflectionUtils.fieldsOf(this.inspectedType)) {
                childEntityDefinitions.forEach(def -> def.createChildDefinition(field, this).ifPresent(child -> {
                    this.children.add((ChildEntity<T>)child);
                    child.commandHandlers().forEach(this.commandHandlers::putIfAbsent);
                }));
                AnnotationUtils.findAnnotationAttributes((AnnotatedElement)field, EntityId.class).ifPresent(attributes -> {
                    this.identifierField = field;
                    this.routingKey = !"".equals(attributes.get("routingKey")) ? (String)attributes.get("routingKey") : field.getName();
                });
                if (this.identifierField == null) {
                    AnnotationUtils.findAnnotationAttributes((AnnotatedElement)field, "javax.persistence.Id").ifPresent(a -> {
                        this.identifierField = field;
                        this.routingKey = field.getName();
                    });
                }
                if (this.identifierField != null) {
                    Class<?> idClazz = this.identifierField.getType();
                    if (!IdentifierValidator.getInstance().isValidIdentifier(idClazz)) {
                        throw new AxonConfigurationException(String.format("Aggregate identifier type [%s] should override Object.toString()", idClazz.getName()));
                    }
                }
                AnnotationUtils.findAnnotationAttributes((AnnotatedElement)field, AggregateVersion.class).ifPresent(attributes -> {
                    this.versionField = field;
                });
            }
        }

        private AnnotatedAggregateModel<T> runtimeModelOf(T target) {
            return this.modelOf(target.getClass());
        }

        @Override
        public Map<String, MessageHandlingMember<? super T>> commandHandlers() {
            return Collections.unmodifiableMap(this.commandHandlers);
        }

        @Override
        public MessageHandlingMember<? super T> commandHandler(String commandName) {
            MessageHandlingMember<? super T> handler = this.commandHandlers.get(commandName);
            if (handler == null) {
                throw new NoHandlerForCommandException(String.format("No handler available to handle command [%s]", commandName));
            }
            return handler;
        }

        @Override
        public <C> AnnotatedAggregateModel<C> modelOf(Class<? extends C> entityType) {
            return AnnotatedAggregateMetaModelFactory.this.createModel(entityType);
        }

        @Override
        public Class<? extends T> entityClass() {
            return this.inspectedType;
        }

        @Override
        public void publish(EventMessage<?> message, T target) {
            if (target != null) {
                super.doPublish(message, target);
            }
        }

        private void doPublish(EventMessage<?> message, T target) {
            this.getHandler(message).ifPresent(h -> {
                try {
                    h.handle(message, target);
                }
                catch (Exception e) {
                    throw new MessageHandlerInvocationException(String.format("Error handling event of type [%s] in aggregate", message.getPayloadType()), e);
                }
            });
            this.children.forEach(i -> i.publish(message, target));
        }

        @Override
        public String type() {
            return this.aggregateType;
        }

        @Override
        public Long getVersion(T target) {
            if (this.versionField != null) {
                return (Long)ReflectionUtils.getFieldValue(this.versionField, target);
            }
            return null;
        }

        @Override
        public List<MessageHandlingMember<? super T>> commandHandlerInterceptors() {
            return Collections.unmodifiableList(this.commandHandlerInterceptors);
        }

        protected Optional<MessageHandlingMember<? super T>> getHandler(Message<?> message) {
            for (MessageHandlingMember<T> handler : this.eventHandlers) {
                if (!handler.canHandle(message)) continue;
                return Optional.of(handler);
            }
            return Optional.empty();
        }

        @Override
        public Object getIdentifier(T target) {
            if (this.identifierField != null) {
                return ReflectionUtils.getFieldValue(this.identifierField, target);
            }
            return null;
        }

        @Override
        public String routingKey() {
            return this.routingKey;
        }
    }
}

