/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.model.inspection;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.model.Aggregate;
import org.axonframework.commandhandling.model.AggregateInvocationException;
import org.axonframework.commandhandling.model.AggregateLifecycle;
import org.axonframework.commandhandling.model.ApplyMore;
import org.axonframework.commandhandling.model.Repository;
import org.axonframework.commandhandling.model.RepositoryProvider;
import org.axonframework.commandhandling.model.inspection.AggregateModel;
import org.axonframework.commandhandling.model.inspection.AnnotatedCommandHandlerInterceptor;
import org.axonframework.common.Assert;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventsourcing.DomainEventMessage;
import org.axonframework.eventsourcing.GenericDomainEventMessage;
import org.axonframework.messaging.DefaultInterceptorChain;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.annotation.MessageHandlingMember;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;

public class AnnotatedAggregate<T>
extends AggregateLifecycle
implements Aggregate<T>,
ApplyMore {
    private final AggregateModel<T> inspector;
    private final RepositoryProvider repositoryProvider;
    private final Queue<Runnable> delayedTasks = new LinkedList<Runnable>();
    private final EventBus eventBus;
    private T aggregateRoot;
    private boolean applying = false;
    private boolean isDeleted = false;
    private Long lastKnownSequence;

    protected AnnotatedAggregate(T aggregateRoot, AggregateModel<T> model, EventBus eventBus) {
        this(aggregateRoot, model, eventBus, null);
    }

    protected AnnotatedAggregate(T aggregateRoot, AggregateModel<T> model, EventBus eventBus, RepositoryProvider repositoryProvider) {
        this(model, eventBus, repositoryProvider);
        this.aggregateRoot = aggregateRoot;
    }

    protected AnnotatedAggregate(AggregateModel<T> inspector, EventBus eventBus) {
        this(inspector, eventBus, null);
    }

    protected AnnotatedAggregate(AggregateModel<T> inspector, EventBus eventBus, RepositoryProvider repositoryProvider) {
        this.inspector = inspector;
        this.eventBus = eventBus;
        this.repositoryProvider = repositoryProvider;
    }

    public static <T> AnnotatedAggregate<T> initialize(Callable<T> aggregateFactory, AggregateModel<T> aggregateModel, EventBus eventBus) throws Exception {
        return AnnotatedAggregate.initialize(aggregateFactory, aggregateModel, eventBus, false);
    }

    public static <T> AnnotatedAggregate<T> initialize(Callable<T> aggregateFactory, AggregateModel<T> aggregateModel, EventBus eventBus, RepositoryProvider repositoryProvider) throws Exception {
        return AnnotatedAggregate.initialize(aggregateFactory, aggregateModel, eventBus, repositoryProvider, false);
    }

    public static <T> AnnotatedAggregate<T> initialize(Callable<T> aggregateFactory, AggregateModel<T> aggregateModel, EventBus eventBus, boolean generateSequences) throws Exception {
        return AnnotatedAggregate.initialize(aggregateFactory, aggregateModel, eventBus, null, generateSequences);
    }

    public static <T> AnnotatedAggregate<T> initialize(Callable<T> aggregateFactory, AggregateModel<T> aggregateModel, EventBus eventBus, RepositoryProvider repositoryProvider, boolean generateSequences) throws Exception {
        AnnotatedAggregate<T> aggregate = new AnnotatedAggregate<T>(aggregateModel, eventBus, repositoryProvider);
        if (generateSequences) {
            aggregate.initSequence();
        }
        aggregate.registerRoot(aggregateFactory);
        return aggregate;
    }

    public static <T> AnnotatedAggregate<T> initialize(T aggregateRoot, AggregateModel<T> aggregateModel, EventBus eventBus) {
        return AnnotatedAggregate.initialize(aggregateRoot, aggregateModel, eventBus, null);
    }

    public static <T> AnnotatedAggregate<T> initialize(T aggregateRoot, AggregateModel<T> aggregateModel, EventBus eventBus, RepositoryProvider repositoryProvider) {
        return new AnnotatedAggregate<T>(aggregateRoot, aggregateModel, eventBus, repositoryProvider);
    }

    public void initSequence() {
        this.initSequence(-1L);
    }

    public void initSequence(long lastKnownSequenceNumber) {
        this.lastKnownSequence = lastKnownSequenceNumber;
    }

    protected void registerRoot(Callable<T> aggregateFactory) throws Exception {
        this.aggregateRoot = this.executeWithResult(aggregateFactory);
        this.execute(() -> {
            this.applying = true;
            while (!this.delayedTasks.isEmpty()) {
                this.delayedTasks.remove().run();
            }
            this.applying = false;
        });
    }

    @Override
    public String type() {
        return this.inspector.type();
    }

    @Override
    public Object identifier() {
        return this.inspector.getIdentifier(this.aggregateRoot);
    }

    @Override
    public Long version() {
        return this.inspector.getVersion(this.aggregateRoot);
    }

    public Long lastSequence() {
        return this.lastKnownSequence == -1L ? null : this.lastKnownSequence;
    }

    @Override
    protected boolean getIsLive() {
        return true;
    }

    protected <R> Aggregate<R> doCreateNew(Class<R> aggregateType, Callable<R> factoryMethod) throws Exception {
        if (this.repositoryProvider == null) {
            throw new AxonConfigurationException(String.format("Since repository provider is not provided, we cannot spawn a new aggregate for %s", aggregateType.getName()));
        }
        Repository<R> repository = this.repositoryProvider.repositoryFor(aggregateType);
        if (repository == null) {
            throw new IllegalStateException(String.format("There is no configured repository for %s", aggregateType.getName()));
        }
        return repository.newInstance(factoryMethod);
    }

    @Override
    public <R> R invoke(Function<T, R> invocation) {
        try {
            return (R)this.executeWithResult(() -> invocation.apply(this.aggregateRoot));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AggregateInvocationException("Exception occurred while invoking an aggregate", e);
        }
    }

    @Override
    public void execute(Consumer<T> invocation) {
        this.execute(() -> invocation.accept(this.aggregateRoot));
    }

    @Override
    public boolean isDeleted() {
        return this.isDeleted;
    }

    @Override
    public Class<? extends T> rootType() {
        return this.aggregateRoot.getClass();
    }

    @Override
    protected void doMarkDeleted() {
        this.isDeleted = true;
    }

    protected void publish(EventMessage<?> msg) {
        if (msg instanceof DomainEventMessage) {
            this.lastKnownSequence = ((DomainEventMessage)msg).getSequenceNumber();
        }
        this.inspector.publish(msg, this.aggregateRoot);
        this.publishOnEventBus(msg);
    }

    protected void publishOnEventBus(EventMessage<?> msg) {
        if (this.eventBus != null) {
            this.eventBus.publish(msg);
        }
    }

    @Override
    public Object handle(Message<?> message) throws Exception {
        Callable<Object> messageHandling;
        if (message instanceof CommandMessage) {
            messageHandling = () -> this.handle((CommandMessage)message);
        } else if (message instanceof EventMessage) {
            messageHandling = () -> this.handle((EventMessage)message);
        } else {
            throw new IllegalArgumentException("Unsupported message type: " + message.getClass());
        }
        return this.executeWithResult(messageHandling);
    }

    @Override
    private Object handle(CommandMessage<?> commandMessage) throws Exception {
        List interceptors = this.inspector.commandHandlerInterceptors().stream().filter(chi -> chi.canHandle(commandMessage)).sorted((chi1, chi2) -> Integer.compare(chi2.priority(), chi1.priority())).map(chi -> new AnnotatedCommandHandlerInterceptor<T>(chi, this.aggregateRoot)).collect(Collectors.toList());
        MessageHandlingMember<T> handler = this.inspector.commandHandlers().get(commandMessage.getCommandName());
        Object result = interceptors.isEmpty() ? handler.handle(commandMessage, this.aggregateRoot) : new DefaultInterceptorChain<CommandMessage>(CurrentUnitOfWork.get(), interceptors, m -> handler.handle(commandMessage, this.aggregateRoot)).proceed();
        if (this.aggregateRoot == null) {
            this.aggregateRoot = result;
            return this.identifierAsString();
        }
        return result;
    }

    @Override
    private Object handle(EventMessage<?> eventMessage) {
        this.inspector.publish(eventMessage, this.aggregateRoot);
        return null;
    }

    protected <P> ApplyMore doApply(P payload, MetaData metaData) {
        if (!this.applying && this.aggregateRoot != null) {
            this.applying = true;
            try {
                this.publish(this.createMessage(payload, metaData));
                while (!this.delayedTasks.isEmpty()) {
                    this.delayedTasks.remove().run();
                }
            }
            finally {
                this.delayedTasks.clear();
                this.applying = false;
            }
        } else {
            this.delayedTasks.add(() -> this.publish(this.createMessage(payload, metaData)));
        }
        return this;
    }

    protected <P> EventMessage<P> createMessage(P payload, MetaData metaData) {
        if (this.lastKnownSequence != null) {
            long seq = this.lastKnownSequence + 1L;
            String id = this.identifierAsString();
            if (id == null) {
                Assert.state(seq == 0L, () -> "The aggregate identifier has not been set. It must be set at the latest when applying the creation event");
                return new LazyIdentifierDomainEventMessage<P>(this.type(), seq, payload, metaData);
            }
            return new GenericDomainEventMessage<P>(this.type(), this.identifierAsString(), seq, payload, metaData);
        }
        return new GenericEventMessage<P>(payload, metaData);
    }

    public T getAggregateRoot() {
        return this.aggregateRoot;
    }

    @Override
    public ApplyMore andThenApply(Supplier<?> payloadOrMessageSupplier) {
        return this.andThen(() -> this.applyMessageOrPayload(payloadOrMessageSupplier.get()));
    }

    @Override
    public ApplyMore andThen(Runnable runnable) {
        if (this.applying || this.aggregateRoot == null) {
            this.delayedTasks.add(runnable);
        } else {
            runnable.run();
        }
        return this;
    }

    protected void applyMessageOrPayload(Object payloadOrMessage) {
        if (payloadOrMessage instanceof Message) {
            Message message = (Message)payloadOrMessage;
            AnnotatedAggregate.apply(message.getPayload(), message.getMetaData());
        } else if (payloadOrMessage != null) {
            AnnotatedAggregate.apply(payloadOrMessage, MetaData.emptyInstance());
        }
    }

    private class LazyIdentifierDomainEventMessage<P>
    extends GenericDomainEventMessage<P> {
        private static final long serialVersionUID = -1624446038982565972L;

        public LazyIdentifierDomainEventMessage(String type, long seq, P payload, MetaData metaData) {
            super(type, null, seq, payload, metaData);
        }

        @Override
        public String getAggregateIdentifier() {
            return AnnotatedAggregate.this.identifierAsString();
        }

        @Override
        public GenericDomainEventMessage<P> withMetaData(Map<String, ?> newMetaData) {
            String identifier = AnnotatedAggregate.this.identifierAsString();
            if (identifier != null) {
                return new GenericDomainEventMessage(this.getType(), this.getAggregateIdentifier(), this.getSequenceNumber(), this.getPayload(), this.getMetaData(), this.getIdentifier(), this.getTimestamp());
            }
            return new LazyIdentifierDomainEventMessage(this.getType(), this.getSequenceNumber(), this.getPayload(), MetaData.from(newMetaData));
        }

        @Override
        public GenericDomainEventMessage<P> andMetaData(Map<String, ?> additionalMetaData) {
            String identifier = AnnotatedAggregate.this.identifierAsString();
            if (identifier != null) {
                return new GenericDomainEventMessage(this.getType(), this.getAggregateIdentifier(), this.getSequenceNumber(), this.getPayload(), this.getMetaData(), this.getIdentifier(), this.getTimestamp()).andMetaData((Map)additionalMetaData);
            }
            return new LazyIdentifierDomainEventMessage(this.getType(), this.getSequenceNumber(), this.getPayload(), this.getMetaData().mergedWith(additionalMetaData));
        }
    }
}

