/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.model;

import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Function;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import org.axonframework.commandhandling.model.AggregateNotFoundException;
import org.axonframework.commandhandling.model.LockingRepository;
import org.axonframework.commandhandling.model.RepositoryProvider;
import org.axonframework.commandhandling.model.inspection.AggregateModel;
import org.axonframework.commandhandling.model.inspection.AnnotatedAggregate;
import org.axonframework.common.Assert;
import org.axonframework.common.jpa.EntityManagerProvider;
import org.axonframework.common.lock.LockFactory;
import org.axonframework.common.lock.NullLockFactory;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.messaging.annotation.ClasspathHandlerDefinition;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.ParameterResolverFactory;

public class GenericJpaRepository<T>
extends LockingRepository<T, AnnotatedAggregate<T>> {
    private final EntityManagerProvider entityManagerProvider;
    private final EventBus eventBus;
    private final RepositoryProvider repositoryProvider;
    private final Function<String, ?> identifierConverter;
    private boolean forceFlushOnSave = true;

    public GenericJpaRepository(EntityManagerProvider entityManagerProvider, Class<T> aggregateType, EventBus eventBus) {
        this(entityManagerProvider, aggregateType, eventBus, (LockFactory)NullLockFactory.INSTANCE);
    }

    public GenericJpaRepository(EntityManagerProvider entityManagerProvider, Class<T> aggregateType, EventBus eventBus, RepositoryProvider repositoryProvider) {
        this(entityManagerProvider, aggregateType, eventBus, repositoryProvider, (LockFactory)NullLockFactory.INSTANCE);
    }

    public GenericJpaRepository(EntityManagerProvider entityManagerProvider, AggregateModel<T> aggregateModel, EventBus eventBus) {
        this(entityManagerProvider, aggregateModel, eventBus, (LockFactory)NullLockFactory.INSTANCE);
    }

    public GenericJpaRepository(EntityManagerProvider entityManagerProvider, AggregateModel<T> aggregateModel, EventBus eventBus, RepositoryProvider repositoryProvider) {
        this(entityManagerProvider, aggregateModel, eventBus, repositoryProvider, (LockFactory)NullLockFactory.INSTANCE);
    }

    public GenericJpaRepository(EntityManagerProvider entityManagerProvider, Class<T> aggregateType, EventBus eventBus, Function<String, ?> identifierConverter) {
        this(entityManagerProvider, aggregateType, eventBus, (LockFactory)NullLockFactory.INSTANCE, identifierConverter);
    }

    public GenericJpaRepository(EntityManagerProvider entityManagerProvider, Class<T> aggregateType, EventBus eventBus, RepositoryProvider repositoryProvider, Function<String, ?> identifierConverter) {
        this(entityManagerProvider, aggregateType, eventBus, repositoryProvider, (LockFactory)NullLockFactory.INSTANCE, identifierConverter);
    }

    public GenericJpaRepository(EntityManagerProvider entityManagerProvider, Class<T> aggregateType, EventBus eventBus, ParameterResolverFactory parameterResolverFactory) {
        this(entityManagerProvider, aggregateType, eventBus, (LockFactory)NullLockFactory.INSTANCE, parameterResolverFactory);
    }

    public GenericJpaRepository(EntityManagerProvider entityManagerProvider, Class<T> aggregateType, EventBus eventBus, RepositoryProvider repositoryProvider, ParameterResolverFactory parameterResolverFactory, HandlerDefinition handlerDefinition) {
        this(entityManagerProvider, aggregateType, eventBus, repositoryProvider, NullLockFactory.INSTANCE, parameterResolverFactory, handlerDefinition);
    }

    public GenericJpaRepository(EntityManagerProvider entityManagerProvider, Class<T> aggregateType, EventBus eventBus, LockFactory lockFactory) {
        this(entityManagerProvider, aggregateType, eventBus, lockFactory, Function.identity());
    }

    public GenericJpaRepository(EntityManagerProvider entityManagerProvider, Class<T> aggregateType, EventBus eventBus, RepositoryProvider repositoryProvider, LockFactory lockFactory) {
        this(entityManagerProvider, aggregateType, eventBus, repositoryProvider, lockFactory, Function.identity());
    }

    public GenericJpaRepository(EntityManagerProvider entityManagerProvider, AggregateModel<T> aggregateModel, EventBus eventBus, LockFactory lockFactory) {
        this(entityManagerProvider, aggregateModel, eventBus, lockFactory, Function.identity());
    }

    public GenericJpaRepository(EntityManagerProvider entityManagerProvider, AggregateModel<T> aggregateModel, EventBus eventBus, RepositoryProvider repositoryProvider, LockFactory lockFactory) {
        this(entityManagerProvider, aggregateModel, eventBus, repositoryProvider, lockFactory, Function.identity());
    }

    public GenericJpaRepository(EntityManagerProvider entityManagerProvider, Class<T> aggregateType, EventBus eventBus, LockFactory lockFactory, Function<String, ?> identifierConverter) {
        this(entityManagerProvider, aggregateType, eventBus, null, lockFactory, identifierConverter);
    }

    public GenericJpaRepository(EntityManagerProvider entityManagerProvider, Class<T> aggregateType, EventBus eventBus, RepositoryProvider repositoryProvider, LockFactory lockFactory, Function<String, ?> identifierConverter) {
        super(aggregateType, lockFactory);
        Assert.notNull(entityManagerProvider, () -> "entityManagerProvider may not be null");
        this.entityManagerProvider = entityManagerProvider;
        this.eventBus = eventBus;
        this.identifierConverter = identifierConverter;
        this.repositoryProvider = repositoryProvider;
    }

    public GenericJpaRepository(EntityManagerProvider entityManagerProvider, AggregateModel<T> aggregateModel, EventBus eventBus, LockFactory lockFactory, Function<String, ?> identifierConverter) {
        this(entityManagerProvider, aggregateModel, eventBus, null, lockFactory, identifierConverter);
    }

    public GenericJpaRepository(EntityManagerProvider entityManagerProvider, AggregateModel<T> aggregateModel, EventBus eventBus, RepositoryProvider repositoryProvider, LockFactory lockFactory, Function<String, ?> identifierConverter) {
        super(aggregateModel, lockFactory);
        Assert.notNull(entityManagerProvider, () -> "entityManagerProvider may not be null");
        this.entityManagerProvider = entityManagerProvider;
        this.eventBus = eventBus;
        this.identifierConverter = identifierConverter;
        this.repositoryProvider = repositoryProvider;
    }

    public GenericJpaRepository(EntityManagerProvider entityManagerProvider, Class<T> aggregateType, EventBus eventBus, LockFactory lockFactory, ParameterResolverFactory parameterResolverFactory) {
        this(entityManagerProvider, aggregateType, eventBus, lockFactory, parameterResolverFactory, Function.identity());
    }

    public GenericJpaRepository(EntityManagerProvider entityManagerProvider, Class<T> aggregateType, EventBus eventBus, RepositoryProvider repositoryProvider, LockFactory lockFactory, ParameterResolverFactory parameterResolverFactory, HandlerDefinition handlerDefinition) {
        this(entityManagerProvider, aggregateType, eventBus, repositoryProvider, lockFactory, parameterResolverFactory, handlerDefinition, Function.identity());
    }

    public GenericJpaRepository(EntityManagerProvider entityManagerProvider, Class<T> aggregateType, EventBus eventBus, LockFactory lockFactory, ParameterResolverFactory parameterResolverFactory, Function<String, ?> identifierConverter) {
        this(entityManagerProvider, aggregateType, eventBus, null, lockFactory, parameterResolverFactory, ClasspathHandlerDefinition.forClass(aggregateType), identifierConverter);
    }

    public GenericJpaRepository(EntityManagerProvider entityManagerProvider, Class<T> aggregateType, EventBus eventBus, RepositoryProvider repositoryProvider, LockFactory lockFactory, ParameterResolverFactory parameterResolverFactory, HandlerDefinition handlerDefinition, Function<String, ?> identifierConverter) {
        super(aggregateType, lockFactory, parameterResolverFactory, handlerDefinition);
        Assert.notNull(entityManagerProvider, () -> "entityManagerProvider may not be null");
        this.entityManagerProvider = entityManagerProvider;
        this.eventBus = eventBus;
        this.identifierConverter = identifierConverter;
        this.repositoryProvider = repositoryProvider;
    }

    @Override
    protected AnnotatedAggregate<T> doLoadWithLock(String aggregateIdentifier, Long expectedVersion) {
        Object aggregateRoot = this.entityManagerProvider.getEntityManager().find(this.getAggregateType(), this.identifierConverter.apply(aggregateIdentifier), LockModeType.PESSIMISTIC_WRITE);
        if (aggregateRoot == null) {
            throw new AggregateNotFoundException(aggregateIdentifier, String.format("Aggregate [%s] with identifier [%s] not found", this.getAggregateType().getSimpleName(), aggregateIdentifier));
        }
        AnnotatedAggregate<Object> aggregate = AnnotatedAggregate.initialize(aggregateRoot, this.aggregateModel(), this.eventBus, this.repositoryProvider);
        if (this.eventBus instanceof EventStore) {
            Optional<Long> sequenceNumber = ((EventStore)this.eventBus).lastSequenceNumberFor(aggregateIdentifier);
            sequenceNumber.ifPresent(aggregate::initSequence);
        }
        return aggregate;
    }

    @Override
    protected AnnotatedAggregate<T> doCreateNewForLock(Callable<T> factoryMethod) throws Exception {
        return AnnotatedAggregate.initialize(factoryMethod, this.aggregateModel(), this.eventBus, this.repositoryProvider, this.eventBus instanceof EventStore);
    }

    @Override
    protected void doSaveWithLock(AnnotatedAggregate<T> aggregate) {
        EntityManager entityManager = this.entityManagerProvider.getEntityManager();
        entityManager.persist(aggregate.getAggregateRoot());
        if (this.forceFlushOnSave) {
            entityManager.flush();
        }
    }

    @Override
    protected void doDeleteWithLock(AnnotatedAggregate<T> aggregate) {
        EntityManager entityManager = this.entityManagerProvider.getEntityManager();
        entityManager.remove(aggregate.getAggregateRoot());
        if (this.forceFlushOnSave) {
            entityManager.flush();
        }
    }

    public void setForceFlushOnSave(boolean forceFlushOnSave) {
        this.forceFlushOnSave = forceFlushOnSave;
    }
}

