/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Objects;
import java.util.function.Supplier;
import org.axonframework.common.Assert;
import org.axonframework.messaging.ScopeDescriptor;

public class AggregateScopeDescriptor
implements ScopeDescriptor {
    private static final long serialVersionUID = 3584695571254668002L;
    private final String type;
    private Object identifier;
    private transient Supplier<Object> identifierSupplier;

    public AggregateScopeDescriptor(String type, Supplier<Object> identifierSupplier) {
        Assert.notNull(identifierSupplier, () -> "A Supplier for the identifier field is required when using this constructor");
        this.type = type;
        this.identifierSupplier = identifierSupplier;
    }

    @JsonCreator
    public AggregateScopeDescriptor(@JsonProperty(value="type") String type, @JsonProperty(value="identifier") Object identifier) {
        this.type = type;
        this.identifier = identifier;
    }

    public String getType() {
        return this.type;
    }

    public Object getIdentifier() {
        if (this.identifier == null) {
            this.identifier = this.identifierSupplier.get();
        }
        return this.identifier;
    }

    @Override
    public String scopeDescription() {
        return String.format("AggregateScopeDescriptor for type [%s] and identifier [%s]", this.type, this.identifier);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.getIdentifier();
        out.defaultWriteObject();
    }

    public int hashCode() {
        return Objects.hash(this.type, this.identifierSupplier);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AggregateScopeDescriptor other = (AggregateScopeDescriptor)obj;
        return Objects.equals(this.type, other.type) && Objects.equals(this.identifier, other.identifier);
    }

    public String toString() {
        return "AggregateScopeDescriptor{type=" + this.type + ", identifier='" + this.identifier + '\'' + '}';
    }
}

